/*
 * Decompiled with CFR 0.152.
 */
package Framework.ClientManagers;

import Services.NetworkPacket;
import Services.NetworkToJavaConverter;

public class ClientInfo {
    private int MajorNumber;
    private int MinorNumber;
    private int listenPort;
    private String WWN;
    private String version;
    private String description;
    private static final int CLIENTINFO_LENGTH = 512;

    public void setMajorNumber(int MajorNumber) {
        this.MajorNumber = MajorNumber;
    }

    public int getMajorNumber() {
        return this.MajorNumber;
    }

    public void setMinorNumber(int MinorNumber) {
        this.MinorNumber = MinorNumber;
    }

    public int getMinorNumber() {
        return this.MinorNumber;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public void setWWN(String WWN) {
        this.WWN = WWN;
    }

    public void setVersion(byte[] version, int offset, int length) {
        this.version = new String(version, offset, length);
    }

    public void setDescription(byte[] description, int offset, int length) {
        this.description = new String(description, offset, length);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWWN() {
        return this.WWN;
    }

    public byte[] getBytes() {
        byte[] arrayByte = new byte[512];
        int byteIndex = 0;
        NetworkToJavaConverter.intToByteArray(this.MajorNumber, arrayByte);
        NetworkToJavaConverter.intToByteArray(this.MinorNumber, arrayByte, byteIndex += 4);
        NetworkToJavaConverter.intToByteArray(this.listenPort, arrayByte, byteIndex += 4);
        byte[] wwnArray = NetworkPacket.convertWWNStringToByteArray(this.WWN);
        System.arraycopy(wwnArray, 0, arrayByte, byteIndex += 4, wwnArray.length);
        byte[] versionArray = this.version.getBytes();
        System.arraycopy(versionArray, 0, arrayByte, byteIndex += wwnArray.length, versionArray.length >= 32 ? 32 : versionArray.length);
        byte[] descriptionArray = this.description.getBytes();
        System.arraycopy(descriptionArray, 0, arrayByte, byteIndex += 32, descriptionArray.length >= 256 ? 256 : descriptionArray.length);
        return arrayByte;
    }
}

