/*
 * Decompiled with CFR 0.152.
 */
package Framework.ClientManagers;

import Framework.ClientManagers.ClientInfo;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.WWNManager;
import java.util.Hashtable;

public class ClientManager {
    private static Hashtable clientHash = new Hashtable();
    private static int clientID = 0;

    public static void handleClientCall(NetworkPacket networkPacket) {
        switch (networkPacket.getRequestType()) {
            case 257: {
                ClientManager.handleRegisterCall(networkPacket);
                break;
            }
            case 268: {
                ClientManager.handleRemoteRegisterCall(networkPacket);
                break;
            }
            case 258: {
                ClientManager.handleUnRegisterCall(networkPacket);
            }
        }
    }

    private static void handleUnRegisterCall(NetworkPacket header) {
        clientHash.remove(NetworkPacket.convertByteArrayToWWNString(header.getDatabuffer()));
    }

    private static void handleRegisterCall(NetworkPacket header) {
        ClientInfo clientInfo = new ClientInfo();
        byte[] buffer = header.getDatabuffer();
        clientInfo.setMajorNumber(NetworkToJavaConverter.byteArrayToInt(buffer));
        clientInfo.setMinorNumber(NetworkToJavaConverter.byteArrayToInt(buffer, 4));
        clientInfo.setListenPort(NetworkToJavaConverter.byteArrayToInt(buffer, 40));
        clientInfo.setDescription(buffer, 44, 256);
        clientInfo.setVersion(buffer, 8, 32);
        String clientWWN = WWNManager.createWWNForClient(clientInfo.getListenPort(), clientID++);
        clientInfo.setWWN(clientWWN);
        clientHash.put(clientWWN, clientInfo);
        header.setDatabuffer(NetworkPacket.convertWWNStringToByteArray(clientWWN));
    }

    private static void handleRemoteRegisterCall(NetworkPacket header) {
        ClientInfo clientInfo = new ClientInfo();
        byte[] buffer = header.getDatabuffer();
        clientInfo.setMajorNumber(NetworkToJavaConverter.byteArrayToInt(buffer));
        clientInfo.setMinorNumber(NetworkToJavaConverter.byteArrayToInt(buffer, 4));
        clientInfo.setListenPort(NetworkToJavaConverter.byteArrayToInt(buffer, 40));
        clientInfo.setDescription(buffer, 44, 256);
        clientInfo.setVersion(buffer, 8, 32);
        String ipAddr = header.getSenderIPAsString();
        String clientWWN = WWNManager.createWWNForClient(ipAddr, clientInfo.getListenPort(), clientID++);
        clientInfo.setWWN(clientWWN);
        clientHash.put(clientWWN, clientInfo);
        header.setDatabuffer(NetworkPacket.convertWWNStringToByteArray(clientWWN));
    }

    public static Object[] getClientList() {
        return clientHash.values().toArray();
    }
}

