/*
 * Decompiled with CFR 0.152.
 */
package Framework;

import Framework.AccessControllers.AccessControlManager;
import Framework.ClientManagers.ClientInfo;
import Framework.ClientManagers.ClientManager;
import Framework.FrameworkInfo;
import Framework.FrameworkInterface;
import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginManager;
import Services.CommonConstants;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.RoutingManager;
import java.io.File;

public class FrameworkManager
implements FrameworkInterface,
CommonConstants {
    private static FrameworkManager frameworkManager1 = null;

    private FrameworkManager() {
    }

    public static final FrameworkManager getFrameworkManager() {
        return frameworkManager1;
    }

    public static void main(String[] args) {
        System.setProperty("javax.net.ssl.keyStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("javax.net.ssl.keyStorePassword", "knqwhner");
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.out.println("MSM Framework version Beta 2.7");
        frameworkManager1 = new FrameworkManager();
        PluginManager.discoverPlugins();
        new NetworkManager().startListen();
    }

    public FrameworkInfo getFrameworkInfo() {
        return FrameworkInfo.getInstance();
    }

    public byte[] getPlugIns() {
        PluginInfo[] pluginInfo = PluginManager.getPlugInList();
        if (pluginInfo == null) {
            byte[] byteArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, byteArray);
            return byteArray;
        }
        byte[] pluginBytes = pluginInfo[0].converToBytetArray();
        int pluginInfoLength = pluginBytes.length;
        byte[] byteArray = new byte[pluginInfo.length * pluginInfoLength + 4];
        int byteIndex = 0;
        NetworkToJavaConverter.intToByteArray(pluginInfo.length, byteArray);
        System.arraycopy(pluginBytes, 0, byteArray, byteIndex += 4, pluginInfoLength);
        byteIndex += pluginInfoLength;
        for (int i = 1; i < pluginInfo.length; ++i) {
            System.arraycopy(pluginInfo[i].converToBytetArray(), 0, byteArray, byteIndex, pluginInfoLength);
            byteIndex += pluginInfoLength;
        }
        return byteArray;
    }

    public byte[] getClientList() {
        int clientInfoLength;
        Object[] clientInfo = ClientManager.getClientList();
        byte[] clientBytes = null;
        if (clientInfo.length != 0) {
            clientBytes = ((ClientInfo)clientInfo[0]).getBytes();
            clientInfoLength = clientBytes.length;
        } else {
            clientInfoLength = 0;
        }
        byte[] byteArray = new byte[clientInfo.length * clientInfoLength + 4];
        int byteIndex = 0;
        NetworkToJavaConverter.intToByteArray(clientInfo.length, byteArray);
        if (clientInfo.length == 0) {
            return byteArray;
        }
        System.arraycopy(clientBytes, 0, byteArray, byteIndex += 4, clientInfoLength);
        byteIndex += clientInfoLength;
        for (int i = 1; i < clientInfo.length; ++i) {
            System.arraycopy(((ClientInfo)clientInfo[i]).getBytes(), 0, byteArray, byteIndex, clientInfoLength);
            byteIndex += clientInfoLength;
        }
        return byteArray;
    }

    private void GetSpecifiedPlugin(NetworkPacket networkPacket) {
        int MinorNumber;
        byte[] inputBuff = networkPacket.getDatabuffer();
        int MajorNumber = NetworkToJavaConverter.byteArrayToInt(inputBuff);
        PluginInfo pluginInfo = PluginManager.getPluginInfo(MajorNumber, MinorNumber = NetworkToJavaConverter.byteArrayToInt(inputBuff, 4));
        if (pluginInfo == null) {
            byte[] buff = new byte[4];
            NetworkToJavaConverter.intToByteArray(1, buff);
            networkPacket.setDatabuffer(buff);
            return;
        }
        byte[] pluginInfoBuff = pluginInfo.converToBytetArray();
        byte[] outputBuff = new byte[pluginInfoBuff.length + 4];
        NetworkToJavaConverter.intToByteArray(0, outputBuff);
        System.arraycopy(pluginInfoBuff, 0, outputBuff, 4, pluginInfoBuff.length);
        networkPacket.setDatabuffer(outputBuff);
    }

    public void DiscoverRemoteFrameworks(NetworkPacket networkPacket) {
        PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 2);
        if (pluginInterface == null) {
            byte[] buff = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, buff);
            networkPacket.setDatabuffer(buff);
            return;
        }
        byte[] buff = new byte[4];
        NetworkToJavaConverter.intToByteArray(262, buff);
        networkPacket.setDatabuffer(buff);
        PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket);
        if (pluginInterface.processCommand(pluginDataInfo)) {
            networkPacket.setDatabuffer(pluginDataInfo.getBuffer());
        } else {
            networkPacket.setDatabuffer(null);
        }
    }

    public boolean ProcessCommand(int cmdID, PluginDataInfo obj) {
        NetworkPacket networkPacket = new NetworkPacket(cmdID, obj);
        try {
            RoutingManager.routeCall(networkPacket);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void handleFrameworkCalls(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        switch (networkPacket.getRequestType()) {
            case 257: 
            case 258: 
            case 268: {
                ClientManager.handleClientCall(networkPacket);
                break;
            }
            case 259: {
                networkPacket.setDatabuffer(this.getPlugIns());
                break;
            }
            case 260: {
                networkPacket.setDatabuffer(this.getClientList());
                break;
            }
            case 263: {
                this.GetSpecifiedPlugin(networkPacket);
                break;
            }
            case 261: 
            case 266: 
            case 267: {
                AccessControlManager.handleClientCall(networkPacket);
                break;
            }
            case 262: {
                this.DiscoverRemoteFrameworks(networkPacket);
                break;
            }
            case 265: {
                byte[] buff = new byte[32];
                byte[] frameWorkVersion = "Beta 2.7".getBytes();
                System.arraycopy(frameWorkVersion, 0, buff, 0, frameWorkVersion.length <= buff.length ? frameWorkVersion.length : buff.length);
                networkPacket.setDatabuffer(buff);
                break;
            }
            case 264: {
                byte[] buff = new byte[4];
                NetworkToJavaConverter.intToByteArray(NetworkManager.getAFreePort(), buff);
                networkPacket.setDatabuffer(buff);
                break;
            }
            default: {
                throw new VivaldiFrameworkProtocolErrorException();
            }
        }
    }

    public static String getFrameworkWWN() {
        return FrameworkUtilities.getLocalHostAddress() + ":" + NetworkManager.getPort() + ":" + "0";
    }
}

