/*
 * Decompiled with CFR 0.152.
 */
package Framework.Network;

import Framework.Network.SocketData;
import Services.CommonConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.SSLSocketFactory;

public class CachedSSLSocketFactory
implements CommonConstants {
    private static SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private static HashMap socketHash = new HashMap();

    CachedSSLSocketFactory() {
    }

    public static synchronized SocketData createSocket(String ipAddress, int port) throws IOException {
        String hashKey = ipAddress + ":" + port;
        ArrayList socketList = (ArrayList)socketHash.get(hashKey);
        SocketData socket = null;
        if (socketList != null) {
            while (!socketList.isEmpty() && !(socket = (SocketData)socketList.remove(0)).isOK()) {
                socket = null;
            }
        }
        if (socket == null) {
            socket = new SocketData(factory.createSocket(ipAddress, port));
        }
        return socket;
    }

    public static synchronized void returnSocket(SocketData soc, String ipAddress, int port) {
        String hashKey = ipAddress + ":" + port;
        ArrayList<SocketData> socketList = (ArrayList<SocketData>)socketHash.get(hashKey);
        if (socketList == null) {
            socketList = new ArrayList<SocketData>();
        }
        socketList.add(soc);
        socketHash.put(hashKey, socketList);
    }

    public static synchronized void removeSocketCache(String ipAddress, int port) {
        String hashKey = ipAddress + ":" + port;
        socketHash.remove(hashKey);
    }
}

