/*
 * Decompiled with CFR 0.152.
 */
package Framework.Network;

import Framework.Network.CachedSSLSocketFactory;
import Framework.Network.SocketData;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.Network.Worker;
import Framework.PluginManagers.PluginManager;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class NetworkManager {
    private static final int PORT_TO_LISTEN = 3071;
    protected static final int NUM_WORKERS = 10;
    private static String keystore = "vivaldikeys";
    private static char[] keystorepass = "knqwhner".toCharArray();
    private static char[] keypassword = "knqwhner".toCharArray();
    protected static volatile boolean continueListen = true;
    protected static ArrayList reservedWorkers = new ArrayList();
    protected static ArrayList activeWorkers = new ArrayList();
    private static final int SEARCH_PORT_START = 49257;
    private static final int MAX_TRY_LOOP = 800;

    public static int getAFreePort() {
        int i;
        int port = 49257;
        for (i = 0; i <= 800; ++i) {
            try {
                ServerSocket soc = new ServerSocket(++port);
                soc.close();
                break;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (i > 800) {
            port = 0;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object w;
        ServerSocket ss;
        try {
            ss = NetworkManager.getServer();
        }
        catch (Exception e) {
            System.out.println("Framework: Failed to open server socket exiting......");
            PluginManager.StopPlugins();
            return;
        }
        ArrayList e = reservedWorkers;
        synchronized (e) {
            for (int i = 0; i < 10; ++i) {
                w = new Worker();
                new Thread((Runnable)w, "worker #" + i).start();
                reservedWorkers.add(w);
            }
        }
        while (continueListen) {
            Socket s;
            try {
                s = ss.accept();
            }
            catch (Exception e2) {
                continue;
            }
            Worker w2 = null;
            w = reservedWorkers;
            synchronized (w) {
                if (reservedWorkers.isEmpty()) {
                    Worker ws = new Worker();
                    ws.setSocket(s);
                    new Thread((Runnable)ws, "additional worker").start();
                } else {
                    w2 = (Worker)reservedWorkers.remove(0);
                    activeWorkers.add(w2);
                    w2.setSocket(s);
                }
            }
            if (continueListen) continue;
            PluginManager.StopPlugins();
            try {
                ss.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            ArrayList arrayList = reservedWorkers;
            synchronized (arrayList) {
                int i;
                for (i = 0; i < reservedWorkers.size(); ++i) {
                    w2 = (Worker)reservedWorkers.get(i);
                    try {
                        w2.stopRun();
                        continue;
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                for (i = 0; i < activeWorkers.size(); ++i) {
                    w2 = (Worker)activeWorkers.get(i);
                    w2.closeSocket();
                }
            }
        }
    }

    private static ServerSocket getServer() throws Exception {
        SSLServerSocketFactory sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        SSLServerSocket sslserversocket = (SSLServerSocket)sslserversocketfactory.createServerSocket(3071);
        return sslserversocket;
    }

    public static int getPort() {
        return 3071;
    }

    public static void forwardCallToDestination(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        boolean tryAgain;
        int tryCount = 1;
        String receiverIP = null;
        int port = 0;
        do {
            try {
                tryAgain = false;
                receiverIP = networkPacket.getReceiverIPAsString();
                port = networkPacket.getReceiverPort();
                SocketData socket = CachedSSLSocketFactory.createSocket(receiverIP, port);
                DataInputStream is = socket.getInputStream();
                byte[] dataToSend = networkPacket.getByteArray();
                BufferedOutputStream os = socket.getOutputStream();
                os.write(dataToSend);
                os.flush();
                NetworkPacket packet = NetworkManager.readNetworkPacketFromInputStream(is);
                networkPacket.setDatabuffer(packet.getDatabuffer());
                CachedSSLSocketFactory.returnSocket(socket, receiverIP, port);
            }
            catch (Exception e) {
                if (--tryCount >= 0) {
                    tryAgain = true;
                    System.out.println("Socket connection to " + receiverIP + "failed, try again\n");
                    CachedSSLSocketFactory.removeSocketCache(receiverIP, port);
                    continue;
                }
                System.out.println("Socket connection to " + receiverIP + "failed  on retry\n");
                throw new VivaldiFrameworkProtocolErrorException();
            }
        } while (tryAgain);
    }

    public static NetworkPacket readNetworkPacketFromInputStream(DataInputStream is) throws IOException {
        byte[] buffer;
        byte[] header = new byte[60];
        is.readFully(header);
        int reqType = NetworkToJavaConverter.byteArrayToInt(header);
        int reqLen = NetworkToJavaConverter.byteArrayToInt(header, 56);
        if (reqLen != 0) {
            buffer = new byte[reqLen];
            int len = 0;
            int startOffset = 0;
            while ((len = is.read(buffer, startOffset, reqLen - startOffset)) != 0 && reqLen != (startOffset += len)) {
            }
        } else {
            buffer = null;
        }
        NetworkPacket networkPacket = new NetworkPacket(header, buffer);
        return networkPacket;
    }
}

