/*
 * Decompiled with CFR 0.152.
 */
package Framework.Network;

import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Services.NetworkPacket;
import Services.RoutingManager;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class Worker
implements Runnable {
    private volatile Socket s;
    private volatile BufferedOutputStream os = null;
    private volatile DataInputStream is = null;

    synchronized void setSocket(Socket s) {
        this.s = s;
        this.notify();
    }

    protected void closeSocket() {
        try {
            this.s.close();
            this.is.close();
            this.os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            ArrayList pool;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    continue;
                }
            }
            if (!NetworkManager.continueListen) {
                return;
            }
            try {
                this.handleClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!NetworkManager.continueListen) {
                if (this.s != null) {
                    try {
                        this.s.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return;
            }
            this.s = null;
            ArrayList arrayList = pool = NetworkManager.reservedWorkers;
            synchronized (arrayList) {
                if (pool.size() >= 10) {
                    return;
                }
                ((AbstractCollection)NetworkManager.activeWorkers).remove(this);
                pool.add(this);
            }
        }
    }

    protected synchronized void stopRun() {
        NetworkManager.continueListen = false;
        this.notify();
    }

    private void handleClient() {
        try {
            while (true) {
                if (this.is == null) {
                    this.is = new DataInputStream(this.s.getInputStream());
                }
                NetworkPacket networkPacket = NetworkManager.readNetworkPacketFromInputStream(this.is);
                switch (networkPacket.getRequestType()) {
                    case 1: {
                        this.stopRun();
                        return;
                    }
                }
                try {
                    RoutingManager.routeCall(networkPacket);
                }
                catch (VivaldiFrameworkProtocolErrorException ex1) {
                    networkPacket.setFrameworkError(1);
                }
                byte[] buffer = networkPacket.getByteArray();
                if (this.os == null) {
                    this.os = new BufferedOutputStream(this.s.getOutputStream(), buffer.length);
                }
                this.os.write(buffer);
                this.os.flush();
            }
        }
        catch (Exception ex) {
            try {
                this.is.close();
                this.os.close();
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            return;
        }
    }
}

