/*
 * Decompiled with CFR 0.152.
 */
package Framework.PluginManagers;

import Services.NetworkPacket;
import Services.NetworkToJavaConverter;

public class PluginInfo {
    private int majorGroup;
    private int minorGroup;
    private String version;
    private String WWN;
    private String description;

    public void setMajorGroup(int majorGroup) {
        this.majorGroup = majorGroup;
    }

    public int getMajorGroup() {
        return this.majorGroup;
    }

    public void setMinorGroup(int minorGroup) {
        this.minorGroup = minorGroup;
    }

    public int getMinorGroup() {
        return this.minorGroup;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setWWN(String WWN) {
        this.WWN = WWN;
    }

    public String getWWN() {
        return this.WWN;
    }

    public byte[] converToBytetArray() {
        byte[] arrayByte = new byte[480];
        NetworkToJavaConverter.intToByteArray(this.majorGroup, arrayByte);
        NetworkToJavaConverter.intToByteArray(this.minorGroup, arrayByte, 4);
        byte[] versionArray = this.version.getBytes();
        System.arraycopy(versionArray, 0, arrayByte, 8, versionArray.length >= 64 ? 64 : versionArray.length);
        byte[] wwnArray = NetworkPacket.convertWWNStringToByteArray(this.WWN);
        System.arraycopy(wwnArray, 0, arrayByte, 72, wwnArray.length);
        byte[] descriptionArray = this.description.getBytes();
        System.arraycopy(descriptionArray, 0, arrayByte, 96, descriptionArray.length >= 256 ? 256 : descriptionArray.length);
        return arrayByte;
    }
}

