/*
 * Decompiled with CFR 0.152.
 */
package Framework.PluginManagers;

import Framework.FrameworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginNameFilter;
import Services.NetworkPacket;
import Services.WWNManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PluginManager {
    private static int pluginCount = 0;
    private static PluginInfo[] listOfPlugins = null;
    private static Hashtable pluginHash = new Hashtable();

    public PluginManager() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void discoverPlugins() {
        int i;
        File dirFile = new File(System.getProperty("user.dir") + File.separator + "plugins");
        String[] fileNames = dirFile.list(new PluginNameFilter());
        ArrayList<PluginInfo> listPlugins = new ArrayList<PluginInfo>();
        for (i = 0; fileNames != null && i < fileNames.length; ++i) {
            String onlyClassName = fileNames[i].substring(0, fileNames[i].indexOf(PluginNameFilter.getJavaClassExn()));
            try {
                PluginInterface pluginInterface = (PluginInterface)Class.forName("plugins." + onlyClassName).newInstance();
                String wwn = WWNManager.generateWWNfromPluginID(++pluginCount);
                if (!pluginInterface.init(wwn, FrameworkManager.getFrameworkManager())) {
                    pluginInterface.shutdown();
                    continue;
                }
                pluginHash.put(wwn, pluginInterface);
                PluginInfo plugInInfo = pluginInterface.getPluginInfo();
                System.out.println("Loaded Plugin:: " + plugInInfo.getDescription());
                listPlugins.add(plugInInfo);
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (listPlugins.size() != 0) {
            listOfPlugins = new PluginInfo[listPlugins.size()];
            for (i = 0; i < listPlugins.size(); ++i) {
                PluginManager.listOfPlugins[i] = (PluginInfo)listPlugins.get(i);
            }
        }
    }

    public static boolean isLocalPlugin(String wwn) {
        return pluginHash.containsKey(wwn);
    }

    public static void routeCallToPlugin(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        String receiverWWN = networkPacket.getReceiverWWN();
        if (!PluginManager.isLocalPlugin(receiverWWN)) {
            throw new VivaldiFrameworkProtocolErrorException();
        }
        try {
            PluginInterface pluginInterface = (PluginInterface)pluginHash.get(receiverWWN);
            PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket);
            pluginInterface.processCommand(pluginDataInfo);
            networkPacket.setDatabuffer(pluginDataInfo.getBuffer());
        }
        catch (Exception ex) {
            throw new VivaldiFrameworkProtocolErrorException();
        }
    }

    public static PluginInfo[] getPlugInList() {
        return listOfPlugins;
    }

    private void jbInit() throws Exception {
    }

    public static void StopPlugins() {
        Enumeration e = pluginHash.elements();
        while (e.hasMoreElements()) {
            PluginInterface pluginInterface = (PluginInterface)e.nextElement();
            pluginInterface.shutdown();
        }
    }

    public static PluginInterface getPluginInterface(int majorNumber, int minorNumber) {
        PluginInfo pluginInfo = PluginManager.getPluginInfo(majorNumber, minorNumber);
        return pluginInfo == null ? null : (PluginInterface)pluginHash.get(pluginInfo.getWWN());
    }

    public static PluginInfo getPluginInfo(int majorNumber, int minorNumber) {
        if (listOfPlugins != null) {
            for (int i = 0; i < listOfPlugins.length; ++i) {
                if (listOfPlugins[i].getMajorGroup() != majorNumber || listOfPlugins[i].getMinorGroup() != minorNumber) continue;
                return listOfPlugins[i];
            }
        }
        return null;
    }
}

