/*
 * Decompiled with CFR 0.152.
 */
package Services;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class FrameworkUtilities {
    private static final String LOOP_BACK_ADDRESS = "127.0.0.1";

    public static String getLocalHostAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                Enumeration<InetAddress> inet = e.nextElement().getInetAddresses();
                while (inet.hasMoreElements()) {
                    InetAddress netAdr = inet.nextElement();
                    if (netAdr.isLoopbackAddress() || !(netAdr instanceof Inet4Address)) continue;
                    return netAdr.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return LOOP_BACK_ADDRESS;
    }

    public static boolean checkIfLocalAddress(String ipAddress) {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                Enumeration<InetAddress> inet = e.nextElement().getInetAddresses();
                while (inet.hasMoreElements()) {
                    if (!inet.nextElement().getHostAddress().equals(ipAddress)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

