/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Framework.PluginManagers.PluginDataInfo;
import Services.NetworkToJavaConverter;
import Services.WWNExtractor;

public class NetworkPacket {
    private int[] senderIP;
    private int senderPort;
    private int senderID;
    private int[] receiverIP;
    private int receiverPort;
    private int receiverID;
    private int frameworkError;
    private int requestLength;
    private byte[] databuffer;
    private int requestType;
    private byte[] originalHeader;
    public static final int HEADER_SIZE = 60;
    private static final int RECEIVER_IP_START = 28;

    public NetworkPacket(byte[] packet, byte[] databuffer) {
        this.senderIP = new int[4];
        this.receiverIP = new int[4];
        this.originalHeader = packet;
        this.setRequestType(NetworkToJavaConverter.byteArrayToInt(packet));
        this.setSenderIP(packet);
        this.setSenderPort(NetworkToJavaConverter.byteArrayToInt(packet, 20));
        this.setSenderID(NetworkToJavaConverter.byteArrayToInt(packet, 24));
        this.setReceiverIP(packet);
        this.setReceiverPort(NetworkToJavaConverter.byteArrayToInt(packet, 44));
        this.setReceiverID(NetworkToJavaConverter.byteArrayToInt(packet, 48));
        this.setFrameworkError(NetworkToJavaConverter.byteArrayToInt(packet, 52));
        this.setDatabuffer(databuffer);
    }

    public NetworkPacket(int opCode, PluginDataInfo pluginData) {
        WWNExtractor sender = new WWNExtractor(pluginData.getSenderWWN());
        WWNExtractor receiver = new WWNExtractor(pluginData.getReceiverWWN());
        this.senderIP = sender.getIP();
        this.receiverIP = receiver.getIP();
        this.originalHeader = null;
        this.setRequestType(opCode);
        this.setSenderPort(sender.getPort());
        this.setSenderID(sender.getID());
        this.setReceiverPort(receiver.getPort());
        this.setReceiverID(receiver.getID());
        this.setFrameworkError(0);
        this.setDatabuffer(pluginData.getBuffer());
    }

    public void setSenderIP(byte[] packet) {
        this.senderIP[0] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, 4);
        this.senderIP[1] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, 6);
        this.senderIP[2] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, 8);
        this.senderIP[3] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, 10);
    }

    public void setSenderPort(int senderPort) {
        this.senderPort = senderPort;
    }

    public void setSenderID(int senderID) {
        this.senderID = senderID;
    }

    public void setReceiverIP(byte[] packet) {
        int buffOffset = 28;
        this.receiverIP[0] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset);
        this.receiverIP[1] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset += 2);
        this.receiverIP[2] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset += 2);
        this.receiverIP[3] = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset += 2);
        this.receiverIP = this.receiverIP;
    }

    public static String getReceiverIPAsStringFromHeader(byte[] packet) {
        int buffOffset = 28;
        int receiverIP_0 = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset);
        int receiverIP_1 = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset += 2);
        int receiverIP_2 = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset += 2);
        int receiverIP_3 = NetworkToJavaConverter.byteArrayToUnsignedShort(packet, buffOffset += 2);
        return receiverIP_0 + "." + receiverIP_1 + "." + receiverIP_2 + "." + receiverIP_3;
    }

    public void setReceiverPort(int receiverPort) {
        this.receiverPort = receiverPort;
    }

    public void setReceiverID(int receiverID) {
        this.receiverID = receiverID;
    }

    public void setFrameworkError(int frameworkError) {
        this.frameworkError = frameworkError;
    }

    public void setDatabuffer(byte[] databuffer) {
        this.databuffer = databuffer;
        this.requestLength = databuffer != null ? databuffer.length : 0;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public int[] getSenderIP() {
        return this.senderIP;
    }

    public int getSenderPort() {
        return this.senderPort;
    }

    public int getSenderID() {
        return this.senderID;
    }

    public int[] getReceiverIP() {
        return this.receiverIP;
    }

    public String getReceiverIPAsString() {
        return this.receiverIP[0] + "." + this.receiverIP[1] + "." + this.receiverIP[2] + "." + this.receiverIP[3];
    }

    public String getSenderIPAsString() {
        return this.senderIP[0] + "." + this.senderIP[1] + "." + this.senderIP[2] + "." + this.senderIP[3];
    }

    public int getReceiverPort() {
        return this.receiverPort;
    }

    public int getReceiverID() {
        return this.receiverID;
    }

    public int getFrameworkError() {
        return this.frameworkError;
    }

    public int getRequestLength() {
        return this.requestLength;
    }

    public byte[] getDatabuffer() {
        return this.databuffer;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public byte[] getOriginalHeader() {
        return this.originalHeader;
    }

    public String getSenderWWN() {
        return new String(this.senderIP[0] + "." + this.senderIP[1] + "." + this.senderIP[2] + "." + this.senderIP[3] + ":" + this.senderPort + ":" + this.senderID);
    }

    public String getReceiverWWN() {
        return new String(this.receiverIP[0] + "." + this.receiverIP[1] + "." + this.receiverIP[2] + "." + this.receiverIP[3] + ":" + this.receiverPort + ":" + this.receiverID);
    }

    public static byte[] convertWWNStringToByteArray(String WWN) {
        byte[] wwnArray = new byte[24];
        int byteIndex = 0;
        int ipPartCount = 0;
        String[] wwnParts = WWN.split(":");
        String[] ipParts = wwnParts[0].split("\\.");
        for (ipPartCount = 0; ipPartCount < ipParts.length; ++ipPartCount) {
            NetworkToJavaConverter.shortTobyteArray(new Short(ipParts[ipPartCount]), wwnArray, byteIndex);
            byteIndex += 2;
        }
        while (ipPartCount < 8) {
            NetworkToJavaConverter.shortTobyteArray((short)0, wwnArray, byteIndex);
            byteIndex += 2;
            ++ipPartCount;
        }
        NetworkToJavaConverter.intToByteArray(new Integer(wwnParts[1]), wwnArray, byteIndex);
        NetworkToJavaConverter.intToByteArray(new Integer(wwnParts[2]), wwnArray, byteIndex += 4);
        return wwnArray;
    }

    public static String convertByteArrayToWWNString(byte[] wwnArray) {
        return NetworkPacket.convertByteArrayToWWNString(wwnArray, 0);
    }

    public static String convertByteArrayToWWNString(byte[] wwnArray, int offset) {
        return NetworkToJavaConverter.byteArrayToUnsignedShort(wwnArray, offset) + "." + NetworkToJavaConverter.byteArrayToUnsignedShort(wwnArray, offset + 2) + "." + NetworkToJavaConverter.byteArrayToUnsignedShort(wwnArray, offset + 4) + "." + NetworkToJavaConverter.byteArrayToUnsignedShort(wwnArray, offset + 6) + ":" + NetworkToJavaConverter.byteArrayToInt(wwnArray, offset + 16) + ":" + NetworkToJavaConverter.byteArrayToInt(wwnArray, offset + 20);
    }

    public byte[] getByteArray() {
        byte[] header = new byte[60 + (this.databuffer != null ? this.databuffer.length : 0)];
        int headerOffset = 0;
        NetworkToJavaConverter.intToByteArray(this.requestType, header);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[0], header, headerOffset += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[1], header, headerOffset += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[2], header, headerOffset += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[3], header, headerOffset += 2);
        headerOffset = 20;
        NetworkToJavaConverter.intToByteArray(this.senderPort, header, headerOffset);
        NetworkToJavaConverter.intToByteArray(this.senderID, header, headerOffset += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[0], header, headerOffset += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[1], header, headerOffset += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[2], header, headerOffset += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[3], header, headerOffset += 2);
        headerOffset += 2;
        headerOffset = 44;
        NetworkToJavaConverter.intToByteArray(this.receiverPort, header, headerOffset);
        NetworkToJavaConverter.intToByteArray(this.receiverID, header, headerOffset += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.frameworkError, header, headerOffset += 4);
        headerOffset += 4;
        if (this.databuffer != null) {
            this.requestLength = this.databuffer.length;
            NetworkToJavaConverter.intToByteArray(this.requestLength, header, headerOffset);
            System.arraycopy(this.databuffer, 0, header, headerOffset += 4, this.databuffer.length);
        } else {
            this.requestLength = 0;
        }
        return header;
    }
}

