/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Framework.AccessControllers.AccessControlManager;
import Framework.FrameworkManager;
import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginManager;
import Services.FrameworkUtilities;
import Services.NetworkPacket;

public class RoutingManager {
    public static void routeCall(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        if (!FrameworkUtilities.checkIfLocalAddress(networkPacket.getReceiverIPAsString()) || NetworkManager.getPort() != networkPacket.getReceiverPort()) {
            NetworkManager.forwardCallToDestination(networkPacket);
            return;
        }
        if ((networkPacket.getRequestType() & 0x100) != 0) {
            FrameworkManager.getFrameworkManager().handleFrameworkCalls(networkPacket);
        } else {
            if ((networkPacket.getRequestType() & 2) != 0 && (networkPacket.getRequestType() & 4) != 0 && !AccessControlManager.isClientRegistered(networkPacket.getSenderWWN())) {
                networkPacket.setFrameworkError(2);
                return;
            }
            PluginManager.routeCallToPlugin(networkPacket);
        }
    }
}

