/*
 * Decompiled with CFR 0.152.
 */
package configurators;

import Framework.Configurator.ComponentAccessHelper;
import Framework.Configurator.ComponentDescriptor;
import Framework.Configurator.ConfiguratorInfo;
import Framework.Configurator.ConfiguratorInterface;
import Framework.Configurator.LoggedInServerInfo;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainDialog;
import configurators.monitorgui.net.WrappedCommunicator;
import configurators.monitorgui.xml.AlertStrings;
import configurators.monitorgui.xml.MessageFactory;
import configurators.monitorgui.xml.parser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringBufferInputStream;
import java.util.Locale;
import javax.swing.JOptionPane;

public class CIMOMMonitorConfigurator
implements ConfiguratorInterface {
    private static final int MajorNumber = 0;
    private static final int MinorNumber = 11;
    private static final String alertStringsFile = "alertStrings.xml";
    private static final String alertStringsDir = "Common";
    private Component parent = null;

    public CIMOMMonitorConfigurator() {
    }

    public CIMOMMonitorConfigurator(Object obj) {
        Internationalization.loadInternationalizationMethod(obj);
    }

    public ComponentDescriptor[] getComponentList() {
        ComponentDescriptor[] theMonitor = new ComponentDescriptor[]{new ComponentDescriptor(1, 0, 11)};
        return theMonitor;
    }

    public ConfiguratorInfo getConfiguratorInfo() {
        return new ConfiguratorInfo(Internationalization.translate("CIMOMMonitorConfigurator"), "0.1", Internationalization.translate("CIMOMMonitorConfigurator"));
    }

    private void gracefulExit() {
        JOptionPane.showMessageDialog(this.parent, Internationalization.translate("gracefulExit"), Internationalization.translate("gracefulExit"), -1);
    }

    public int invoke(LoggedInServerInfo server, ComponentAccessHelper[] helpers, Container parent) throws VKNotRespondingException, VKInvalidOperationException, VKOperationFailedException {
        ConfigData theConfig;
        System.out.println("Monitor GUI invoked...");
        this.parent = parent;
        boolean good_situation = true;
        if (helpers.length == 0) {
            good_situation = false;
        } else {
            ComponentDescriptor candidate = helpers[0].getComponentDescriptor();
            if (candidate.getMajorGroup() != 0) {
                good_situation = false;
            }
            if (candidate.getMinorGroup() != 11) {
                good_situation = false;
            }
        }
        if (!good_situation) {
            this.gracefulExit();
            return -1;
        }
        System.out.println("Good Situation");
        MessageFactory messageFactory = new MessageFactory();
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        messageFactory.sendRequest(toSend);
        System.out.println("toSend -> " + toSend.toString());
        WrappedCommunicator theCommunicator = new WrappedCommunicator(helpers[0]);
        System.out.println("The communicator created");
        try {
            System.out.println("request send to the communicator");
            String result = theCommunicator.send(toSend.toString());
            parser p = new parser();
            p.parse(new StringBufferInputStream(result));
            theConfig = p.getConfig();
            if (theConfig == null) {
                this.gracefulExit();
                return -1;
            }
        }
        catch (Exception e) {
            this.gracefulExit();
            return -1;
        }
        FileInputStream in = null;
        AlertStrings ts = null;
        String localPath = Locale.getDefault().getLanguage().equals(Locale.CHINESE.getLanguage()) ? Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry() : Locale.getDefault().getLanguage();
        String alertStringsPath = alertStringsDir + File.separator + "Languages" + File.separator + localPath + File.separator + alertStringsFile;
        System.out.println(alertStringsPath);
        if (!new File(alertStringsPath).exists()) {
            alertStringsPath = alertStringsDir + File.separator + "Languages" + File.separator + "en" + File.separator + alertStringsFile;
        }
        System.out.println(localPath);
        System.out.println(alertStringsPath);
        try {
            in = new FileInputStream(alertStringsPath);
            ts = new AlertStrings(in);
        }
        catch (Exception e) {
            System.out.println("AlertStrings Path not found...");
            this.gracefulExit();
            return -1;
        }
        MainDialog md = new MainDialog(theConfig, ts, theCommunicator, (Frame)parent, server);
        return 0;
    }

    public int shutdown() {
        return 0;
    }
}

