/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.data;

import configurators.monitorgui.data.Action;
import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.Global;
import configurators.monitorgui.data.Severity;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConfigData {
    private String theHost;
    private Hashtable ActionsMap = new Hashtable();
    private Hashtable GlobalsMap = new Hashtable();
    private Hashtable AlertEventsMap = new Hashtable();

    public ConfigData getDepthCopy() {
        ConfigData cln = new ConfigData();
        cln.theHost = this.theHost;
        cln.AlertEventsMap = new Hashtable();
        cln.ActionsMap = new Hashtable();
        cln.GlobalsMap = new Hashtable();
        Enumeration e = this.getAlertEvents();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            AlertEvent theAlertEvent = this.getAlertEvent(key);
            cln.AlertEventsMap.put(new Integer(key), theAlertEvent);
        }
        e = this.getActions();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            Action theAction = this.getAction(key);
            cln.ActionsMap.put(key, theAction);
        }
        e = this.getGlobals();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            Severity sev = new Severity(key);
            Global theGlobal = this.getGlobal(sev);
            cln.GlobalsMap.put(sev.getValue(), theGlobal);
        }
        return cln;
    }

    public void addAction(Action theAction, String key) {
        this.ActionsMap.put(key, theAction);
    }

    public Action getAction(String index) {
        return (Action)this.ActionsMap.get(index);
    }

    public int getActionsCount() {
        return this.ActionsMap.size();
    }

    public void addGlobal(Global theGlobal, Severity index) {
        this.GlobalsMap.remove(new Integer(index.getValue()));
        this.GlobalsMap.put(new Integer(index.getValue()), theGlobal);
    }

    public Global getGlobal(Severity index) {
        return (Global)this.GlobalsMap.get(new Integer(index.getValue()));
    }

    public int getGlobalsCount() {
        return this.GlobalsMap.size();
    }

    public void addAlertEvent(AlertEvent theAlertEvent) {
        this.AlertEventsMap.remove(new Integer(theAlertEvent.getId()));
        this.AlertEventsMap.put(new Integer(theAlertEvent.getId()), theAlertEvent);
    }

    public AlertEvent getAlertEvent(int index) {
        return (AlertEvent)this.AlertEventsMap.get(new Integer(index));
    }

    public int getAlertEventsCount() {
        return this.AlertEventsMap.size();
    }

    public String getHost() {
        return this.theHost;
    }

    public void setHost(String s) {
        this.theHost = s;
    }

    public ArrayList getSection(String section, String subsection) {
        Action a = this.getAction(section);
        if (a == null) {
            return null;
        }
        return a.getParam(subsection);
    }

    public Enumeration getActions() {
        return this.ActionsMap.keys();
    }

    public Enumeration getGlobals() {
        return this.GlobalsMap.keys();
    }

    public Enumeration getAlertEvents() {
        return this.AlertEventsMap.keys();
    }

    public Hashtable getAlertsEventsMapClone() {
        Hashtable<Integer, AlertEvent> alertEvtsMapCln = new Hashtable<Integer, AlertEvent>();
        Enumeration e = this.getAlertEvents();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            AlertEvent theAlertEvent = this.getAlertEvent(key);
            alertEvtsMapCln.put(new Integer(key), theAlertEvent);
        }
        return alertEvtsMapCln;
    }

    public Hashtable getAlertsEventsMap() {
        return this.AlertEventsMap;
    }

    public void updateConfig(Hashtable tmpAlertMap) {
        this.AlertEventsMap = tmpAlertMap;
    }
}

