/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import GUI.VivaldiBrandingPanel;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.data.Global;
import configurators.monitorgui.data.Severity;
import configurators.monitorgui.gui.BorderWithMnemonic;
import configurators.monitorgui.gui.ExcepPanel;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainDialog;
import configurators.monitorgui.gui.MainThing;
import configurators.monitorgui.xml.AlertStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

class AddExcepDialog
extends JDialog {
    ConfigData theConfig;
    AlertEvent theEvent;
    AlertStrings theStrings;
    MainThing mainPanel;
    ArrayList theSevs;
    ArrayList theExcepIds;
    ArrayList theSevsStrings;
    ArrayList actionBoxes;
    Hashtable sevOtherToEnglishMap;
    JTable excepList;
    JButton addButton;
    JButton cancelButton;
    JButton restoreButton;
    Hashtable tmpAlertEventsMap;
    ExcepPanel parent = null;

    private void addAlertEvent(AlertEvent theAlertEvent) {
        this.tmpAlertEventsMap.remove(new Integer(theAlertEvent.getId()));
        this.tmpAlertEventsMap.put(new Integer(theAlertEvent.getId()), theAlertEvent);
    }

    private Enumeration getAlertEvents() {
        return this.tmpAlertEventsMap.keys();
    }

    private AlertEvent getAlertEvent(int index) {
        return (AlertEvent)this.tmpAlertEventsMap.get(new Integer(index));
    }

    private int getAlertEventsCount() {
        return this.tmpAlertEventsMap.size();
    }

    private void updateConfig() {
        this.theConfig.updateConfig(this.tmpAlertEventsMap);
    }

    private boolean isChangesDone() {
        return !this.tmpAlertEventsMap.equals(this.theConfig.getAlertsEventsMap());
    }

    AddExcepDialog(Frame p, ConfigData c, AlertStrings ts, MainThing m, ExcepPanel parentPanel) {
        super(p, Internationalization.translate("changeIndividualSev"), true);
        this.theStrings = ts;
        this.theConfig = c;
        this.mainPanel = m;
        this.theExcepIds = new ArrayList();
        this.sevOtherToEnglishMap = new Hashtable();
        this.tmpAlertEventsMap = this.theConfig.getAlertsEventsMapClone();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Enumeration e = this.getAlertEvents();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            this.theExcepIds.add(new Integer(key));
            this.parent = parentPanel;
        }
        Collections.sort(this.theExcepIds);
        this.theSevs = new ArrayList();
        this.theSevsStrings = new ArrayList();
        Enumeration se = this.theConfig.getGlobals();
        while (se.hasMoreElements()) {
            int key = (Integer)se.nextElement();
            String engStr = new Severity(key).getName();
            this.theSevs.add(engStr);
            String tranStr = Internationalization.translate(engStr);
            this.theSevsStrings.add(tranStr);
            this.sevOtherToEnglishMap.put(tranStr, engStr);
        }
        this.actionBoxes = new ArrayList();
        e = this.theConfig.getActions();
        Vector<String> strVector = new Vector<String>();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            strVector.add(a);
        }
        for (int i = strVector.size() - 1; i >= 0; --i) {
            ActionBox aBox = new ActionBox((String)strVector.get(i));
            this.actionBoxes.add(aBox);
        }
        this.excepList = new JTable(new AddExcepModel());
        this.excepList.setRowSelectionAllowed(true);
        this.excepList.setColumnSelectionAllowed(false);
        this.excepList.setRequestFocusEnabled(true);
        this.excepList.changeSelection(0, 2, false, false);
        this.excepList.setSelectionMode(0);
        this.excepList.getTableHeader().setReorderingAllowed(false);
        this.excepList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = AddExcepDialog.this.excepList.getSelectedRow();
                if (index >= 0) {
                    int key = (Integer)AddExcepDialog.this.theExcepIds.get(index);
                    AddExcepDialog.this.theEvent = (AlertEvent)AddExcepDialog.this.getAlertEvent(key).clone();
                    AddExcepDialog.this.update();
                }
            }
        });
        int vColIndex = 2;
        this.excepList.getColumnModel().getColumn(vColIndex).setCellEditor(new ComboBoxEditor(this.theSevsStrings.toArray()));
        this.excepList.getColumnModel().getColumn(0).setMaxWidth(40);
        this.excepList.getColumnModel().getColumn(2).setMaxWidth(80);
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.add((Component)VivaldiBrandingPanel.getInstance().getBannerPanel(0), "North");
        this.getContentPane().add((Component)upperPanel, "North");
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.setResizable(false);
        MainDialog.setIcon(this);
        JScrollPane scrollPane = new JScrollPane(this.excepList);
        if (!MainDialog.isWindows) {
            scrollPane.setBackground(new Color(124, 148, 196));
        }
        BorderWithMnemonic excepBwm = new BorderWithMnemonic(scrollPane, Internationalization.translate("events") + ":", MainDialog.isWindows);
        excepBwm.setMnemonic('v');
        excepBwm.setLabelFor(this.excepList);
        this.getContentPane().add(excepBwm);
        this.addButton = new JButton(Internationalization.translate("ok"));
        this.getRootPane().setDefaultButton(this.addButton);
        this.cancelButton = new JButton(Internationalization.translate("cancel"));
        this.restoreButton = new JButton(Internationalization.translate("restore"));
        this.restoreButton.setMnemonic('R');
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new GridLayout(1, this.actionBoxes.size()));
        for (int i = 0; i < this.actionBoxes.size(); ++i) {
            boxPanel.add((ActionBox)this.actionBoxes.get(i));
        }
        TitledBorder titleBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Internationalization.translate("setDel"));
        boxPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 20, 20, 20), titleBorder2));
        this.getContentPane().add(boxPanel);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExcepDialog.this.updateConfig();
                AddExcepDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExcepDialog.this.cancel();
            }
        });
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExcepDialog.this.restore();
            }
        });
        Box buttonBox = new Box(0);
        this.getRootPane().setDefaultButton(this.addButton);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        buttonBox.add(this.addButton);
        buttonBox.add(Box.createRigidArea(new Dimension(10, 10)));
        buttonBox.add(this.cancelButton);
        buttonBox.add(Box.createRigidArea(new Dimension(10, 10)));
        buttonBox.add(this.restoreButton);
        this.getContentPane().add(buttonBox);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        this.mapEscapeKey();
        this.update();
        this.pack();
        this.setSize(500, 500);
        GUIUtils.centerDialogOnScreen((Window)this, (Container)((MainDialog)this.mainPanel));
    }

    private void restore() {
        String title;
        String str = Internationalization.translate("restoreDefaultsWarning");
        if (JOptionPane.showConfirmDialog(this, str, title = Internationalization.translate("confirmRestoreDefaults"), 0, 2) != 0) {
            return;
        }
        this.restoreDefaults();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancel() {
        if (this.isChangesDone()) {
            String str = Internationalization.translate("confirmCancelConfigureAerts");
            if (!CustomMsgBox.confirm((Component)this.getContentPane(), (String)str, (int)2)) return;
            this.dispose();
            return;
        } else {
            this.dispose();
        }
    }

    private void mapEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddExcepDialog.this.cancel();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    public void restoreDefaults() {
        System.out.println("Restoring defaults...");
        ConfigData tmpConfig = this.parent.restore();
        this.tmpAlertEventsMap.clear();
        this.tmpAlertEventsMap = tmpConfig.getAlertsEventsMapClone();
        this.updateConfig();
    }

    String translateBackToEnglish(String tranStr) {
        return (String)this.sevOtherToEnglishMap.get(tranStr);
    }

    void update() {
        if (this.actionBoxes != null) {
            for (int i = 0; i < this.actionBoxes.size(); ++i) {
                ((ActionBox)this.actionBoxes.get(i)).update();
            }
        }
        this.repaint();
    }

    class CheckBoxListener
    implements ActionListener {
        private String name;
        private ActionBox box;

        public CheckBoxListener(String s, ActionBox b) {
            this.name = s;
            this.box = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddExcepDialog.this.theEvent != null) {
                if (this.box.isSelected()) {
                    AddExcepDialog.this.theEvent.addAction(AddExcepDialog.this.theConfig.getAction(this.name));
                    AddExcepDialog.this.theEvent.setUseGlobals(false);
                    AddExcepDialog.this.addAlertEvent(AddExcepDialog.this.theEvent);
                    this.box.setToolTipText(Internationalization.translate("unselectAction"));
                } else {
                    AddExcepDialog.this.theEvent.removeAction(this.name);
                    AddExcepDialog.this.theEvent.setUseGlobals(false);
                    AddExcepDialog.this.addAlertEvent(AddExcepDialog.this.theEvent);
                    this.box.setToolTipText(Internationalization.translate("selectAction"));
                }
            }
            AddExcepDialog.this.repaint();
        }
    }

    class ActionBox
    extends JCheckBox {
        private String name;

        ActionBox(String n) {
            super(Internationalization.translate(n));
            this.name = n;
            this.addActionListener(new CheckBoxListener(this.name, this));
            this.setFont(AddExcepDialog.this.getContentPane().getFont().deriveFont(0));
            String actionName = Internationalization.translate(this.name);
            if (actionName.contains("System")) {
                this.setMnemonic('o');
            } else {
                this.setMnemonic(actionName.charAt(0));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void update() {
            if (AddExcepDialog.this.theEvent == null) {
                this.setEnabled(false);
                this.setToolTipText(Internationalization.translate("selectEvent"));
                this.repaint();
                return;
            }
            this.setEnabled(true);
            boolean isSelected = true;
            if (AddExcepDialog.this.theEvent.usesGlobal()) {
                Global g = AddExcepDialog.this.theConfig.getGlobal(AddExcepDialog.this.theEvent.getSeverity());
                isSelected = g.hasAction(this.name);
            } else {
                isSelected = AddExcepDialog.this.theEvent.hasAction(this.name);
            }
            this.setSelected(isSelected);
            if (!AddExcepDialog.this.theEvent.hasAction(this.name)) {
                if (isSelected) {
                    AddExcepDialog.this.theEvent.addAction(AddExcepDialog.this.theConfig.getAction(this.name));
                    AddExcepDialog.this.addAlertEvent(AddExcepDialog.this.theEvent);
                    this.setToolTipText(Internationalization.translate("unselectAction"));
                } else {
                    this.setToolTipText(Internationalization.translate("selectAction"));
                }
            } else if (!isSelected) {
                AddExcepDialog.this.theEvent.removeAction(this.name);
                AddExcepDialog.this.addAlertEvent(AddExcepDialog.this.theEvent);
                this.setToolTipText(Internationalization.translate("selectAction"));
            } else {
                this.setToolTipText(Internationalization.translate("unselectAction"));
            }
            this.repaint();
        }
    }

    class AddExcepRenderer
    extends DefaultTableCellRenderer {
        AddExcepRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel labelForCell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!MainDialog.isWindows) {
                if (isSelected) {
                    this.setBackground(Color.RED);
                } else {
                    this.setBackground(Color.WHITE);
                }
            }
            if (column == 0) {
                labelForCell.setHorizontalAlignment(0);
            } else if (column == 1) {
                labelForCell.setHorizontalAlignment(2);
            } else if (column == 2) {
                // empty if block
            }
            return labelForCell;
        }
    }

    class AddExcepModel
    extends AbstractTableModel {
        String[] columName = new String[]{Internationalization.translate("id"), Internationalization.translate("description"), Internationalization.translate("sev")};

        AddExcepModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columName[col];
        }

        @Override
        public int getRowCount() {
            return AddExcepDialog.this.theExcepIds.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int key = (Integer)AddExcepDialog.this.theExcepIds.get(row);
            if (col == 0) {
                return new Integer(key).toString();
            }
            if (col == 1) {
                return AddExcepDialog.this.theStrings.getString(key);
            }
            if (col == 2) {
                String localizedSev = "";
                String sev = AddExcepDialog.this.getAlertEvent(key).getSeverity().getName();
                localizedSev = Internationalization.translate(sev);
                return localizedSev;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int key = (Integer)AddExcepDialog.this.theExcepIds.get(row);
            if (col == 2) {
                AddExcepDialog.this.theEvent = (AlertEvent)AddExcepDialog.this.getAlertEvent(key).clone();
                String sev = AddExcepDialog.this.translateBackToEnglish((String)value);
                System.out.println("setvalue sev " + sev);
                AddExcepDialog.this.theEvent.setSeverity(new Severity(sev));
                if (!AddExcepDialog.this.theEvent.usesGlobal()) {
                    AddExcepDialog.this.theEvent.setUseGlobals(true);
                }
                AddExcepDialog.this.addAlertEvent(AddExcepDialog.this.theEvent);
                AddExcepDialog.this.update();
            }
        }
    }

    public class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor(Object[] items) {
            super(new JComboBox<Object>(items));
        }

        @Override
        public Object getCellEditorValue() {
            JComboBox comp = (JComboBox)super.getComponent();
            return comp.getSelectedItem();
        }
    }
}

