/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.data.Severity;
import configurators.monitorgui.gui.BorderWithMnemonic;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainDialog;
import configurators.monitorgui.xml.AlertStrings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

class ChangeSevDialog
extends JDialog {
    ConfigData theConfig;
    AlertEvent theEvent = null;
    AlertStrings theStrings;
    ArrayList theExcepIds;
    ArrayList theSevs;
    AddExcepModel addExcepModel;
    JTable excepList;
    JButton addButton;
    JButton applyButton;
    JButton cancelButton;
    JComboBox sevBox;
    ArrayList actionBoxes = null;

    ChangeSevDialog(ConfigData c, AlertStrings ts, Frame p) {
        super(p, Internationalization.translate("changeSeverity"), true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.theStrings = ts;
        this.theConfig = c;
        this.theExcepIds = new ArrayList();
        Enumeration e = this.theConfig.getAlertEvents();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            this.theExcepIds.add(new Integer(key));
        }
        this.excepList = new JTable(new AddExcepModel());
        this.excepList.setCellSelectionEnabled(false);
        this.excepList.setRowSelectionAllowed(true);
        this.excepList.setSelectionMode(0);
        this.excepList.setDefaultRenderer(Object.class, new AddExcepRenderer());
        this.excepList.getTableHeader().setReorderingAllowed(false);
        this.excepList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ChangeSevDialog.this.excepList.getSelectedRow();
                if (index >= 0) {
                    int key = (Integer)ChangeSevDialog.this.theExcepIds.get(index);
                    ChangeSevDialog.this.theEvent = (AlertEvent)ChangeSevDialog.this.theConfig.getAlertEvent(key).clone();
                    ChangeSevDialog.this.updateBox();
                }
            }
        });
        this.excepList.getColumnModel().getColumn(0).setMaxWidth(40);
        this.excepList.getColumnModel().getColumn(2).setMaxWidth(80);
        JScrollPane scrollPane = new JScrollPane(this.excepList);
        if (!MainDialog.isWindows) {
            scrollPane.setBackground(new Color(124, 148, 196));
        }
        scrollPane.setFocusable(false);
        BorderWithMnemonic tableBwm = new BorderWithMnemonic(scrollPane, Internationalization.translate("selectEvent"), MainDialog.isWindows);
        tableBwm.setMnemonic('E');
        tableBwm.setLabelFor(this.excepList);
        this.getContentPane().add(tableBwm);
        this.addButton = new JButton(Internationalization.translate("ok"));
        this.getRootPane().setDefaultButton(this.addButton);
        this.applyButton = new JButton(Internationalization.translate("apply"));
        this.cancelButton = new JButton(Internationalization.translate("cancel"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChangeSevDialog.this.theEvent != null) {
                    ChangeSevDialog.this.theConfig.addAlertEvent(ChangeSevDialog.this.theEvent);
                    ChangeSevDialog.this.dispose();
                }
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChangeSevDialog.this.theEvent != null) {
                    ChangeSevDialog.this.theConfig.addAlertEvent(ChangeSevDialog.this.theEvent);
                    ChangeSevDialog.this.update();
                }
            }
        });
        this.applyButton.setMnemonic('A');
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeSevDialog.this.dispose();
            }
        });
        Box buttonPanel = new Box(0);
        buttonPanel.add(this.addButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 20)));
        buttonPanel.add(this.applyButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 20)));
        buttonPanel.add(this.cancelButton);
        this.theSevs = new ArrayList();
        ArrayList<String> theSevsStrings = new ArrayList<String>();
        Enumeration se = this.theConfig.getGlobals();
        while (se.hasMoreElements()) {
            int key = (Integer)se.nextElement();
            String s = new Severity(key).getName();
            this.theSevs.add(s);
            theSevsStrings.add(Internationalization.translate(s));
        }
        Box sevPanel = new Box(0);
        if (!MainDialog.isWindows) {
            sevPanel.setBackground(new Color(124, 148, 196));
        }
        this.sevBox = new JComboBox<Object>(theSevsStrings.toArray());
        BorderWithMnemonic sevBwm = new BorderWithMnemonic(sevPanel, Internationalization.translate("setSev"), false);
        sevBwm.setMnemonic('S');
        sevBwm.setLabelFor(this.sevBox);
        if (!MainDialog.isWindows) {
            this.sevBox.setBackground(new Color(124, 148, 196));
        }
        this.sevBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String next;
                String current;
                if (ChangeSevDialog.this.theEvent != null && !(current = ChangeSevDialog.this.theEvent.getSeverity().getName()).equals(next = (String)ChangeSevDialog.this.theSevs.get(ChangeSevDialog.this.sevBox.getSelectedIndex()))) {
                    ChangeSevDialog.this.theEvent.setSeverity(new Severity(next));
                    ChangeSevDialog.this.update();
                }
            }
        });
        sevPanel.add(this.sevBox);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        this.getContentPane().add(sevBwm);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        this.getContentPane().add(buttonPanel);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeSevDialog.this.dispose();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
        this.updateBox();
        this.pack();
    }

    void update() {
        this.repaint();
    }

    void updateBox() {
        if (this.theEvent != null) {
            String next;
            String current = (String)this.sevBox.getSelectedItem();
            if (!current.equals(next = Internationalization.translate(this.theEvent.getSeverity().getName()))) {
                this.sevBox.setSelectedItem(next);
            }
            this.sevBox.setEnabled(true);
        } else {
            this.sevBox.setEnabled(false);
        }
    }

    class AddExcepRenderer
    extends DefaultTableCellRenderer {
        AddExcepRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel labelForCell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0 || column == 2) {
                labelForCell.setHorizontalAlignment(0);
            } else {
                labelForCell.setHorizontalAlignment(2);
            }
            if (!MainDialog.isWindows) {
                if (isSelected) {
                    this.setBackground(Color.RED);
                } else {
                    this.setBackground(Color.WHITE);
                }
            }
            return labelForCell;
        }
    }

    class AddExcepModel
    extends AbstractTableModel {
        String[] columName = new String[]{Internationalization.translate("id"), Internationalization.translate("description"), Internationalization.translate("sev")};

        AddExcepModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columName[col];
        }

        @Override
        public int getRowCount() {
            return ChangeSevDialog.this.theExcepIds.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int key = (Integer)ChangeSevDialog.this.theExcepIds.get(row);
            if (col == 0) {
                return new Integer(key).toString();
            }
            if (col == 1) {
                return ChangeSevDialog.this.theStrings.getString(key);
            }
            if (col == 2) {
                return Internationalization.translate(ChangeSevDialog.this.theConfig.getAlertEvent(key).getSeverity().getName());
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

