/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.MainPanel;
import configurators.monitorgui.net.ClientListInfo;
import configurators.monitorgui.net.IpAddress;
import configurators.monitorgui.net.NetworkPacket;
import configurators.monitorgui.net.WWn;
import configurators.monitorgui.xml.AlertStrings;
import configurators.monitorgui.xml.parser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Configurator {
    private MainPanel mp;
    private int port;
    private WWn myW;
    private WWn monW;

    public static void main(String[] args) {
        new Configurator();
    }

    Configurator() {
        System.setProperty("javax.net.ssl.keyStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("javax.net.ssl.keyStorePassword", "knqwhner");
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            IpAddress myAd = new IpAddress(127, 0, 0, 1);
            this.myW = new WWn();
            this.monW = new WWn();
            this.myW.setIp(myAd);
            this.monW.setIp(myAd);
            this.myW.setPort(3071);
            this.port = this.askFramework(this.myW, this.myW);
            System.out.println("port:" + this.port);
            this.monW.setPort(this.port);
            this.spawn();
        }
        catch (Exception e) {
            System.out.println(" ouch!");
        }
    }

    int askFramework(WWn w, WWn myW) {
        String frameworkAddress = w.getIp().getShort(0) + "." + w.getIp().getShort(1) + "." + w.getIp().getShort(2) + "." + w.getIp().getShort(3);
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            Socket fs = factory.createSocket();
            fs.connect(new InetSocketAddress(frameworkAddress, w.getPort()), 5000);
            BufferedOutputStream sos = new BufferedOutputStream(fs.getOutputStream(), 1024);
            NetworkPacket np = new NetworkPacket();
            np.setSender(myW);
            np.setReceiver(w);
            np.setReqType(260);
            sos.write(np.getBytes());
            sos.flush();
            BufferedInputStream sis = new BufferedInputStream(fs.getInputStream(), 1024);
            byte[] bytestoread = new byte[100024];
            sis.read(bytestoread, 0, 60);
            NetworkPacket anp = new NetworkPacket(bytestoread);
            int answerSize = anp.getReqLen();
            WWn receiverW = anp.getReceiver();
            IpAddress rIp = receiverW.getIp();
            WWn senderW = anp.getSender();
            IpAddress sIp = senderW.getIp();
            sis.read(bytestoread, 60, answerSize);
            int nbClients = (answerSize - 4) / ClientListInfo.getSize();
            for (int i = 0; i < nbClients; ++i) {
                ClientListInfo cli = new ClientListInfo(bytestoread, 64 + i * ClientListInfo.getSize());
                System.out.println(cli.getMajor() + "|" + cli.getMinor());
                if (cli.getMajor() != 0 || cli.getMinor() != 9) continue;
                System.out.println("port:" + cli.getListenPort() + "\tid;" + cli.getWWn().getId());
                return cli.getListenPort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" ouch!");
        }
        return 0;
    }

    private void spawn() {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception E) {
            return;
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("monitorcontrol");
        Element child = doc.createElement("config-request");
        doc.appendChild(root);
        root.appendChild(child);
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(toSend);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, result);
        }
        catch (Exception e) {
            return;
        }
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            Socket s = factory.createSocket("127.0.0.1", 3071);
            BufferedOutputStream sos = new BufferedOutputStream(s.getOutputStream(), 1024);
            NetworkPacket np = new NetworkPacket();
            np.setReceiver(this.monW);
            np.setSender(this.myW);
            np.setReqType(2);
            np.addData(toSend.toByteArray());
            sos.write(np.getBytes());
            sos.flush();
            BufferedInputStream sis = new BufferedInputStream(s.getInputStream(), 1024);
            byte[] bytestoread = new byte[100024];
            sis.read(bytestoread, 0, 100024);
            NetworkPacket anp = new NetworkPacket(bytestoread);
            System.out.println("answersize: " + anp.getReqLen());
            parser p = new parser();
            p.parse(new ByteArrayInputStream(anp.getData()));
            ConfigData c = p.getConfig();
            if (c == null) {
                System.out.println("no work");
            }
            FileInputStream in = null;
            if (c == null) {
                return;
            }
            try {
                in = new FileInputStream(".." + File.separator + "Common" + File.separator + "alertStrings.xml");
            }
            catch (IOException ioe) {
                System.out.println("oops");
                ioe.printStackTrace();
            }
            AlertStrings ts = new AlertStrings(in);
            this.mp = new MainPanel(c, ts, this.port);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("could not create socket");
            return;
        }
    }
}

