/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.xml.AlertStrings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

class EditExcepDialog
extends JDialog {
    ConfigData theConfig;
    AlertEvent theEvent = null;
    ArrayList theExcepIds;
    JTable excepList;
    AlertStrings theStrings;
    ArrayList actionBoxes = null;

    EditExcepDialog(Frame p, ConfigData c, AlertStrings ts, AlertEvent ae) {
        super(p, Internationalization.translate("edit"), true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.theStrings = ts;
        this.theConfig = c;
        this.theEvent = (AlertEvent)ae.clone();
        this.theExcepIds = new ArrayList();
        JButton addButton = new JButton(Internationalization.translate("ok"));
        this.getRootPane().setDefaultButton(addButton);
        JButton cancelButton = new JButton(Internationalization.translate("cancel"));
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditExcepDialog.this.dispose();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
        JPanel boxPanel = new JPanel();
        this.actionBoxes = new ArrayList();
        Enumeration e = this.theConfig.getActions();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            this.actionBoxes.add(new ActionBox(a));
        }
        boxPanel.setLayout(new GridLayout(2, (this.actionBoxes.size() + 1) / 2));
        for (int i = 0; i < this.actionBoxes.size(); ++i) {
            boxPanel.add((ActionBox)this.actionBoxes.get(i));
        }
        TitledBorder titleBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 20, 20, 20), Internationalization.translate("setDel"));
        boxPanel.setBorder(BorderFactory.createCompoundBorder(titleBorder2, BorderFactory.createLineBorder(Color.BLACK)));
        Box labelPanel = new Box(0);
        JLabel idLabel = new JLabel(Internationalization.translate("id") + ":" + this.theEvent.getId() + "-");
        idLabel.setFont(this.getContentPane().getFont().deriveFont(0));
        labelPanel.add(idLabel);
        JLabel descLabel = new JLabel(this.theStrings.getString(this.theEvent.getId()) + " | ");
        descLabel.setFont(this.getContentPane().getFont().deriveFont(0));
        labelPanel.add(descLabel);
        JLabel sevLabel = new JLabel(Internationalization.translate(this.theEvent.getSeverity().getName()));
        sevLabel.setFont(this.getContentPane().getFont().deriveFont(0));
        labelPanel.add(sevLabel);
        labelPanel.setBorder(BorderFactory.createTitledBorder(Internationalization.translate("event")));
        this.getContentPane().add(labelPanel);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 20)));
        this.getContentPane().add(boxPanel);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditExcepDialog.this.theEvent != null) {
                    EditExcepDialog.this.theConfig.addAlertEvent(EditExcepDialog.this.theEvent);
                    EditExcepDialog.this.dispose();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditExcepDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(addButton);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        Box buttonBox = new Box(0);
        buttonBox.add(addButton);
        buttonBox.add(Box.createRigidArea(new Dimension(10, 10)));
        buttonBox.add(cancelButton);
        this.getContentPane().add(buttonBox);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        this.update();
        this.pack();
    }

    void update() {
        if (this.actionBoxes != null) {
            for (int i = 0; i < this.actionBoxes.size(); ++i) {
                System.out.println(i);
                ((ActionBox)this.actionBoxes.get(i)).update();
            }
        }
    }

    class CheckBoxListener
    implements ActionListener {
        private String name;
        private ActionBox box;

        public CheckBoxListener(String s, ActionBox b) {
            this.name = s;
            this.box = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditExcepDialog.this.theEvent != null) {
                if (this.box.isSelected()) {
                    EditExcepDialog.this.theEvent.addAction(EditExcepDialog.this.theConfig.getAction(this.name));
                    this.box.setToolTipText(Internationalization.translate("unselectAction"));
                } else {
                    EditExcepDialog.this.theEvent.removeAction(this.name);
                    this.box.setToolTipText(Internationalization.translate("selectAction"));
                }
            }
        }
    }

    class ActionBox
    extends JCheckBox {
        private String name;

        ActionBox(String n) {
            super(Internationalization.translate(n));
            this.name = n;
            this.addActionListener(new CheckBoxListener(this.name, this));
            this.setFont(EditExcepDialog.this.getContentPane().getFont().deriveFont(0));
            this.setMnemonic(Internationalization.translate(n).charAt(0));
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void update() {
            if (EditExcepDialog.this.theEvent == null) {
                this.setEnabled(false);
                this.setToolTipText(Internationalization.translate("selectEvent"));
                this.repaint();
                return;
            }
            this.setEnabled(true);
            boolean isSelected = true;
            isSelected = EditExcepDialog.this.theEvent.hasAction(this.name);
            this.setSelected(isSelected);
            this.repaint();
        }
    }
}

