/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.data.Global;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.xml.AlertStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

class EditRuleDialog
extends JDialog {
    ConfigData theConfig;
    Global theGlobal = null;
    ArrayList theExcepIds;
    JTable excepList;
    AlertStrings theStrings;
    ArrayList actionBoxes = null;

    EditRuleDialog(Frame p, ConfigData c, AlertStrings ts, Global g) {
        super(p, Internationalization.translate("edit"), true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.theStrings = ts;
        this.theConfig = c;
        this.theGlobal = (Global)g.clone();
        this.theExcepIds = new ArrayList();
        JButton addButton = new JButton(Internationalization.translate("ok"));
        JButton cancelButton = new JButton(Internationalization.translate("cancel"));
        JPanel boxPanel = new JPanel();
        this.actionBoxes = new ArrayList();
        Enumeration e = this.theConfig.getActions();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            this.actionBoxes.add(new ActionBox(a));
        }
        boxPanel.setLayout(new GridLayout(2, (this.actionBoxes.size() + 1) / 2));
        for (int i = 0; i < this.actionBoxes.size(); ++i) {
            boxPanel.add((ActionBox)this.actionBoxes.get(i));
        }
        TitledBorder titleBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 20, 20, 20), Internationalization.translate("setDel"));
        boxPanel.setBorder(BorderFactory.createCompoundBorder(titleBorder2, BorderFactory.createLineBorder(Color.BLACK)));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BorderLayout());
        JLabel labelLabel = new JLabel(Internationalization.translate("sev") + ": " + Internationalization.translate(this.theGlobal.getSeverity().getName()));
        labelLabel.setFont(this.getContentPane().getFont().deriveFont(0));
        labelPanel.add((Component)labelLabel, "West");
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(labelPanel);
        this.getContentPane().add(boxPanel);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditRuleDialog.this.theGlobal != null) {
                    EditRuleDialog.this.theConfig.addGlobal(EditRuleDialog.this.theGlobal, EditRuleDialog.this.theGlobal.getSeverity());
                    System.out.println(EditRuleDialog.this.theConfig.getGlobalsCount());
                    EditRuleDialog.this.dispose();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRuleDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(addButton);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        Box buttonBox = new Box(0);
        buttonBox.add(addButton);
        buttonBox.add(Box.createRigidArea(new Dimension(10, 10)));
        buttonBox.add(cancelButton);
        this.getContentPane().add(buttonBox);
        this.getContentPane().add(Box.createRigidArea(new Dimension(100, 10)));
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRuleDialog.this.dispose();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
        this.update();
        this.pack();
    }

    void update() {
        if (this.actionBoxes != null) {
            for (int i = 0; i < this.actionBoxes.size(); ++i) {
                System.out.println(i);
                ((ActionBox)this.actionBoxes.get(i)).update();
            }
        }
    }

    class CheckBoxListener
    implements ActionListener {
        private String name;
        private ActionBox box;

        public CheckBoxListener(String s, ActionBox b) {
            this.name = s;
            this.box = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditRuleDialog.this.theGlobal != null) {
                if (this.box.isSelected()) {
                    EditRuleDialog.this.theGlobal.addAction(EditRuleDialog.this.theConfig.getAction(this.name));
                    this.box.setToolTipText(Internationalization.translate("unselectAction"));
                } else {
                    EditRuleDialog.this.theGlobal.removeAction(this.name);
                    this.box.setToolTipText(Internationalization.translate("selectAction"));
                }
            }
        }
    }

    class ActionBox
    extends JCheckBox {
        private String name;

        ActionBox(String n) {
            super(Internationalization.translate(n));
            this.name = n;
            this.addActionListener(new CheckBoxListener(this.name, this));
            this.setFont(EditRuleDialog.this.getContentPane().getFont().deriveFont(0));
            this.setMnemonic(Internationalization.translate(n).charAt(0));
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void update() {
            if (EditRuleDialog.this.theGlobal == null) {
                this.setEnabled(false);
                this.setToolTipText(Internationalization.translate("selectEvent"));
                this.repaint();
                return;
            }
            this.setEnabled(true);
            boolean isSelected = true;
            isSelected = EditRuleDialog.this.theGlobal.hasAction(this.name);
            this.setSelected(isSelected);
            this.repaint();
        }
    }
}

