/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.Action;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainDialog;
import configurators.monitorgui.gui.MainThing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class EmailDetailPanel
extends JPanel {
    private JButton addButton;
    private JButton removeButton;
    public JButton testButton;
    private JLabel addNewEmailLabel;
    private JLabel recptEmailAddLabel;
    private JTextField newRecpMailAddrField;
    private JScrollPane targetPane;
    private JPanel buttonPanel;
    private String newRecpMailStr;
    private Action emailAction;
    private ConfigData theConfig;
    private JTable eTable;
    private MainThing mainPanel;
    private DefaultListModel dListModel;
    private EmailModel emailModel;

    public EmailDetailPanel(ConfigData c, MainThing m) {
        this.mainPanel = m;
        this.theConfig = c;
        this.emailAction = c.getAction("email");
        this.setLayout(new BoxLayout(this, 1));
        this.addNewEmailLabel = new JLabel(Internationalization.translate("newemailaddress") + ":");
        this.addNewEmailLabel.setDisplayedMnemonic('N');
        this.newRecpMailStr = "";
        this.newRecpMailAddrField = new JTextField(this.newRecpMailStr, 32);
        this.addNewEmailLabel.setLabelFor(this.newRecpMailAddrField);
        this.emailModel = new EmailModel();
        this.eTable = new JTable(this.emailModel);
        this.eTable.setCellSelectionEnabled(false);
        this.eTable.setRowSelectionAllowed(true);
        this.eTable.setDragEnabled(false);
        this.eTable.setDefaultRenderer(Object.class, new EmailRenderer());
        this.eTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.eTable.setSelectionMode(0);
        this.eTable.getTableHeader().setReorderingAllowed(false);
        this.eTable.setShowGrid(false);
        this.eTable.setBorder(BorderFactory.createLineBorder(Color.WHITE, 1));
        this.eTable.setTableHeader(null);
        this.eTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selected = EmailDetailPanel.this.eTable.getSelectedRow();
                    if (selected >= 0) {
                        EmailDetailPanel.this.removeButton.setEnabled(true);
                    } else {
                        EmailDetailPanel.this.removeButton.setEnabled(false);
                    }
                }
            }
        });
        this.targetPane = new JScrollPane(this.eTable, 20, 30);
        if (!MainDialog.isWindows) {
            this.targetPane.getViewport().setBackground(Color.WHITE);
        }
        this.addButton = new JButton(Internationalization.translate("add") + "...");
        this.addButton.setMnemonic('A');
        this.removeButton = new JButton(Internationalization.translate("remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setMnemonic('R');
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newValue = EmailDetailPanel.this.newRecpMailAddrField.getText();
                if (newValue != null && newValue.length() > 0) {
                    if (EmailDetailPanel.this.emailAction.getParam("email-target") == null) {
                        ArrayList<String> newParam = new ArrayList<String>();
                        newParam.add(newValue);
                        EmailDetailPanel.this.emailAction.setParam("email-target", newParam);
                    } else {
                        EmailDetailPanel.this.emailAction.getParam("email-target").add(newValue);
                    }
                    EmailDetailPanel.this.emailModel.update();
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Removing..");
                EmailDetailPanel.this.emailAction.getParam("email-target").remove(EmailDetailPanel.this.eTable.getSelectedRow());
                EmailDetailPanel.this.emailModel.update();
            }
        });
        this.recptEmailAddLabel = new JLabel(Internationalization.translate("EmailAddresses") + ":");
        this.recptEmailAddLabel.setDisplayedMnemonic('e');
        this.recptEmailAddLabel.setLabelFor(this.eTable);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.removeButton);
        this.testButton = new JButton(Internationalization.translate("test"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailDetailPanel.this.mainPanel.testMail();
            }
        });
        this.testButton.setMnemonic('T');
        this.testButton.setAlignmentX(0.5f);
        this.buttonPanel.add(this.testButton);
        this.add(Box.createRigidArea(new Dimension(400, 10)));
        this.add(this.getMailDetailsPanel());
        this.add(Box.createRigidArea(new Dimension(400, 15)));
    }

    private JPanel getMailDetailsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(15, 0, 5, 0);
        panel.add((Component)this.addNewEmailLabel, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        ++gbc.gridy;
        panel.add((Component)this.newRecpMailAddrField, gbc);
        gbc.insets = new Insets(0, 0, 15, 0);
        ++gbc.gridy;
        panel.add((Component)this.addButton, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        ++gbc.gridy;
        panel.add((Component)this.recptEmailAddLabel, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        ++gbc.gridy;
        panel.add((Component)this.targetPane, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        ++gbc.gridy;
        panel.add((Component)this.buttonPanel, gbc);
        return panel;
    }

    class EmailRenderer
    extends DefaultTableCellRenderer {
        EmailRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel labelForCell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!MainDialog.isWindows) {
                if (isSelected) {
                    this.setBackground(Color.RED);
                } else {
                    this.setBackground(Color.WHITE);
                }
            }
            return labelForCell;
        }
    }

    class EmailModel
    extends AbstractTableModel {
        Object[] theAddresses;

        EmailModel() {
            ArrayList theAddressArrayList = EmailDetailPanel.this.emailAction.getParam("email-target");
            this.theAddresses = theAddressArrayList == null ? new Object[0] : theAddressArrayList.toArray();
        }

        @Override
        public int getRowCount() {
            return this.theAddresses.length;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return (String)this.theAddresses[row];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public void update() {
            this.theAddresses = EmailDetailPanel.this.emailAction.getParam("email-target").toArray();
            this.fireTableDataChanged();
        }
    }
}

