/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.Action;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainThing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EmailPanel
extends JPanel {
    private String senderAddressString;
    private String senderNICString;
    private String senderPORTString;
    private String serverNameString;
    private String userNameString;
    private String portNumberString = "";
    private String passwordString;
    private Component parent = null;
    private Action emailAction;
    private ConfigData theConfig;
    private JTextField serverNameField;
    private JTextField senderAddressField;
    private JComboBox senderNICField;
    private JTextField userNameField;
    private JTextField portNumberField;
    private JPasswordField passwordField;
    private JCheckBox checkedBox;
    private JCheckBox defaultPort;
    private MainThing mainPanel;

    public EmailPanel(ConfigData c, MainThing m) {
        String authType;
        this.mainPanel = m;
        this.theConfig = c;
        this.emailAction = c.getAction("email");
        this.setLayout(new BoxLayout(this, 1));
        ArrayList serverNamesList = this.emailAction.getParam("servername");
        this.serverNameString = serverNamesList == null || serverNamesList.isEmpty() ? "" : (String)serverNamesList.get(0);
        ArrayList senderAddressList = this.emailAction.getParam("sender");
        this.senderAddressString = senderAddressList == null || senderAddressList.isEmpty() ? "" : (String)senderAddressList.get(0);
        ArrayList senderNIC = this.emailAction.getParam("sender");
        this.senderNICString = senderNIC == null || senderNIC.isEmpty() ? "" : (String)senderNIC.get(0);
        ArrayList senderPort = this.emailAction.getParam("port");
        this.senderPORTString = senderPort == null || senderPort.isEmpty() ? "" : (String)senderPort.get(0);
        ArrayList userNamesList = this.emailAction.getParam("username");
        this.userNameString = userNamesList == null || userNamesList.isEmpty() ? "" : (String)userNamesList.get(0);
        ArrayList passwordList = this.emailAction.getParam("password");
        this.passwordString = passwordList == null || passwordList.isEmpty() ? "" : (String)passwordList.get(0);
        this.serverNameField = new JTextField(this.serverNameString, 32);
        this.senderAddressField = new JTextField(this.senderAddressString, 32);
        ArrayList<String> nicList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                Enumeration<InetAddress> inet = e.nextElement().getInetAddresses();
                while (inet.hasMoreElements()) {
                    InetAddress netAdr = inet.nextElement();
                    nicList.add(netAdr.getHostAddress());
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String[] nicArray = new String[nicList.size()];
        for (int i = 0; i < nicList.size(); ++i) {
            nicArray[i] = new String((String)nicList.get(i)).trim();
        }
        int index = 0;
        String nicAddress = "";
        for (int i = 0; i < nicArray.length; ++i) {
            nicAddress = nicArray[i];
            if (!nicAddress.equalsIgnoreCase(this.senderNICString)) continue;
            index = i;
            break;
        }
        this.senderNICField = new JComboBox<String>(nicArray);
        this.senderNICField.setSelectedIndex(index);
        this.portNumberField = new JTextField(this.portNumberString, 4);
        System.out.println("portNumberString ==" + this.portNumberString);
        this.userNameField = new JTextField(this.userNameString, 30);
        this.passwordField = new JPasswordField(this.passwordString, 30);
        ArrayList authMechanismList = this.emailAction.getParam("authentication-type");
        if (authMechanismList == null || authMechanismList.isEmpty()) {
            authType = "";
        } else {
            authType = (String)authMechanismList.get(0);
            System.out.println("Auth type:" + authType);
        }
        if (authType.equals("none")) {
            this.checkedBox = new JCheckBox(Internationalization.translate("checkboxMessage"));
            this.userNameField.setEditable(false);
            this.passwordField.setEditable(false);
        } else {
            this.checkedBox = new JCheckBox(Internationalization.translate("checkboxMessage"), true);
        }
        this.senderNICField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                String str = (String)EmailPanel.this.senderNICField.getSelectedItem();
                System.out.println("Sender NIC Address = " + str);
                EmailPanel.this.emailAction.getParam("nic").set(0, EmailPanel.this.senderNICField.getSelectedItem());
            }
        });
        this.senderAddressField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("sender").set(0, EmailPanel.this.senderAddressField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("sender").set(0, EmailPanel.this.senderAddressField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("sender").set(0, EmailPanel.this.senderAddressField.getText());
            }
        });
        this.portNumberField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("port").set(0, EmailPanel.this.portNumberField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("port").set(0, EmailPanel.this.portNumberField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("port").set(0, EmailPanel.this.portNumberField.getText());
            }
        });
        this.serverNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("servername").set(0, EmailPanel.this.serverNameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("servername").set(0, EmailPanel.this.serverNameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("servername").set(0, EmailPanel.this.serverNameField.getText());
            }
        });
        this.userNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("username").set(0, EmailPanel.this.userNameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("username").set(0, EmailPanel.this.userNameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("username").set(0, EmailPanel.this.userNameField.getText());
            }
        });
        this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("password").set(0, new String(EmailPanel.this.passwordField.getPassword()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("password").set(0, new String(EmailPanel.this.passwordField.getPassword()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmailPanel.this.emailAction.getParam("password").set(0, new String(EmailPanel.this.passwordField.getPassword()));
            }
        });
        if (this.senderPORTString.equals("25")) {
            this.defaultPort = new JCheckBox(Internationalization.translate("defaultPort"), true);
            this.portNumberField.setEditable(false);
            this.portNumberField.setText("25");
        } else {
            this.defaultPort = new JCheckBox(Internationalization.translate("defaultPort"), false);
            this.portNumberField.setEditable(true);
            this.portNumberField.setText(this.senderPORTString);
        }
        this.defaultPort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (EmailPanel.this.defaultPort.isSelected()) {
                    EmailPanel.this.portNumberField.setEditable(false);
                    EmailPanel.this.portNumberField.setText("25");
                } else {
                    EmailPanel.this.portNumberField.setEditable(true);
                }
            }
        });
        System.out.println("ADDING LABEl");
        this.checkedBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (EmailPanel.this.checkedBox.isSelected()) {
                    EmailPanel.this.userNameField.setEditable(true);
                    EmailPanel.this.userNameField.setEnabled(true);
                    EmailPanel.this.passwordField.setEditable(true);
                    EmailPanel.this.passwordField.setEnabled(true);
                    ArrayList<String> newParamU = new ArrayList<String>();
                    newParamU.add(EmailPanel.this.userNameField.getText());
                    EmailPanel.this.emailAction.setParam("username", newParamU);
                    ArrayList<String> newParamP = new ArrayList<String>();
                    newParamP.add(new String(EmailPanel.this.passwordField.getPassword()));
                    EmailPanel.this.emailAction.setParam("password", newParamP);
                    ArrayList<String> newParamAuth = new ArrayList<String>();
                    newParamAuth.add("basic");
                    EmailPanel.this.emailAction.setParam("authentication-type", newParamAuth);
                } else {
                    EmailPanel.this.userNameField.setEditable(false);
                    EmailPanel.this.userNameField.setEnabled(false);
                    EmailPanel.this.passwordField.setEditable(false);
                    EmailPanel.this.passwordField.setEnabled(false);
                    ArrayList<String> newParamU = new ArrayList<String>();
                    newParamU.add("");
                    EmailPanel.this.emailAction.setParam("username", newParamU);
                    ArrayList<String> newParamP = new ArrayList<String>();
                    newParamP.add("");
                    EmailPanel.this.emailAction.setParam("password", newParamP);
                    ArrayList<String> newParamAuth = new ArrayList<String>();
                    newParamAuth.add("none");
                    EmailPanel.this.emailAction.setParam("authentication-type", newParamAuth);
                }
            }
        });
        this.add(Box.createRigidArea(new Dimension(100, 10)));
        this.add(this.getMailSettingsPanel());
        this.add(Box.createRigidArea(new Dimension(100, 15)));
    }

    public boolean validatePanel() {
        System.out.println(this.checkedBox.isSelected());
        System.out.println(this.serverNameField.getText());
        System.out.println(this.senderAddressField.getText());
        System.out.println(this.userNameField.getText());
        System.out.println(this.passwordField.getText());
        return true;
    }

    public boolean getCheckboxStatus() {
        return this.checkedBox.isSelected();
    }

    private JPanel getMailSettingsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(15, 0, 5, 0);
        JLabel senderLabel = new JLabel(Internationalization.translate("senderaddress") + ":");
        senderLabel.setDisplayedMnemonic('e');
        senderLabel.setLabelFor(this.senderAddressField);
        panel.add((Component)senderLabel, gbc);
        gbc.insets = new Insets(0, 0, 10, 0);
        ++gbc.gridy;
        panel.add((Component)this.senderAddressField, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        ++gbc.gridy;
        JLabel serverLabel = new JLabel(Internationalization.translate("SMTPserver") + ":");
        serverLabel.setDisplayedMnemonic('M');
        serverLabel.setLabelFor(this.serverNameField);
        panel.add((Component)serverLabel, gbc);
        gbc.insets = new Insets(0, 0, 10, 0);
        ++gbc.gridy;
        panel.add((Component)this.serverNameField, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 10, 0);
        JLabel senderPORTLabel = new JLabel("Port");
        senderPORTLabel.setDisplayedMnemonic('P');
        senderPORTLabel.setLabelFor(this.portNumberField);
        System.out.println("ADDING senderPORTLabel");
        panel.add((Component)senderPORTLabel, gbc);
        gbc.insets = new Insets(0, 50, 10, 0);
        System.out.println("ADDING portNumberField");
        panel.add((Component)this.portNumberField, gbc);
        System.out.println(" portNumberField is added");
        gbc.insets = new Insets(0, 130, 10, 0);
        this.defaultPort.setMnemonic('d');
        System.out.println("ADDING DEF PORT LABEL");
        panel.add((Component)this.defaultPort, gbc);
        gbc.insets = new Insets(0, 160, 10, 0);
        JLabel def = new JLabel("Use Default");
        def.setDisplayedMnemonic('D');
        System.out.println("ADDING DEFALT CHECK BOX");
        panel.add((Component)def, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        ++gbc.gridy;
        this.checkedBox.setMnemonic('q');
        panel.add((Component)this.checkedBox, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 19, 5, 0);
        JLabel userLabel = new JLabel(Internationalization.translate("Username"));
        userLabel.setDisplayedMnemonic('U');
        userLabel.setLabelFor(this.userNameField);
        panel.add((Component)userLabel, gbc);
        gbc.insets = new Insets(0, 19, 10, 0);
        ++gbc.gridy;
        panel.add((Component)this.userNameField, gbc);
        gbc.insets = new Insets(0, 19, 5, 0);
        ++gbc.gridy;
        JLabel passwordLabel = new JLabel(Internationalization.translate("Password"));
        passwordLabel.setDisplayedMnemonic('P');
        passwordLabel.setLabelFor(this.passwordField);
        panel.add((Component)passwordLabel, gbc);
        gbc.insets = new Insets(0, 19, 15, 0);
        ++gbc.gridy;
        panel.add((Component)this.passwordField, gbc);
        panel.setBorder(BorderFactory.createTitledBorder(""));
        return panel;
    }
}

