/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.AddExcepDialog;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainDialog;
import configurators.monitorgui.gui.MainThing;
import configurators.monitorgui.xml.AlertStrings;
import configurators.monitorgui.xml.parser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

class ExcepPanel
extends JPanel {
    ConfigData theConfig;
    AlertStrings theStrings;
    ArrayList theExcepIds;
    MainThing mainPanel;
    JButton changeIndividualEventButton;
    ExcepModel excepModel;
    Frame parentFrame;
    AddExcepDialog addDialog = null;

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
    }

    ExcepPanel(ConfigData c, AlertStrings ts, Container p, MainThing m) {
        this.theConfig = c;
        this.theStrings = ts;
        this.parentFrame = (Frame)p;
        this.mainPanel = m;
        this.setLayout(new BoxLayout(this, 1));
        this.theExcepIds = new ArrayList();
        Enumeration e = this.theConfig.getAlertEvents();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            if (this.theConfig.getAlertEvent(key).usesGlobal()) continue;
            this.theExcepIds.add(new Integer(key));
        }
        this.excepModel = new ExcepModel();
        this.add(Box.createRigidArea(new Dimension(500, 10)));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        System.out.println("The list of events " + this.theConfig.getAlertEventsCount());
        this.changeIndividualEventButton = new JButton(Internationalization.translate("changeIndividualSev") + "...");
        this.changeIndividualEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExcepPanel.this.addDialog = new AddExcepDialog(ExcepPanel.this.parentFrame, ExcepPanel.this.theConfig, ExcepPanel.this.theStrings, ExcepPanel.this.mainPanel, ExcepPanel.this);
                ExcepPanel.this.addDialog.setLocationRelativeTo(ExcepPanel.this);
                ExcepPanel.this.addDialog.setVisible(true);
                ExcepPanel.this.update();
            }
        });
        this.changeIndividualEventButton.setMnemonic('C');
        buttonPanel.add(this.changeIndividualEventButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(200, 400)));
        this.add(buttonPanel);
        this.update();
    }

    public ConfigData restore() {
        parser p = new parser();
        System.out.println("Load config-default.xml");
        try {
            p.parse(new FileInputStream("./MegaMonitor/config-default.xml"));
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception");
            ioe.printStackTrace();
        }
        ConfigData theConfigData = p.getConfig();
        if (theConfigData == null) {
            System.out.println("Config is Null can't restore");
        }
        this.theConfig = theConfigData;
        if (this.addDialog != null) {
            this.addDialog.dispose();
        }
        this.addDialog = new AddExcepDialog(this.parentFrame, this.theConfig, this.theStrings, this.mainPanel, this);
        this.addDialog.setLocationRelativeTo(this);
        this.addDialog.setVisible(true);
        this.update();
        return this.theConfig;
    }

    void update() {
        this.theExcepIds = new ArrayList();
        Enumeration e = this.theConfig.getAlertEvents();
        while (e.hasMoreElements()) {
            int key = (Integer)e.nextElement();
            if (this.theConfig.getAlertEvent(key).usesGlobal()) continue;
            this.theExcepIds.add(new Integer(key));
        }
        this.excepModel.fireTableDataChanged();
        this.updateButtons();
    }

    void updateButtons() {
    }

    class ExcepRenderer
    extends DefaultTableCellRenderer {
        ExcepRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel labelForCell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0 || column == 2) {
                labelForCell.setHorizontalAlignment(0);
            } else {
                labelForCell.setHorizontalAlignment(2);
            }
            if (!MainDialog.isWindows) {
                if (isSelected) {
                    this.setBackground(Color.RED);
                } else {
                    this.setBackground(Color.WHITE);
                }
            }
            return labelForCell;
        }
    }

    class ExcepModel
    extends AbstractTableModel {
        String[] columName = new String[]{Internationalization.translate("id"), Internationalization.translate("description"), Internationalization.translate("sev"), Internationalization.translate("deliverAlertsby")};

        ExcepModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columName[col];
        }

        @Override
        public int getRowCount() {
            return ExcepPanel.this.theExcepIds.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int key = (Integer)ExcepPanel.this.theExcepIds.get(row);
            if (col == 0) {
                return new Integer(key).toString();
            }
            if (col == 1) {
                return ExcepPanel.this.theStrings.getString(key);
            }
            if (col == 2) {
                return Internationalization.translate(ExcepPanel.this.theConfig.getAlertEvent(key).getSeverity().getName());
            }
            if (col == 3) {
                AlertEvent a = ExcepPanel.this.theConfig.getAlertEvent(key);
                int count = a.getActionsCount();
                String s = "";
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        s = s + ",";
                    }
                    s = s + Internationalization.translate(a.getAction(i).getName());
                }
                return s;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

