/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import Framework.Configurator.LoggedInServerInfo;
import GUI.VivaldiBrandingPanel;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import configurators.monitorgui.data.Action;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.AlertPanel;
import configurators.monitorgui.gui.EmailDetailPanel;
import configurators.monitorgui.gui.EmailPanel;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainThing;
import configurators.monitorgui.net.Communicator;
import configurators.monitorgui.xml.AlertStrings;
import configurators.monitorgui.xml.MessageFactory;
import configurators.monitorgui.xml.parser;
import configurators.monitorgui.xml.writer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainDialog
extends JDialog
implements MainThing {
    private ConfigData theConfig;
    private AlertStrings theStrings;
    private MessageFactory messageFactory;
    private Communicator communicator = null;
    private Frame parent;
    private JTabbedPane tabbedPane;
    private AlertPanel eventsPanel;
    private EmailPanel mailSeverPanel;
    private EmailDetailPanel testEmailPanel;
    private LoggedInServerInfo server;
    public static boolean isWindows = false;

    public MainDialog(ConfigData c, AlertStrings ts, Communicator com, Frame p, LoggedInServerInfo s) {
        super(p, Internationalization.translate("Configuration"), true);
        this.parent = p;
        this.theConfig = c;
        this.theStrings = ts;
        this.server = s;
        this.communicator = com;
        this.messageFactory = new MessageFactory();
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            isWindows = true;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.setResizable(false);
        MainDialog.setIcon(this);
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.add((Component)VivaldiBrandingPanel.getInstance().getBannerPanel(0), "North");
        this.getContentPane().add((Component)upperPanel, "North");
        this.eventsPanel = new AlertPanel(c, ts, this.parent, this);
        this.mailSeverPanel = new EmailPanel(c, this);
        this.testEmailPanel = new EmailDetailPanel(c, this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Internationalization.translate("Events"), this.eventsPanel);
        this.tabbedPane.addTab(Internationalization.translate("EmailSettings"), this.mailSeverPanel);
        this.tabbedPane.addTab(Internationalization.translate("testEmailPanel"), this.testEmailPanel);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MainDialog.this.tabbedPane.getSelectedIndex() == 0) {
                    MainDialog.this.eventsPanel.update();
                }
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JButton saveButton = new JButton(Internationalization.translate("save") + "...");
        JButton loadButton = new JButton(Internationalization.translate("load") + "...");
        JButton OKButton = new JButton(Internationalization.translate("commit"));
        JButton cancelButton = new JButton(Internationalization.translate("exit"));
        JButton helpButton = new JButton(Internationalization.translate("Help"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.write();
            }
        });
        saveButton.setMnemonic('S');
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.read();
            }
        });
        loadButton.setMnemonic('O');
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.commit();
                MainDialog.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.cancelMainDialog();
            }
        });
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.help();
            }
        });
        helpButton.setMnemonic('H');
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel saveLoadPanel = new JPanel();
        saveLoadPanel.add(saveButton);
        saveLoadPanel.add(Box.createHorizontalStrut(10));
        saveLoadPanel.add(loadButton);
        JPanel OKCancelPanel = new JPanel();
        OKCancelPanel.add(Box.createHorizontalStrut(40));
        OKCancelPanel.add(OKButton);
        OKCancelPanel.add(Box.createHorizontalStrut(10));
        OKCancelPanel.add(cancelButton);
        OKCancelPanel.add(Box.createHorizontalStrut(10));
        OKCancelPanel.add(helpButton);
        buttonPanel.add((Component)saveLoadPanel, "West");
        buttonPanel.add(Box.createRigidArea(new Dimension(50, 50)), "Center");
        buttonPanel.add((Component)OKCancelPanel, "South");
        buttonPanel.add(Box.createRigidArea(new Dimension(50, 50)));
        this.getContentPane().add((Component)buttonPanel, "South");
        this.mapEscapeKey();
        this.setDefaultCloseOperation(2);
        this.pack();
        GUIUtils.centerDialogOnScreen((Window)this);
        this.setVisible(true);
        if (this.server.getGUILoginMode() != 0) {
            OKButton.setEnabled(false);
            this.testEmailPanel.testButton.setEnabled(false);
        }
    }

    public static void setIcon(JDialog jDg) {
        Image icon = Toolkit.getDefaultToolkit().getImage(Resource.getString((String)"LSI_PROGRAM_ICON_16", (String)"16_prg_icon.png"));
        jDg.setIconImage(icon);
    }

    private void mapEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.cancelMainDialog();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private void cancelMainDialog() {
        String str = Internationalization.translate("confirmCancelConfigureAerts");
        if (CustomMsgBox.confirm((Component)this.getContentPane(), (String)str, (int)2)) {
            this.dispose();
        }
    }

    private void help() {
        try {
            String osName = System.getProperty("os.name").toUpperCase();
            if (osName.startsWith("WINDOWS")) {
                Runtime.getRuntime().exec("startmonitorhelp.bat " + this.getLocaleSpecificDirectory());
            } else {
                Runtime.getRuntime().exec("./startmonitorhelp.sh " + this.getLocaleSpecificDirectory());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getLocaleSpecificDirectory() {
        String monitorHelpDir = "MegaMonitor";
        String dir = Internationalization.getPath("Help");
        System.out.println("From getPath - " + dir);
        if (dir != null) {
            return dir + File.separator + monitorHelpDir;
        }
        String helpDir = "docs";
        String langDir = File.separator + "Languages" + File.separator;
        String localePath = Locale.getDefault().getLanguage();
        if (localePath.equals(Locale.CHINESE.getLanguage())) {
            localePath = localePath + "-" + Locale.getDefault().getCountry();
        }
        if (!new File("." + File.separator + helpDir + langDir + localePath).exists()) {
            localePath = "en";
        }
        if (!new File("." + File.separator + helpDir + langDir + localePath).exists()) {
            return helpDir + File.separator + monitorHelpDir;
        }
        return helpDir + langDir + localePath + File.separator + monitorHelpDir;
    }

    private void write() {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File("monitorconfig.xml"));
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            writer w = new writer(chooser.getSelectedFile().getPath());
            w.write(this.theConfig);
        }
    }

    private boolean showCustomizedConfirmDialog() {
        String title;
        String str1 = Internationalization.translate("loadBackupInfoWarning");
        String str2 = Internationalization.translate("loadBackupInfoConfirm");
        String newline = System.getProperty("line.separator");
        String msg = str1 + newline + newline + str2 + newline;
        return JOptionPane.showConfirmDialog(this, msg, title = Internationalization.translate("loadBackupTitle"), 0, 2) != 1;
    }

    private void read() {
        if (!this.showCustomizedConfirmDialog()) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File("monitorconfig.xml"));
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(chooser.getSelectedFile().getPath());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.switchConfig(in);
        }
    }

    @Override
    public void commit() {
        if (this.server.getGUILoginMode() != 0) {
            JOptionPane.showMessageDialog(this, Internationalization.translate("permissionDenied"), Internationalization.translate("permissionDenied"), -1);
            return;
        }
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendConfig(toSend, this.theConfig);
        this.communicator.send(toSend.toString());
    }

    @Override
    public void commitIndiviualEventSev(ConfigData tmpConfig) {
        if (this.server.getGUILoginMode() != 0) {
            JOptionPane.showMessageDialog(this, Internationalization.translate("permissionDenied"), Internationalization.translate("permissionDenied"), -1);
            return;
        }
        System.out.println("Inside commitIndiviualEventSev");
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendConfig(toSend, tmpConfig);
        this.communicator.send(toSend.toString());
        JOptionPane.showMessageDialog(this, Internationalization.translate("configSent"), Internationalization.translate("configSent"), -1);
    }

    private boolean isInvalidConfiguration(ConfigData tmpConfig) {
        Action emailAction = tmpConfig.getAction("email");
        System.out.println("isInvalidConfiguration");
        boolean isError = false;
        ArrayList serverNamesList = emailAction.getParam("servername");
        String serverNameString = serverNamesList == null || serverNamesList.isEmpty() ? "" : (String)serverNamesList.get(0);
        ArrayList senderAddressList = emailAction.getParam("sender");
        String senderAddressString = senderAddressList == null || senderAddressList.isEmpty() ? "" : (String)senderAddressList.get(0);
        ArrayList userNamesList = emailAction.getParam("username");
        String userNameString = userNamesList == null || userNamesList.isEmpty() ? "" : (String)userNamesList.get(0);
        if (serverNameString == "" || senderAddressString == "" || userNameString == "") {
            isError = true;
        }
        System.out.println("server " + serverNameString);
        System.out.println("sender " + senderAddressString);
        System.out.println("user " + userNameString);
        return isError;
    }

    @Override
    public void testMail() {
        if (this.server.getGUILoginMode() != 0) {
            JOptionPane.showMessageDialog(this, Internationalization.translate("permissionDenied"), Internationalization.translate("permissionDenied"), -1);
            return;
        }
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendTestMail(toSend, this.theConfig);
        String result = this.communicator.send(toSend.toString());
        if (result.indexOf("done") > 0) {
            JOptionPane.showMessageDialog(this, Internationalization.translate("mailSentDesc"), Internationalization.translate("mailSentHeader"), 1);
        } else {
            JOptionPane.showMessageDialog(this, Internationalization.translate("mailErrorDesc"), Internationalization.translate("mailError"), 0);
        }
    }

    private void revert() {
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendRequest(toSend);
        String res = this.communicator.send(toSend.toString());
        StringBufferInputStream in = new StringBufferInputStream(res);
        JOptionPane.showMessageDialog(this, Internationalization.translate("configRead"), Internationalization.translate("configRead"), -1);
        this.switchConfig(in);
    }

    private void switchConfig(InputStream in) {
        parser p = new parser();
        p.parse(in);
        this.theConfig = p.getConfig();
        if (this.theConfig != null) {
            System.out.println("switching");
            this.eventsPanel = new AlertPanel(this.theConfig, this.theStrings, this.parent, this);
            this.mailSeverPanel = new EmailPanel(this.theConfig, this);
            this.testEmailPanel = new EmailDetailPanel(this.theConfig, this);
            if (this.server.getGUILoginMode() != 0) {
                this.testEmailPanel.testButton.setEnabled(false);
            }
            this.tabbedPane.removeAll();
            this.tabbedPane.addTab(Internationalization.translate("Events"), this.eventsPanel);
            this.tabbedPane.addTab(Internationalization.translate("EmailSettings"), this.mailSeverPanel);
            this.tabbedPane.addTab(Internationalization.translate("testEmailPanel"), this.testEmailPanel);
            this.tabbedPane.setMnemonicAt(0, 76);
            this.tabbedPane.setMnemonicAt(1, 77);
        }
    }
}

