/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.gui.AlertPanel;
import configurators.monitorgui.gui.EmailPanel;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainThing;
import configurators.monitorgui.net.Communicator;
import configurators.monitorgui.net.RealCommunicator;
import configurators.monitorgui.xml.AlertStrings;
import configurators.monitorgui.xml.MessageFactory;
import configurators.monitorgui.xml.parser;
import configurators.monitorgui.xml.writer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainPanel
extends JFrame
implements MainThing {
    private ConfigData theConfig;
    private AlertStrings theStrings;
    private MessageFactory messageFactory;
    private Communicator communicator = null;
    private JTabbedPane tabbedPane;
    private AlertPanel eventsPanel;
    private EmailPanel emailPanel;
    private Frame parent;

    public MainPanel(ConfigData c, AlertStrings ts, int port) {
        super(Internationalization.translate("Configuration"));
        this.communicator = new RealCommunicator(port);
        this.getContentPane().setBackground(new Color(124, 148, 196));
        ToolTipManager.sharedInstance().setInitialDelay(100);
        ToolTipManager.sharedInstance().setDismissDelay(1000);
        this.theConfig = c;
        this.theStrings = ts;
        this.messageFactory = new MessageFactory();
        this.getContentPane().setLayout(new BorderLayout());
        JMenuItem loadButton = new JMenuItem(Internationalization.translate("load"));
        JMenuItem saveButton = new JMenuItem(Internationalization.translate("save"));
        JMenuItem commitButton = new JMenuItem(Internationalization.translate("commit"));
        JMenuItem revertButton = new JMenuItem(Internationalization.translate("revert"));
        JMenuItem exitButton = new JMenuItem(Internationalization.translate("exit"));
        JMenuItem aboutButton = new JMenuItem(Internationalization.translate("about"));
        JMenuItem helpButton = new JMenuItem(Internationalization.translate("Help"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.write();
            }
        });
        saveButton.setMnemonic('S');
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.read();
            }
        });
        loadButton.setMnemonic('O');
        commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.commit();
            }
        });
        commitButton.setMnemonic('n');
        revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.revert();
            }
        });
        revertButton.setMnemonic('L');
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        exitButton.setMnemonic('E');
        aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.about();
            }
        });
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.help();
            }
        });
        JMenuBar topMenu = new JMenuBar();
        JMenu topPanel = new JMenu(Internationalization.translate("File"));
        topPanel.setMnemonic('F');
        JMenu helpPanel = new JMenu(Internationalization.translate("Help"));
        topMenu.setBorder(BorderFactory.createEtchedBorder());
        topMenu.add(topPanel);
        topMenu.add(helpPanel);
        topPanel.add(loadButton);
        topPanel.add(saveButton);
        topPanel.addSeparator();
        topPanel.add(commitButton);
        topPanel.add(revertButton);
        topPanel.addSeparator();
        topPanel.add(exitButton);
        helpPanel.add(aboutButton);
        helpPanel.add(helpButton);
        this.setJMenuBar(topMenu);
        this.eventsPanel = new AlertPanel(c, ts, this.parent, this);
        this.emailPanel = new EmailPanel(c, this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Alert Events", this.eventsPanel);
        this.tabbedPane.setMnemonicAt(0, 76);
        this.tabbedPane.addTab(Internationalization.translate("email"), this.emailPanel);
        this.tabbedPane.setMnemonicAt(1, 77);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MainPanel.this.tabbedPane.getSelectedIndex() == 0) {
                    MainPanel.this.eventsPanel.update();
                }
            }
        });
        this.setJMenuBar(topMenu);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        this.setLocation(screenSize.width / 6, screenSize.height / 6);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    private void about() {
        JOptionPane.showMessageDialog(this, Internationalization.translate("aboutMessage"), Internationalization.translate("aboutMessage"), 1);
    }

    private void write() {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File("monitorconfig.xml"));
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            writer w = new writer(chooser.getSelectedFile().getPath());
            w.write(this.theConfig);
        }
    }

    private void read() {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File("monitorconfig.xml"));
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(chooser.getSelectedFile().getPath());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.switchConfig(in);
        }
    }

    @Override
    public void commit() {
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendConfig(toSend, this.theConfig);
        this.communicator.send(toSend.toString());
    }

    @Override
    public void commitIndiviualEventSev(ConfigData tmpConfig) {
    }

    @Override
    public void testMail() {
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendTestMail(toSend, this.theConfig);
        this.communicator.send(toSend.toString());
        JOptionPane.showMessageDialog(this, Internationalization.translate("mailSent"), Internationalization.translate("mailSent"), -1);
    }

    private void help() {
        try {
            String osName = System.getProperty("os.name").toUpperCase();
            if (osName.startsWith("WINDOWS")) {
                Runtime.getRuntime().exec("startmonitorhelp.bat");
            } else {
                Runtime.getRuntime().exec("./startmonitorhelp.sh");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void revert() {
        ByteArrayOutputStream toSend = new ByteArrayOutputStream();
        this.messageFactory.sendRequest(toSend);
        String res = this.communicator.send(toSend.toString());
        StringBufferInputStream in = new StringBufferInputStream(res);
        this.switchConfig(in);
    }

    private void switchConfig(InputStream in) {
        parser p = new parser();
        p.parse(in);
        this.theConfig = p.getConfig();
        if (this.theConfig != null) {
            System.out.println("switching");
            this.eventsPanel = new AlertPanel(this.theConfig, this.theStrings, this.parent, this);
            this.emailPanel = new EmailPanel(this.theConfig, this);
            this.tabbedPane.removeAll();
            this.tabbedPane.addTab(Internationalization.translate("Events"), this.eventsPanel);
            this.tabbedPane.addTab(Internationalization.translate("email"), this.emailPanel);
        }
    }
}

