/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.gui;

import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.data.Global;
import configurators.monitorgui.data.Severity;
import configurators.monitorgui.gui.EditRuleDialog;
import configurators.monitorgui.gui.ExcepPanel;
import configurators.monitorgui.gui.Internationalization;
import configurators.monitorgui.gui.MainDialog;
import configurators.monitorgui.gui.MainThing;
import configurators.monitorgui.xml.AlertStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

class SevPanel
extends JPanel {
    private ConfigData theConfig;
    private AlertStrings theStrings;
    private JTable sevTable;
    private SevModel sevModel;
    private JButton editButton;
    private JButton changeButton;
    private Frame parentFrame;
    private ArrayList theSevs;
    private JPanel editButtonPanel;
    private JPanel tPanel;
    private MainThing mainPanel;
    private ExcepPanel excepPanel;

    Component getTable() {
        return this.sevTable;
    }

    SevPanel(ConfigData c, AlertStrings ts, Container p, MainThing m) {
        this.theConfig = c;
        this.theStrings = ts;
        this.parentFrame = (Frame)p;
        this.mainPanel = m;
        this.excepPanel = new ExcepPanel(this.theConfig, this.theStrings, this.parentFrame, this.mainPanel);
        this.editButton = new JButton(Internationalization.translate("edit") + "...");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SevPanel.this.sevTable.getSelectedRow();
                if (index == -1) {
                    return;
                }
                Severity sev = new Severity((Integer)SevPanel.this.theSevs.get(index));
                Global g = SevPanel.this.theConfig.getGlobal(sev);
                if (g != null) {
                    EditRuleDialog addDialog = new EditRuleDialog(SevPanel.this.parentFrame, SevPanel.this.theConfig, SevPanel.this.theStrings, g);
                    addDialog.setLocationRelativeTo(SevPanel.this);
                    addDialog.setVisible(true);
                    SevPanel.this.update();
                }
            }
        });
        this.editButton.setMnemonic('E');
        this.sevModel = new SevModel();
        this.sevTable = new JTable(this.sevModel);
        this.sevTable.setDefaultRenderer(Object.class, new SevRenderer());
        this.sevTable.getTableHeader().setReorderingAllowed(false);
        this.sevTable.setDragEnabled(false);
        this.sevTable.setSelectionMode(0);
        this.sevTable.setRowSelectionAllowed(true);
        this.sevTable.setShowGrid(true);
        this.sevTable.setRequestFocusEnabled(true);
        this.sevTable.changeSelection(0, 0, false, false);
        this.sevTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SevPanel.this.updateButtons();
            }
        });
        this.tPanel = new JPanel();
        this.tPanel.setLayout(new BorderLayout());
        this.sevTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.tPanel.add((Component)new JScrollPane(this.sevTable, 20, 30), "Center");
        this.add(this.getSevPanel());
        this.updateButtons();
    }

    private JPanel getSevPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 8, 0);
        String infoStr = Internationalization.translate("alertSettingsInfo");
        JLabel infoLabel = new JLabel(infoStr);
        panel.add((Component)infoLabel, gbc);
        gbc.insets = new Insets(2, 2, 5, 0);
        ++gbc.gridy;
        JLabel tableHeader = new JLabel(Internationalization.translate("setDel") + ":");
        tableHeader.setDisplayedMnemonic('A');
        tableHeader.setLabelFor(this.sevTable);
        panel.add((Component)tableHeader, gbc);
        gbc.insets = new Insets(0, 2, 10, 0);
        ++gbc.gridy;
        panel.add((Component)this.tPanel, gbc);
        gbc.insets = new Insets(0, 2, 10, 0);
        ++gbc.gridy;
        panel.add((Component)this.editButton, gbc);
        gbc.insets = new Insets(0, 2, 15, 0);
        ++gbc.gridy;
        panel.add((Component)this.excepPanel.changeIndividualEventButton, gbc);
        return panel;
    }

    void update() {
        this.sevModel.update();
    }

    void updateButtons() {
        if (this.sevTable.getSelectedRow() >= 0) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
    }

    class SevRenderer
    extends DefaultTableCellRenderer {
        SevRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel labelForCell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0 || column == 2) {
                labelForCell.setHorizontalAlignment(0);
            } else {
                labelForCell.setHorizontalAlignment(2);
            }
            if (!MainDialog.isWindows) {
                if (isSelected) {
                    this.setBackground(Color.RED);
                } else {
                    this.setBackground(Color.WHITE);
                }
            }
            return labelForCell;
        }
    }

    class SevModel
    extends AbstractTableModel {
        String[] columName = new String[]{Internationalization.translate("sevLevel"), Internationalization.translate("deliverAlertsby")};

        SevModel() {
            SevPanel.this.theSevs = new ArrayList();
            Enumeration e = SevPanel.this.theConfig.getGlobals();
            while (e.hasMoreElements()) {
                int key = (Integer)e.nextElement();
                SevPanel.this.theSevs.add(new Integer(key));
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.columName[col];
        }

        @Override
        public int getRowCount() {
            return SevPanel.this.theSevs.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int key = (Integer)SevPanel.this.theSevs.get(row);
            if (col == 0) {
                return Internationalization.translate(new Severity(key).getName());
            }
            if (col == 1) {
                Global a = SevPanel.this.theConfig.getGlobal(new Severity(key));
                int count = a.getActionsCount();
                String s = "";
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        s = s + ",";
                    }
                    s = s + Internationalization.translate(a.getAction(i).getName());
                }
                return s;
            }
            return new Integer(1);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        void update() {
            SevPanel.this.theSevs = new ArrayList();
            Enumeration e = SevPanel.this.theConfig.getGlobals();
            while (e.hasMoreElements()) {
                int key = (Integer)e.nextElement();
                SevPanel.this.theSevs.add(new Integer(key));
            }
            this.fireTableDataChanged();
            SevPanel.this.updateButtons();
        }
    }
}

