/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.net;

import configurators.monitorgui.net.NetworkToJavaConverter;
import configurators.monitorgui.net.WWn;

public class NetworkPacket {
    private byte[] theBytes;
    private static final int headersize = 60;
    private static final int senderOffset = 4;
    private static final int receiverOffset = 28;
    private static final int errorOffset = 52;
    private static final int reqLenOffset = 56;
    private static final int reqTypeOffset = 0;

    public NetworkPacket() {
        this.theBytes = new byte[60];
    }

    public NetworkPacket(byte[] b) {
        this.theBytes = b;
    }

    public Object clone() {
        byte[] newBytes = (byte[])this.theBytes.clone();
        return new NetworkPacket(newBytes);
    }

    public void setSender(WWn sender) {
        System.arraycopy(sender.getBytes(), 0, this.theBytes, 4, sender.getSize());
    }

    public void setReceiver(WWn receiver) {
        System.arraycopy(receiver.getBytes(), 0, this.theBytes, 28, receiver.getSize());
    }

    public WWn getSender() {
        byte[] newBytes = new byte[WWn.getSize()];
        System.arraycopy(this.theBytes, 4, newBytes, 0, WWn.getSize());
        return new WWn(newBytes);
    }

    public WWn getReceiver() {
        byte[] newBytes = new byte[WWn.getSize()];
        System.arraycopy(this.theBytes, 28, newBytes, 0, WWn.getSize());
        return new WWn(newBytes);
    }

    public int getError() {
        return NetworkToJavaConverter.byteArrayToInt(this.theBytes, 52);
    }

    public void setError(int e) {
        NetworkToJavaConverter.intToByteArray(e, this.theBytes, 52);
    }

    public int getReqLen() {
        return NetworkToJavaConverter.byteArrayToInt(this.theBytes, 56);
    }

    public void setReqLen(int e) {
        NetworkToJavaConverter.intToByteArray(e, this.theBytes, 56);
    }

    public int getReqType() {
        return NetworkToJavaConverter.byteArrayToInt(this.theBytes, 0);
    }

    public void setReqType(int e) {
        NetworkToJavaConverter.intToByteArray(e, this.theBytes, 0);
    }

    public void addData(byte[] b) {
        int newreqLen = this.getReqLen() + b.length;
        System.out.println("newreqLen");
        System.out.println(newreqLen);
        byte[] newBytes = new byte[60 + newreqLen];
        System.arraycopy(this.theBytes, 0, newBytes, 0, this.theBytes.length);
        System.arraycopy(b, 0, newBytes, this.theBytes.length, b.length);
        System.out.println(this.getReqLen());
        this.theBytes = newBytes;
        this.setReqLen(newreqLen);
    }

    public byte[] getData() {
        byte[] dataBytes = new byte[this.getReqLen()];
        System.arraycopy(this.theBytes, 60, dataBytes, 0, this.getReqLen());
        return dataBytes;
    }

    public byte[] getBytes() {
        return this.theBytes;
    }
}

