/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AlertStrings {
    Hashtable strings = new Hashtable();

    public AlertStrings(InputStream in) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        Document document = null;
        try {
            document = builder.parse(in);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (document != null) {
            int i;
            int count = document.getChildNodes().getLength();
            Node n = null;
            for (i = 0; i < count && !(n = document.getChildNodes().item(i)).getNodeName().equals("alertStringsList"); ++i) {
                n = null;
            }
            if (n != null) {
                count = n.getChildNodes().getLength();
                for (i = 0; i < count; ++i) {
                    Node cn = n.getChildNodes().item(i);
                    this.createString(cn);
                }
            }
        }
    }

    private void createString(Node n) {
        if (!n.getNodeName().equals("alertString")) {
            return;
        }
        boolean has_id = false;
        boolean has_value = false;
        int id = 0;
        String value = "";
        int count = n.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Node cn = n.getChildNodes().item(i);
            if (cn.getNodeName().equals("id")) {
                id = this.parseId(cn);
                has_id = true;
            }
            if (!cn.getNodeName().equals("description")) continue;
            value = this.parseDescription(cn);
            has_value = true;
        }
        if (has_id && has_value) {
            this.strings.put(new Integer(id), value);
        }
    }

    private int parseId(Node n) {
        int count = n.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Node cn = n.getChildNodes().item(i);
            if (cn.getNodeType() != 3) continue;
            return Integer.valueOf(cn.getNodeValue());
        }
        return 0;
    }

    private String parseDescription(Node n) {
        String s = "";
        int count = n.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Node cn = n.getChildNodes().item(i);
            if (cn.getNodeType() != 3) continue;
            s = s + cn.getNodeValue();
        }
        return s;
    }

    public String getString(int id) {
        return (String)this.strings.get(new Integer(id));
    }
}

