/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.xml;

import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.xml.writer;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageFactory {
    DocumentBuilder builder;
    Transformer transformer;

    public MessageFactory() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception E) {
            return;
        }
    }

    public void sendRequest(ByteArrayOutputStream toSend) {
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("monitorcontrol");
        Element child = doc.createElement("config-request");
        doc.appendChild(root);
        root.appendChild(child);
        this.sendDoc(toSend, doc);
    }

    public void sendConfig(ByteArrayOutputStream toSend, ConfigData c) {
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("monitorcontrol");
        doc.appendChild(root);
        writer w = new writer();
        Element confElement = w.createXMLConfig(doc, c);
        root.appendChild(confElement);
        this.sendDoc(toSend, doc);
    }

    public void sendTestMail(ByteArrayOutputStream toSend, ConfigData c) {
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("monitorcontrol");
        doc.appendChild(root);
        Element child = doc.createElement("test-mail");
        root.appendChild(child);
        writer w = new writer();
        Element confElement = w.createXMLConfig(doc, c);
        child.appendChild(confElement);
        this.sendDoc(toSend, doc);
    }

    private void sendDoc(ByteArrayOutputStream toSend, Document doc) {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(toSend);
        try {
            this.transformer.transform(source, result);
        }
        catch (Exception e) {
            return;
        }
    }
}

