/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.xml;

import configurators.monitorgui.data.Action;
import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.data.Global;
import configurators.monitorgui.data.Severity;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class parser {
    private DocumentBuilder builder = null;
    private Document document = null;
    private ConfigData theConfig = null;

    public parser() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public void parse(InputStream in) {
        try {
            this.document = this.builder.parse(in);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (this.document != null) {
            this.treatDocument();
        }
    }

    public ConfigData getConfig() {
        return this.theConfig;
    }

    private void treatDocument() {
        int count = this.document.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Node childNode = this.document.getChildNodes().item(i);
            if (!childNode.getNodeName().equals("monitor-config") || childNode.getNodeType() != 1) continue;
            this.treatConfig(childNode);
        }
    }

    private void treatConfig(Node node) {
        this.theConfig = new ConfigData();
        int count = node.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 1) continue;
            if (childNode.getNodeName().equals("actions")) {
                this.treatActions(childNode);
            }
            if (childNode.getNodeName().equals("global")) {
                this.treatGlobals(childNode);
            }
            if (!childNode.getNodeName().equals("events")) continue;
            this.treatEvents(childNode);
        }
    }

    private void treatActions(Node node) {
        int count = node.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Action a;
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 1 || (a = this.treatAction(childNode)) == null) continue;
            this.theConfig.addAction(a, a.getName());
        }
    }

    private Action treatAction(Node node) {
        String name = node.getNodeName();
        Action a = new Action(name);
        int count = node.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 1) continue;
            this.treatParams(childNode, a);
        }
        return a;
    }

    private void treatParams(Node node, Action a) {
        String name = node.getNodeName();
        ArrayList<String> l = a.getParam(name);
        if (l == null) {
            l = new ArrayList<String>();
            a.setParam(name, l);
        }
        int count = node.getChildNodes().getLength();
        String valueString = null;
        boolean hasValue = false;
        for (int i = 0; i < count; ++i) {
            Node current_node = node.getChildNodes().item(i);
            if (current_node.getNodeType() != 3) continue;
            hasValue = true;
            valueString = current_node.getNodeValue();
        }
        if (hasValue) {
            l.add(valueString);
        } else {
            l.add("");
        }
    }

    private void treatGlobals(Node node) {
        int count = node.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            Global g;
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 1 || (g = this.treatGlobal(childNode)) == null) continue;
            this.theConfig.addGlobal(g, g.getSeverity());
        }
    }

    private Global treatGlobal(Node node) {
        String name;
        Node current_node;
        int count = node.getAttributes().getLength();
        Global g = null;
        for (int i = 0; i < count; ++i) {
            current_node = node.getAttributes().item(i);
            if (current_node.getNodeType() != 2 || !(name = current_node.getNodeName()).equals("level")) continue;
            String level = current_node.getNodeValue();
            Severity s = new Severity(level);
            if (s.getValue() >= 0) {
                g = new Global(s);
                continue;
            }
            return g;
        }
        count = node.getChildNodes().getLength();
        for (int j = 0; j < count; ++j) {
            String subname;
            Action a;
            current_node = node.getChildNodes().item(j);
            if (current_node.getNodeType() != 1 || (a = this.theConfig.getAction(subname = (name = current_node.getNodeName()).substring(3))) == null) continue;
            g.addAction(a);
        }
        return g;
    }

    private void treatEvents(Node node) {
        int count = node.getChildNodes().getLength();
        for (int i = 0; i < count; ++i) {
            AlertEvent e;
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("event") || (e = this.treatEvent(childNode)) == null) continue;
            this.theConfig.addAlertEvent(e);
        }
    }

    private AlertEvent treatEvent(Node node) {
        String name;
        Node current_node;
        int count = node.getAttributes().getLength();
        AlertEvent e = null;
        int Id = -1;
        Severity s = new Severity();
        for (int i = 0; i < count; ++i) {
            String idchar;
            current_node = node.getAttributes().item(i);
            if (current_node.getNodeType() != 2) continue;
            name = current_node.getNodeName();
            if (name.equals("id") && (idchar = current_node.getNodeValue()) != null) {
                Id = Integer.valueOf(idchar);
            }
            if (!name.equals("severity")) continue;
            String level = current_node.getNodeValue();
            s = new Severity(level);
        }
        if (Id < 0 || s.getValue() < 0) {
            return e;
        }
        e = new AlertEvent(Id, s);
        count = node.getChildNodes().getLength();
        for (int j = 0; j < count; ++j) {
            String subname;
            Action a;
            current_node = node.getChildNodes().item(j);
            if (current_node.getNodeType() != 1) continue;
            name = current_node.getNodeName();
            if (name.equals("apply-global")) {
                e.setUseGlobals(true);
            }
            if ((a = this.theConfig.getAction(subname = name.substring(3))) == null) continue;
            e.addAction(a);
        }
        return e;
    }
}

