/*
 * Decompiled with CFR 0.152.
 */
package configurators.monitorgui.xml;

import configurators.monitorgui.data.Action;
import configurators.monitorgui.data.AlertEvent;
import configurators.monitorgui.data.ConfigData;
import configurators.monitorgui.data.Global;
import configurators.monitorgui.data.Severity;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class writer {
    private Document doc;
    private String filename = null;

    public writer() {
    }

    public writer(String name) {
        this.filename = name;
    }

    public Element createXMLConfig(Document d, ConfigData c) {
        this.doc = d;
        if (c == null) {
            System.out.println("no config");
        }
        Element root = this.doc.createElement("monitor-config");
        Element actionsElement = this.getActionsElement(c);
        Element globalsElement = this.getGlobalsElement(c);
        Element eventsElement = this.getEventsElement(c);
        root.appendChild(actionsElement);
        root.appendChild(globalsElement);
        root.appendChild(eventsElement);
        return root;
    }

    public void write(ConfigData c) {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception E) {
            return;
        }
        Element root = this.createXMLConfig(builder.newDocument(), c);
        this.doc.appendChild(root);
        DOMSource source = new DOMSource(this.doc);
        if (this.filename == null) {
            this.filename = "test.xml";
        }
        StreamResult result = new StreamResult(this.filename);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(source, result);
        }
        catch (Exception e) {
            return;
        }
    }

    private Element getActionsElement(ConfigData c) {
        Element e = this.doc.createElement("actions");
        Enumeration theActions = c.getActions();
        while (theActions.hasMoreElements()) {
            String name = (String)theActions.nextElement();
            System.out.println(name);
            Action a = c.getAction(name);
            e.appendChild(this.getActionElement(a));
        }
        return e;
    }

    private Element getActionElement(Action a) {
        Element e = this.doc.createElement(a.getName());
        Enumeration theParams = a.getParams();
        while (theParams.hasMoreElements()) {
            String name = (String)theParams.nextElement();
            ArrayList l = a.getParam(name);
            for (int i = 0; i < l.size(); ++i) {
                Element p = this.doc.createElement(name);
                Text t = this.doc.createTextNode((String)l.get(i));
                p.appendChild(t);
                e.appendChild(p);
            }
        }
        return e;
    }

    private Element getGlobalsElement(ConfigData c) {
        Element e = this.doc.createElement("global");
        Enumeration theGlobals = c.getGlobals();
        while (theGlobals.hasMoreElements()) {
            Severity s = new Severity((Integer)theGlobals.nextElement());
            Global g = c.getGlobal(s);
            e.appendChild(this.getGlobalElement(g));
        }
        return e;
    }

    private Element getGlobalElement(Global g) {
        Element e = this.doc.createElement("severity");
        Attr level = this.doc.createAttribute("level");
        level.setValue(g.getSeverity().getName());
        e.setAttributeNode(level);
        int count = g.getActionsCount();
        for (int i = 0; i < count; ++i) {
            Action a = g.getAction(i);
            Element f = this.doc.createElement("do-" + a.getName());
            e.appendChild(f);
        }
        return e;
    }

    private Element getEventsElement(ConfigData c) {
        Element e = this.doc.createElement("events");
        Enumeration theEvents = c.getAlertEvents();
        while (theEvents.hasMoreElements()) {
            int id = (Integer)theEvents.nextElement();
            AlertEvent ae = c.getAlertEvent(id);
            e.appendChild(this.getEventElement(ae));
        }
        return e;
    }

    private Element getEventElement(AlertEvent ae) {
        Element e = this.doc.createElement("event");
        Attr id = this.doc.createAttribute("id");
        id.setValue(Integer.toString(ae.getId()));
        Attr severity = this.doc.createAttribute("severity");
        severity.setValue(ae.getSeverity().getName());
        e.setAttributeNode(id);
        e.setAttributeNode(severity);
        if (ae.usesGlobal()) {
            Element g = this.doc.createElement("apply-global");
            e.appendChild(g);
        }
        int count = ae.getActionsCount();
        for (int i = 0; i < count; ++i) {
            Action a = ae.getAction(i);
            Element f = this.doc.createElement("do-" + a.getName());
            e.appendChild(f);
        }
        return e;
    }
}

