/*
 * Decompiled with CFR 0.152.
 */
package Framework.AccessControllers;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Services.CommonConstants;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.RoutingManager;
import java.util.Hashtable;

public class AccessControlManager
implements CommonConstants {
    private static String currentFullAccessWWN = null;
    private static int fullAccessClientID;
    private static Hashtable loggedInClients;

    public static void handleClientCall(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        if (networkPacket.getRequestType() == 261) {
            byte[] byArray;
            byte[] byArray2;
            int n = 1;
            int n2 = NetworkToJavaConverter.byteArrayToInt(networkPacket.getDatabuffer());
            if (currentFullAccessWWN == null) {
                currentFullAccessWWN = networkPacket.getSenderWWN();
                fullAccessClientID = n2;
                n = 0;
            } else {
                byArray2 = NetworkPacket.convertWWNStringToByteArray(networkPacket.getSenderWWN());
                byArray = new byte[byArray2.length + 4];
                NetworkToJavaConverter.intToByteArray(fullAccessClientID, byArray);
                System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
                PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket.getReceiverWWN(), currentFullAccessWWN, byArray);
                NetworkPacket networkPacket2 = new NetworkPacket(4097, pluginDataInfo);
                try {
                    RoutingManager.routeCall(networkPacket2);
                }
                catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                    networkPacket2.setFrameworkError(1);
                }
                if (networkPacket2.getFrameworkError() != 0 || NetworkToJavaConverter.byteArrayToInt(networkPacket2.getDatabuffer()) == 0) {
                    currentFullAccessWWN = networkPacket.getSenderWWN();
                    fullAccessClientID = n2;
                    n = 0;
                }
            }
            if (n == 0) {
                AccessControlManager.registerClient(networkPacket.getSenderWWN(), 261);
            }
            byArray2 = NetworkPacket.convertWWNStringToByteArray(currentFullAccessWWN);
            byArray = new byte[byArray2.length + 4];
            NetworkToJavaConverter.intToByteArray(n, byArray);
            System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
            networkPacket.setDatabuffer(byArray);
        } else if (networkPacket.getRequestType() == 266) {
            AccessControlManager.registerClient(networkPacket.getSenderWWN(), 266);
            byte[] byArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, byArray);
            networkPacket.setDatabuffer(byArray);
        } else if (networkPacket.getRequestType() == 267) {
            int n = 1;
            if (AccessControlManager.isClientRegistered(networkPacket.getSenderWWN())) {
                n = 0;
            }
            byte[] byArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(n, byArray);
            networkPacket.setDatabuffer(byArray);
        } else {
            throw new VivaldiFrameworkProtocolErrorException();
        }
    }

    private static void registerClient(String string, int n) {
        loggedInClients.put(string, new Integer(n));
    }

    public static boolean isClientRegistered(String string) {
        return loggedInClients.get(string) != null;
    }

    static {
        loggedInClients = new Hashtable();
    }
}

