/*
 * Decompiled with CFR 0.152.
 */
package Framework.ClientManagers;

import Services.NetworkPacket;
import Services.NetworkToJavaConverter;

public class ClientInfo {
    private int MajorNumber;
    private int MinorNumber;
    private int listenPort;
    private String WWN;
    private String version;
    private String description;
    private static final int CLIENTINFO_LENGTH = 512;

    public ClientInfo() {
    }

    public ClientInfo(byte[] byArray, int n) {
        byte[] byArray2 = new byte[512];
        System.arraycopy(byArray, n, byArray2, 0, 512);
        this.createInfo(byArray2);
    }

    public void setMajorNumber(int n) {
        this.MajorNumber = n;
    }

    public int getMajorNumber() {
        return this.MajorNumber;
    }

    public void setMinorNumber(int n) {
        this.MinorNumber = n;
    }

    public int getMinorNumber() {
        return this.MinorNumber;
    }

    public void setListenPort(int n) {
        this.listenPort = n;
    }

    public void setWWN(String string) {
        this.WWN = string;
    }

    public void setVersion(byte[] byArray, int n, int n2) {
        this.version = new String(byArray, n, n2);
    }

    public void setDescription(byte[] byArray, int n, int n2) {
        this.description = new String(byArray, n, n2);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWWN() {
        return this.WWN;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[512];
        int n = 0;
        NetworkToJavaConverter.intToByteArray(this.MajorNumber, byArray);
        NetworkToJavaConverter.intToByteArray(this.MinorNumber, byArray, n += 4);
        NetworkToJavaConverter.intToByteArray(this.listenPort, byArray, n += 4);
        byte[] byArray2 = NetworkPacket.convertWWNStringToByteArray(this.WWN);
        System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length);
        byte[] byArray3 = this.version.getBytes();
        System.arraycopy(byArray3, 0, byArray, n += byArray2.length, byArray3.length >= 32 ? 32 : byArray3.length);
        byte[] byArray4 = this.description.getBytes();
        System.arraycopy(byArray4, 0, byArray, n += 32, byArray4.length >= 256 ? 256 : byArray4.length);
        return byArray;
    }

    private void createInfo(byte[] byArray) {
        this.setMajorNumber(NetworkToJavaConverter.byteArrayToInt(byArray, 0));
        this.setMinorNumber(NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        this.setListenPort(NetworkToJavaConverter.byteArrayToInt(byArray, 8));
        this.setWWN(NetworkPacket.convertByteArrayToWWNString(byArray, 12));
        this.setVersion(byArray, 36, 32);
        this.setDescription(byArray, 68, 256);
    }
}

