/*
 * Decompiled with CFR 0.152.
 */
package Framework.Network;

import Framework.ClientManagers.ClientManager;
import Framework.Network.CachedSSLSocketFactory;
import Framework.Network.SocketData;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.Network.Worker;
import Framework.PluginManagers.PluginManager;
import Services.CommonConstants;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class NetworkManager {
    private static final int PORT_TO_LISTEN = 3071;
    protected static final int NUM_WORKERS = 10;
    private static String keystore = "vivaldikeys";
    private static char[] keystorepass = "knqwhner".toCharArray();
    private static char[] keypassword = "knqwhner".toCharArray();
    protected static volatile boolean continueListen = true;
    protected static ArrayList reservedWorkers = new ArrayList();
    protected static ArrayList activeWorkers = new ArrayList();
    private static final int SEARCH_PORT_START = 49257;
    private static final int MAX_TRY_LOOP = 800;
    private static boolean isStandAlone = false;

    public static int getAFreePort() {
        int n;
        int n2 = 49257;
        for (n = 0; n <= 800; ++n) {
            try {
                ++n2;
                ServerSocket serverSocket = null;
                if (!isStandAlone) {
                    serverSocket = new ServerSocket(n2);
                } else if (isStandAlone) {
                    serverSocket = new ServerSocket(n2, 0, FrameworkUtilities.getInetAddress());
                }
                serverSocket.close();
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (n > 800) {
            n2 = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object object;
        ServerSocket serverSocket;
        try {
            serverSocket = NetworkManager.getServer();
        }
        catch (Exception exception) {
            System.out.println("Framework: Failed to open server socket exiting......");
            PluginManager.StopPlugins();
            return;
        }
        Object object2 = reservedWorkers;
        synchronized (object2) {
            reservedWorkers.clear();
            for (int i = 0; i < 10; ++i) {
                object = new Worker();
                new Thread((Runnable)object, "worker #" + i).start();
                reservedWorkers.add(object);
            }
        }
        while (continueListen) {
            Object object3;
            Object object4;
            block30: {
                try {
                    Object object5;
                    object2 = (SSLSocket)serverSocket.accept();
                    ((SSLSocket)object2).setWantClientAuth(true);
                    ((SSLSocket)object2).setNeedClientAuth(true);
                    object4 = System.getProperty("user.dir");
                    object = new File((String)object4);
                    object3 = ((File)object).getParent();
                    String string = ".." + File.separator + "StrongSSLEncryption.ini";
                    File file = new File(string);
                    if (file.exists()) {
                        object5 = new Properties();
                        ((Properties)object5).load(new FileInputStream(string));
                        String string2 = "enable";
                        String string3 = ((Properties)object5).getProperty("SSL_STRONG_ENCRYPTION");
                        System.out.println("iniFlag is" + string3);
                        if (string2.equalsIgnoreCase(string3)) {
                            String string4 = "AES.*256";
                            Pattern pattern = Pattern.compile(string4);
                            String[] stringArray = ((SSLSocket)object2).getSupportedCipherSuites();
                            int n = stringArray.length;
                            String[] stringArray2 = new String[n];
                            int n2 = 0;
                            int n3 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                Matcher matcher = pattern.matcher(stringArray[i]);
                                boolean bl = matcher.find();
                                if (bl) {
                                    stringArray2[n2++] = stringArray[i];
                                    continue;
                                }
                                stringArray2[n3--] = stringArray[i];
                            }
                            ((SSLSocket)object2).setEnabledCipherSuites(stringArray2);
                            stringArray = ((SSLSocket)object2).getEnabledCipherSuites();
                            ((SSLSocket)object2).setEnabledCipherSuites(CommonConstants.SSL_STRONG_CIPHERS);
                            System.out.println("Using cipher suite: " + ((SSLSocket)object2).getSession().getCipherSuite());
                            ((SSLSocket)object2).setEnabledProtocols(CommonConstants.SSL_STRONG_PROTOCOLS);
                        }
                    } else {
                        System.out.println(file.getName() + " " + "does not exist!!");
                    }
                    object5 = ((SSLSocket)object2).getSession();
                    if (object5 != null && object5.isValid()) {
                        System.out.println("SSLSession information: " + object5);
                        System.out.println("cipherSuite: " + object5.getCipherSuite() + " Protocol:" + object5.getProtocol());
                        break block30;
                    }
                    System.out.println("sslSession is INVALID.");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Exception while accepting the connection request.");
                    object = exception.getStackTrace();
                    for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                        System.out.println(object[i]);
                    }
                    continue;
                }
            }
            object4 = null;
            object = reservedWorkers;
            synchronized (object) {
                if (reservedWorkers.isEmpty()) {
                    object3 = new Worker();
                    ((Worker)object3).setSocket((Socket)object2);
                    new Thread((Runnable)object3, "additional worker").start();
                } else {
                    object4 = (Worker)reservedWorkers.remove(0);
                    activeWorkers.add(object4);
                    ((Worker)object4).setSocket((Socket)object2);
                }
            }
            if (continueListen) continue;
            PluginManager.StopPlugins();
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = reservedWorkers;
            synchronized (object) {
                int n;
                for (n = 0; n < reservedWorkers.size(); ++n) {
                    object4 = (Worker)reservedWorkers.get(n);
                    try {
                        ((Worker)object4).stopRun();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (n = 0; n < activeWorkers.size(); ++n) {
                    object4 = (Worker)activeWorkers.get(n);
                    ((Worker)object4).closeSocket();
                }
            }
        }
    }

    private static ServerSocket getServer() throws Exception {
        SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        SSLServerSocket sSLServerSocket = null;
        System.out.println("before creating SSL Soket in Framework isStandAlone() :" + NetworkManager.isStandAlone());
        if (NetworkManager.isStandAlone()) {
            InetAddress inetAddress = null;
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress2 = enumeration2.nextElement();
                        System.out.println("netAdr.isLoopbackAddress() :" + inetAddress2.isLoopbackAddress());
                        if (!inetAddress2.isLoopbackAddress() || !(inetAddress2 instanceof Inet4Address)) continue;
                        inetAddress = inetAddress2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(3071, 0, inetAddress);
        } else {
            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(3071);
        }
        return sSLServerSocket;
    }

    public NetworkManager() {
    }

    public NetworkManager(boolean bl) {
        NetworkManager.setStandAlone(bl);
    }

    public static int getPort() {
        return 3071;
    }

    public static void forwardCallToDestination(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        boolean bl;
        int n = 1;
        String string = null;
        int n2 = 0;
        String string2 = "";
        do {
            try {
                bl = false;
                string = networkPacket.getReceiverIPAsString();
                n2 = networkPacket.getReceiverPort();
                string2 = networkPacket.getReceiverWWN();
                if (ClientManager.isStaleClient(string2)) continue;
                SocketData socketData = CachedSSLSocketFactory.createSocket(string, n2);
                DataInputStream dataInputStream = socketData.getInputStream();
                byte[] byArray = networkPacket.getByteArray();
                BufferedOutputStream bufferedOutputStream = socketData.getOutputStream();
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                NetworkPacket networkPacket2 = NetworkManager.readNetworkPacketFromInputStream(dataInputStream);
                networkPacket.setDatabuffer(networkPacket2.getDatabuffer());
                CachedSSLSocketFactory.returnSocket(socketData, string, n2);
            }
            catch (Exception exception) {
                if (--n >= 0) {
                    bl = true;
                    System.out.println("Socket connection to " + string + "failed, try again\n");
                    CachedSSLSocketFactory.removeSocketCache(string, n2);
                    continue;
                }
                System.out.println("NM : forwardCallToDestination() : Socket connection to " + string + ":" + n2 + " failed  on retry");
                System.out.println("NM : forwardCallToDestination() : Unregister " + string2 + " from client's hash");
                ClientManager.handleUnRegisterClient(string2);
                throw new VivaldiFrameworkProtocolErrorException();
            }
        } while (bl);
    }

    public static NetworkPacket readNetworkPacketFromInputStream(DataInputStream dataInputStream) throws IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[60];
        dataInputStream.readFully(byArray2);
        int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 56);
        if (n2 != 0) {
            byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while ((n3 = dataInputStream.read(byArray, n4, n2 - n4)) != 0 && n2 != (n4 += n3)) {
            }
        } else {
            byArray = null;
        }
        NetworkPacket networkPacket = new NetworkPacket(byArray2, byArray);
        return networkPacket;
    }

    public static boolean isStandAlone() {
        return isStandAlone;
    }

    public static void setStandAlone(boolean bl) {
        isStandAlone = bl;
    }
}

