/*
 * Decompiled with CFR 0.152.
 */
package Framework.Network;

import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Services.NetworkPacket;
import Services.RoutingManager;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class Worker
implements Runnable {
    private volatile Socket s;
    private volatile BufferedOutputStream os = null;
    private volatile DataInputStream is = null;

    synchronized void setSocket(Socket socket) {
        this.s = socket;
        this.notify();
    }

    protected void closeSocket() {
        try {
            this.s.close();
            this.is.close();
            this.os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (true) {
            ArrayList arrayList;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (!NetworkManager.continueListen) {
                return;
            }
            try {
                this.handleClient();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!NetworkManager.continueListen) {
                if (this.s != null) {
                    try {
                        this.s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.s = null;
            ArrayList arrayList2 = arrayList = NetworkManager.reservedWorkers;
            synchronized (arrayList2) {
                if (arrayList.size() >= 10) {
                    return;
                }
                NetworkManager.activeWorkers.remove(this);
                arrayList.add(this);
            }
        }
    }

    protected synchronized void stopRun() {
        NetworkManager.continueListen = false;
        this.notify();
    }

    private void handleClient() {
        try {
            while (true) {
                if (this.is == null) {
                    this.is = new DataInputStream(this.s.getInputStream());
                }
                NetworkPacket networkPacket = NetworkManager.readNetworkPacketFromInputStream(this.is);
                switch (networkPacket.getRequestType()) {
                    case 1: {
                        this.stopRun();
                        return;
                    }
                }
                try {
                    RoutingManager.routeCall(networkPacket);
                }
                catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                    networkPacket.setFrameworkError(1);
                }
                byte[] byArray = networkPacket.getByteArray();
                if (this.os == null) {
                    this.os = new BufferedOutputStream(this.s.getOutputStream(), byArray.length);
                }
                this.os.write(byArray);
                this.os.flush();
            }
        }
        catch (Exception exception) {
            try {
                this.is.close();
                this.os.close();
                this.s.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            return;
        }
    }
}

