/*
 * Decompiled with CFR 0.152.
 */
package Framework.PluginManagers;

import Framework.FrameworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginNameFilter;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.PropertiesFileHandler;
import Services.WWNExtractor;
import Services.WWNManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PluginManager {
    private static int pluginCount = 0;
    private static PluginInfo[] listOfPlugins = null;
    private static Hashtable pluginHash = new Hashtable();
    public static String CURRENTLY_USED_IP_ADDR = null;
    private static final String LOOP_BACK_ADDRESS = "127.0.0.1";

    public PluginManager() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void discoverPlugins() {
        int n;
        File file = new File(System.getProperty("user.dir") + File.separator + "plugins");
        String[] stringArray = file.list(new PluginNameFilter());
        ArrayList<PluginInfo> arrayList = new ArrayList<PluginInfo>();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            String string = stringArray[n].substring(0, stringArray[n].indexOf(PluginNameFilter.getJavaClassExn()));
            try {
                PluginInterface pluginInterface = (PluginInterface)Class.forName("plugins." + string).newInstance();
                String string2 = WWNManager.generateWWNfromPluginID(++pluginCount);
                if (!pluginInterface.init(string2, FrameworkManager.getFrameworkManager())) {
                    pluginInterface.preShutdown();
                    pluginInterface.shutdown();
                    continue;
                }
                pluginHash.put(string2, pluginInterface);
                PluginInfo pluginInfo = pluginInterface.getPluginInfo();
                if (!PluginManager.NCPStatus() && pluginInfo.getMajorGroup() == 0 && pluginInfo.getMinorGroup() == 2) {
                    System.out.println("stopping NCP");
                    pluginInterface.preShutdown();
                    pluginInterface.shutdown();
                }
                System.out.println("Loaded Plugin:: " + pluginInfo.getDescription());
                arrayList.add(pluginInfo);
                continue;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() != 0) {
            listOfPlugins = new PluginInfo[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                PluginManager.listOfPlugins[n] = (PluginInfo)arrayList.get(n);
            }
        }
        CURRENTLY_USED_IP_ADDR = FrameworkUtilities.getLocalHostAddress();
    }

    public static boolean isLocalPlugin(String string) {
        return pluginHash.containsKey(string);
    }

    public static void routeCallToPlugin(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        String string = networkPacket.getReceiverWWN();
        try {
            String string2 = PluginManager.updateWWN(string, CURRENTLY_USED_IP_ADDR);
            PluginInterface pluginInterface = (PluginInterface)pluginHash.get(string2);
            PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket);
            pluginInterface.processCommand(pluginDataInfo);
            networkPacket.setDatabuffer(pluginDataInfo.getBuffer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new VivaldiFrameworkProtocolErrorException();
        }
    }

    public static synchronized PluginInfo[] getPlugInList() {
        PluginManager.reAssignWWNToPlugins();
        return listOfPlugins;
    }

    public static synchronized PluginInfo[] getListOfPlugins() {
        return listOfPlugins;
    }

    private void jbInit() throws Exception {
    }

    public static void doStartupOperations() {
        System.out.println("Inside dostartup Operation");
        System.out.println(pluginHash.size());
        Enumeration enumeration = pluginHash.elements();
        while (enumeration.hasMoreElements()) {
            PluginInterface pluginInterface = (PluginInterface)enumeration.nextElement();
            pluginInterface.startupOperations();
        }
    }

    public static void StopPlugins() {
        PluginInterface pluginInterface;
        Enumeration enumeration = pluginHash.elements();
        while (enumeration.hasMoreElements()) {
            pluginInterface = (PluginInterface)enumeration.nextElement();
            pluginInterface.preShutdown();
        }
        enumeration = pluginHash.elements();
        while (enumeration.hasMoreElements()) {
            pluginInterface = (PluginInterface)enumeration.nextElement();
            pluginInterface.shutdown();
        }
    }

    public static PluginInterface getPluginInterface(int n, int n2) {
        PluginInfo pluginInfo = PluginManager.getPluginInfo(n, n2);
        if (pluginInfo != null) {
            PluginInterface pluginInterface = null;
            pluginInterface = (PluginInterface)pluginHash.get(pluginInfo.getWWN());
            if (pluginInterface == null) {
                System.out.println("plugin interface null :" + pluginInfo.getWWN() + ":" + pluginHash);
            }
        }
        return pluginInfo == null ? null : (PluginInterface)pluginHash.get(pluginInfo.getWWN());
    }

    public static PluginInfo getPluginInfo(int n, int n2) {
        for (int i = 0; i < listOfPlugins.length; ++i) {
            if (listOfPlugins[i].getMajorGroup() != n || listOfPlugins[i].getMinorGroup() != n2) continue;
            return listOfPlugins[i];
        }
        return null;
    }

    private static synchronized void reAssignWWNToPlugins() {
        System.out.println("reAssignWWNToPlugins");
        ArrayList<String> arrayList = FrameworkUtilities.getLocalHostAddressList();
        System.out.println("reAssignWWNToPlugins-" + arrayList);
        System.out.println("CURRENTLY_USED_IP_ADDR-" + CURRENTLY_USED_IP_ADDR);
        if (!arrayList.contains(CURRENTLY_USED_IP_ADDR)) {
            FrameworkUtilities.setFoundAddress(false);
            System.out.println("Going to reassign IPAddress for framework");
            for (int i = 0; i < listOfPlugins.length; ++i) {
                PluginInfo pluginInfo = listOfPlugins[i];
                PluginInterface pluginInterface = PluginManager.getPluginInterface(pluginInfo.getMajorGroup(), pluginInfo.getMinorGroup());
                if (PluginManager.NCPStatus() && pluginInfo.getMajorGroup() == 0 && pluginInfo.getMinorGroup() == 2) {
                    try {
                        pluginInterface.preShutdown();
                        pluginInterface.shutdown();
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        System.out.println("UnsatisfiedLinkError e");
                    }
                    catch (Exception exception) {
                        System.out.println("Exception ex");
                    }
                }
                pluginHash.remove(pluginInfo.getWWN());
                WWNExtractor wWNExtractor = new WWNExtractor(pluginInfo.getWWN());
                String string = WWNManager.generateWWNfromPluginID(wWNExtractor.getID());
                pluginInfo.setWWN(string);
                if (PluginManager.NCPStatus() && pluginInfo.getMajorGroup() == 0 && pluginInfo.getMinorGroup() == 2 && !arrayList.equals(LOOP_BACK_ADDRESS)) {
                    try {
                        if (!pluginInterface.init(string, FrameworkManager.getFrameworkManager())) {
                            pluginInterface.preShutdown();
                            pluginInterface.shutdown();
                            continue;
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        System.out.println("UnsatisfiedLinkError e");
                    }
                    catch (Exception exception) {
                        System.out.println("Exception ex");
                    }
                }
                pluginHash.put(string, pluginInterface);
            }
            CURRENTLY_USED_IP_ADDR = FrameworkUtilities.getLocalHostAddress();
        }
    }

    public static boolean stopNwPlugin(boolean bl) {
        System.out.println("inside stopnw =" + bl);
        PluginInfo pluginInfo = PluginManager.getPluginInfo(0, 2);
        System.out.println("inside stopnw1111 =" + bl);
        PluginInterface pluginInterface = PluginManager.getPluginInterface(pluginInfo.getMajorGroup(), pluginInfo.getMinorGroup());
        System.out.println("inside stopnw2222 =" + bl);
        if (bl) {
            System.out.println("inside stopnw shutdown");
            pluginInterface.preShutdown();
            pluginInterface.shutdown();
            System.out.println("inside stopnw ahutdown done");
            PropertiesFileHandler propertiesFileHandler = new PropertiesFileHandler("framework.properties");
            if (propertiesFileHandler != null) {
                System.out.println("inside not stopnw pfh null");
                propertiesFileHandler.setProperty("FRAMEWORK_SERVICE", "0");
                System.out.println(propertiesFileHandler.getProperty("FRAMEWORK_SERVICE"));
            } else {
                System.out.println("inside stopnw pfh null");
            }
            return true;
        }
        System.out.println("inside stopnw else=" + bl);
        try {
            if (!pluginInterface.init(pluginInfo.getWWN(), FrameworkManager.getFrameworkManager())) {
                pluginInterface.preShutdown();
                pluginInterface.shutdown();
                return false;
            }
            PropertiesFileHandler propertiesFileHandler = new PropertiesFileHandler("framework.properties");
            if (propertiesFileHandler != null) {
                propertiesFileHandler.setProperty("FRAMEWORK_SERVICE", "1");
                System.out.println(propertiesFileHandler.getProperty("FRAMEWORK_SERVICE"));
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("UnsatisfiedLinkError e");
            return false;
        }
        catch (Exception exception) {
            System.out.println("Exception ex");
            return false;
        }
    }

    public static boolean NCPStatus() {
        int n = -1;
        String string = null;
        PropertiesFileHandler propertiesFileHandler = new PropertiesFileHandler("framework.properties");
        if (propertiesFileHandler != null) {
            System.out.println(propertiesFileHandler.getProperty("FRAMEWORK_SERVICE"));
            string = propertiesFileHandler.getProperty("FRAMEWORK_SERVICE");
        }
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n == 1;
    }

    private static String updateWWN(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        String[] stringArray = string.split(":");
        string = string2;
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + ":" + stringArray[i];
        }
        return string;
    }
}

