/*
 * Decompiled with CFR 0.152.
 */
package KernelNetwork;

import Framework.Network.NetworkManager;
import KernelExceptions.VKNotRespondingException;
import KernelNetwork.RAIDSocket;
import SASKernel.SASKernel;
import Services.NetworkToJavaConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class KernelNetworkManager
extends Thread {
    private NetworkManager networkManager;
    private RAIDSocket clientConnection = null;
    private SASKernel sasKernel;

    public KernelNetworkManager(SASKernel sASKernel, int n, boolean bl) throws UnknownHostException, IOException {
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("javax.net.ssl.trustStorePassword", "knqwhner");
        System.setProperty("javax.net.ssl.keyStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("javax.net.ssl.keyStorePassword", "knqwhner");
        this.sasKernel = sASKernel;
        this.networkManager = new NetworkManager(sASKernel, bl);
        this.clientConnection = new RAIDSocket(n);
    }

    @Override
    public void run() {
        this.networkManager.startListen();
    }

    public NetworkManager getServerConnectionInstance() {
        return this.networkManager;
    }

    public RAIDSocket getClientConnectionInstance() {
        return this.clientConnection;
    }

    public void closeServerConnection() throws VKNotRespondingException {
        this.networkManager.closeConnection();
    }

    public void shutdown() {
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(1, byArray, 0);
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        Socket socket = null;
        try {
            while (true) {
                socket = socketFactory.createSocket("127.0.0.1", this.networkManager.getPort());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream(), byArray.length);
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
        }
    }

    public void setServerIP(String string) {
        this.clientConnection.setServerIP(string);
    }
}

