/*
 * Decompiled with CFR 0.152.
 */
package KernelNetwork;

import Framework.Network.CachedSSLSocketFactory;
import Framework.Network.SocketData;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.UnknownHostException;

public class RAIDSocket {
    int RAIDSocketport;
    String serverName;
    String serverIP;

    public RAIDSocket(int n) throws UnknownHostException, IOException {
        this.RAIDSocketport = n;
    }

    public int processCommand(byte[] byArray, NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException {
        boolean bl;
        int n = 1;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        do {
            try {
                BufferedOutputStream bufferedOutputStream = null;
                DataInputStream dataInputStream = null;
                SocketData socketData = null;
                bl = false;
                string = NetworkPacket.getReceiverIPAsStringFromHeader(byArray);
                n3 = NetworkPacket.getReceiverPortFromHeader(byArray);
                socketData = CachedSSLSocketFactory.createSocket(this.serverIP, n3);
                bufferedOutputStream = socketData.getOutputStream();
                dataInputStream = socketData.getInputStream();
                if (byArray.length > 0) {
                    bufferedOutputStream.write(byArray, 0, byArray.length);
                }
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 56);
                if (n2 > 0) {
                    bufferedOutputStream.write(byArray2, 0, n2);
                }
                bufferedOutputStream.flush();
                dataInputStream.readFully(byArray);
                int n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 52);
                if (n4 != 0) {
                    throw new VivaldiFrameworkProtocolErrorException(n4);
                }
                n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 56);
                if (n2 > 0) {
                    byArray2 = new byte[n2];
                    int n5 = 0;
                    int n6 = 0;
                    while ((n5 = dataInputStream.read(byArray2, n6, n2 - n6)) != 0 && n2 != (n6 += n5)) {
                    }
                }
                networkDataPacket.setDataBuffer(byArray2);
                CachedSSLSocketFactory.returnSocket(socketData, this.serverIP, n3);
            }
            catch (IOException iOException) {
                if (--n >= 0) {
                    bl = true;
                    System.out.println("Socket connection to " + this.serverIP + " failed once..try again");
                    CachedSSLSocketFactory.removeSocketCache(this.serverIP, this.RAIDSocketport);
                    continue;
                }
                System.out.println("Socket connection to " + this.serverIP + " failed on retry");
                throw iOException;
            }
        } while (bl);
        return n2;
    }

    public int processCommand(byte[] byArray, int n, NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException {
        boolean bl;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        do {
            try {
                BufferedOutputStream bufferedOutputStream = null;
                DataInputStream dataInputStream = null;
                SocketData socketData = null;
                bl = false;
                string = NetworkPacket.getReceiverIPAsStringFromHeader(byArray);
                n3 = NetworkPacket.getReceiverPortFromHeader(byArray);
                socketData = CachedSSLSocketFactory.createSocket(this.serverIP, n3);
                bufferedOutputStream = socketData.getOutputStream();
                dataInputStream = socketData.getInputStream();
                if (byArray.length > 0) {
                    bufferedOutputStream.write(byArray, 0, byArray.length);
                }
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 56);
                if (n2 > 0) {
                    bufferedOutputStream.write(byArray2, 0, n2);
                }
                bufferedOutputStream.flush();
                dataInputStream.readFully(byArray);
                int n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 52);
                if (n4 != 0) {
                    throw new VivaldiFrameworkProtocolErrorException(n4);
                }
                n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 56);
                if (n2 > 0) {
                    byArray2 = new byte[n2];
                    int n5 = 0;
                    int n6 = 0;
                    while ((n5 = dataInputStream.read(byArray2, n6, n2 - n6)) != 0 && n2 != (n6 += n5)) {
                    }
                }
                networkDataPacket.setDataBuffer(byArray2);
                CachedSSLSocketFactory.returnSocket(socketData, this.serverIP, n3);
            }
            catch (IOException iOException) {
                if (--n >= 0) {
                    bl = true;
                    System.out.println("Socket connection to " + this.serverIP + " failed once..try again");
                    CachedSSLSocketFactory.removeSocketCache(this.serverIP, this.RAIDSocketport);
                    continue;
                }
                System.out.println("Socket connection to " + this.serverIP + " failed on retry");
                throw iOException;
            }
        } while (bl);
        return n2;
    }

    public int getPort() {
        return this.RAIDSocketport;
    }

    public void setServerIP(String string) {
        this.serverIP = string;
    }
}

