/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.SpareData;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_LD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.DDFRAIDLevelInfo;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class ArrayData {
    private ArrayList containedIn = null;
    private ArrayList purgedFreeSpaces = new ArrayList();
    private ArrayList newlyCreatedSparesDedicatedToThisArray = new ArrayList();
    private ArrayList oldSparesDedicatedToThisArray = null;
    private SL_ARRAY_INFO_T arrayInfo;
    private ArrayList constituentPDList;
    private boolean isOld;
    private static final long MIN_CONFIGURABLE_ARRAY_SIZE = 2048L;
    private HashMap ldMap = new HashMap();
    private BaseConfigEngine configEngine;
    private DDFRAIDLevelInfo raidLevelInfo = null;
    private byte guiRAIDLevel = 0;
    private byte m_encryptionMethod = 0;

    public ArrayData(SL_ARRAY_INFO_T sL_ARRAY_INFO_T, ArrayList arrayList, boolean bl, BaseConfigEngine baseConfigEngine) {
        this.arrayInfo = sL_ARRAY_INFO_T;
        this.constituentPDList = arrayList;
        this.isOld = bl;
        this.configEngine = baseConfigEngine;
        if (bl) {
            this.findAndSetEncryptionType();
        }
    }

    public void addToArrayList(ArrayList arrayList) {
        this.containedIn = arrayList;
        this.containedIn.add(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canAddLd() {
        if (this.arrayInfo.getfreeCount() <= 0) return false;
        if (this.arrayInfo.getldCount() + this.ldMap.size() >= BaseConfigEngine.MAX_LDS_PER_ARRAY) return false;
        return true;
    }

    int getMaxLDSThatCanBeAddedToThisArray() {
        short s = (short)this.configEngine.getCurrentAdapter().getInformation().getmaxLDsPerArray();
        if (s != 0) {
            return s - this.arrayInfo.getldCount() - this.ldMap.size();
        }
        return 16 - this.arrayInfo.getldCount() - this.ldMap.size();
    }

    public int getRowSize() {
        return this.constituentPDList.size();
    }

    public int getRowSizeFromFW() {
        return this.arrayInfo.getarray().getnumDrives();
    }

    public ArrayList getConstituentPDList() {
        return this.constituentPDList;
    }

    public SL_ARRAY_INFO_T getSLArrayInfoT() {
        return this.arrayInfo;
    }

    protected long minRAID0LDSizeForThisArrayInBlocks() {
        long l = this.getRowSize() * 8192;
        return l > 2048L ? l : 2048L;
    }

    void purgeTooSmallAFreeSpace() {
        boolean bl;
        long l = this.minRAID0LDSizeForThisArrayInBlocks();
        block0: do {
            bl = false;
            for (int i = 0; i < this.arrayInfo.getfreeCount(); ++i) {
                if (this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[i].getnumBlocks() >= l) continue;
                this.purgedFreeSpaces.add(this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[i]);
                this.removeFreeSpace(i);
                bl = true;
                continue block0;
            }
        } while (bl);
    }

    private void removeFreeSpace(int n) {
        for (int i = n; i < this.arrayInfo.getfreeCount(); ++i) {
            this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[i] = this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[i + 1];
        }
        this.arrayInfo.setfreeCount(this.arrayInfo.getfreeCount() - 1);
    }

    public void addLogicalDrive(LDData lDData, int n, long l, int n2, long l2) throws InternalDataStructureCorruptionException {
        freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2 = this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[n];
        long l3 = (long)Math.pow(2.0, n2 - 1) * 2L;
        l = l / (l3 * (long)this.getRowSize()) * ((long)this.getRowSize() * l3);
        if (freeInfo_SL_ARRAY_INFO_T2.getactualNumBlocks() * (long)this.getRowSize() <= l) {
            this.removeFreeSpace(n);
        } else {
            long l4 = l / (long)this.getRowSize();
            freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T3 = new freeInfo_SL_ARRAY_INFO_T(freeInfo_SL_ARRAY_INFO_T2.getstartBlock(), l4);
            freeInfo_SL_ARRAY_INFO_T3.setactualNumBlocks(freeInfo_SL_ARRAY_INFO_T2.getactualNumBlocks());
            freeInfo_SL_ARRAY_INFO_T2.setstartBlock(freeInfo_SL_ARRAY_INFO_T2.getstartBlock() + l4);
            freeInfo_SL_ARRAY_INFO_T2.setnumBlocks(l2 / (long)this.getRowSize());
            freeInfo_SL_ARRAY_INFO_T2.setnumBlocks(freeInfo_SL_ARRAY_INFO_T2.getnumBlocks() - l4);
            freeInfo_SL_ARRAY_INFO_T2 = freeInfo_SL_ARRAY_INFO_T3;
            this.purgeTooSmallAFreeSpace();
        }
        if (this.raidLevelInfo != null && !this.raidLevelInfo.equals(lDData.getRAIDLevelInfo())) {
            throw new InternalDataStructureCorruptionException();
        }
        if (this.raidLevelInfo == null) {
            this.raidLevelInfo = lDData.getRAIDLevelInfo();
        }
        this.ldMap.put(lDData, freeInfo_SL_ARRAY_INFO_T2);
    }

    public void addLogicalDrive(LDData lDData, int n, long l, int n2) throws InternalDataStructureCorruptionException {
        freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2 = this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[n];
        long l2 = (long)Math.pow(2.0, n2 - 1) * 2L;
        l = l / (l2 * (long)this.getRowSize()) * ((long)this.getRowSize() * l2);
        if (freeInfo_SL_ARRAY_INFO_T2.getnumBlocks() * (long)this.getRowSize() <= l) {
            this.removeFreeSpace(n);
        } else {
            long l3 = l / (long)this.getRowSize();
            freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T3 = new freeInfo_SL_ARRAY_INFO_T(freeInfo_SL_ARRAY_INFO_T2.getstartBlock(), l3);
            freeInfo_SL_ARRAY_INFO_T2.setstartBlock(freeInfo_SL_ARRAY_INFO_T2.getstartBlock() + l3);
            freeInfo_SL_ARRAY_INFO_T2.setnumBlocks(freeInfo_SL_ARRAY_INFO_T2.getnumBlocks() - l3);
            this.purgeTooSmallAFreeSpace();
            freeInfo_SL_ARRAY_INFO_T2 = freeInfo_SL_ARRAY_INFO_T3;
        }
        if (this.raidLevelInfo != null && !this.raidLevelInfo.equals(lDData.getRAIDLevelInfo())) {
            throw new InternalDataStructureCorruptionException();
        }
        if (this.raidLevelInfo == null) {
            this.raidLevelInfo = lDData.getRAIDLevelInfo();
        }
        this.ldMap.put(lDData, freeInfo_SL_ARRAY_INFO_T2);
    }

    public void addLogicalDrive(LDData lDData, int n, long l) throws InternalDataStructureCorruptionException {
        char c = lDData.Adapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmax();
        this.addLogicalDrive(lDData, n, l, c);
    }

    freeInfo_SL_ARRAY_INFO_T getFreeSpaceOccupiedByLD(LDData lDData) {
        return (freeInfo_SL_ARRAY_INFO_T)this.ldMap.get(lDData);
    }

    public boolean isAnyLDDefinedOnThisArray() {
        return !this.ldMap.isEmpty();
    }

    public Set getSetOfLDsToBeDeletedIfIDeleteThisArray() {
        return this.ldMap.keySet();
    }

    public void deleteNewArray() throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (this.containedIn == null) {
            throw new InternalDataStructureCorruptionException();
        }
        if (this.isOld) {
            throw new IlligalConfigOperationException();
        }
        ArrayList arrayList = new ArrayList(this.ldMap.keySet());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((LDData)iterator.next()).deleteNewLD();
        }
        this.configEngine.freeArrayRef(this.arrayInfo.getarray().getarrayRef());
        this.containedIn.remove(this);
        this.configEngine.returnDrivesFromDeletedArrays(this.constituentPDList);
        for (int i = 0; i < this.newlyCreatedSparesDedicatedToThisArray.size(); ++i) {
            ((SpareData)this.newlyCreatedSparesDedicatedToThisArray.get(i)).removeArrayFromDedicatedList(this);
        }
    }

    void removeOldArray() throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (this.containedIn == null) {
            throw new InternalDataStructureCorruptionException();
        }
        if (!this.isOld || !this.ldMap.isEmpty()) {
            throw new InternalDataStructureCorruptionException();
        }
        this.containedIn.remove(this);
    }

    public void returnLDSpace(LDData lDData) throws InternalDataStructureCorruptionException {
        freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2 = (freeInfo_SL_ARRAY_INFO_T)this.ldMap.remove(lDData);
        if (freeInfo_SL_ARRAY_INFO_T2 == null) {
            throw new InternalDataStructureCorruptionException();
        }
        this.arrayInfo.addFreeSpace(freeInfo_SL_ARRAY_INFO_T2);
        ListIterator listIterator = this.purgedFreeSpaces.listIterator();
        while (listIterator.hasNext()) {
            this.arrayInfo.addFreeSpace((freeInfo_SL_ARRAY_INFO_T)listIterator.next());
            listIterator.remove();
        }
        this.arrayInfo.sortAndConsolidateFreeSpaces();
        this.purgeTooSmallAFreeSpace();
        if (this.arrayInfo.getldCount() == 0 && this.ldMap.size() == 0) {
            this.raidLevelInfo = null;
        }
    }

    public void addHotSpare(SpareData spareData) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (!this.isPDEligibleForDHSP(spareData.getSASPhysicalDrive())) {
            throw new IlligalConfigOperationException();
        }
        spareData.addArrayAsDedicated(this);
        this.newlyCreatedSparesDedicatedToThisArray.add(spareData);
    }

    public void deleteHotSpare(SpareData spareData) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (!this.newlyCreatedSparesDedicatedToThisArray.remove(spareData)) {
            throw new IlligalConfigOperationException();
        }
        spareData.removeArrayFromDedicatedList(this);
    }

    public void deletePDFromArray(ISASObject iSASObject) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (this.isAnyLDDefinedOnThisArray() || this.isOld) {
            throw new IlligalConfigOperationException();
        }
        if (!this.constituentPDList.remove(iSASObject)) {
            throw new IlligalConfigOperationException();
        }
        this.configEngine.returnDriveFromArray(iSASObject);
        if (this.constituentPDList.size() == 0) {
            this.deleteNewArray();
        } else {
            this.correctSL_ARRAY_INFO_AfterPDRemoval((SASPhysicalDrive)iSASObject);
        }
    }

    private void correctSL_ARRAY_INFO_AfterPDRemoval(SASPhysicalDrive sASPhysicalDrive) throws InternalDataStructureCorruptionException {
        boolean bl = false;
        MR_ARRAY mR_ARRAY = this.arrayInfo.getarray();
        pd_MR_ARRAY[] pd_MR_ARRAYArray = mR_ARRAY.getpd_MR_ARRAY1();
        for (int i = 0; i < mR_ARRAY.getnumDrives(); ++i) {
            if (pd_MR_ARRAYArray[i].getref().getdeviceId() != sASPhysicalDrive.getDeviceId()) continue;
            for (int j = i; j < mR_ARRAY.getnumDrives() - '\u0001'; ++j) {
                pd_MR_ARRAYArray[j] = pd_MR_ARRAYArray[j + 1];
            }
            bl = true;
        }
        if (!bl) {
            throw new InternalDataStructureCorruptionException();
        }
        mR_ARRAY.setnumDrives((char)(mR_ARRAY.getnumDrives() - '\u0001'));
        if (sASPhysicalDrive.getInformation().getcoercedSize() <= mR_ARRAY.getsize()) {
            this.constituentPDList.remove(sASPhysicalDrive);
            long l = ((SASPhysicalDrive)this.constituentPDList.get(0)).getInformation().getcoercedSize();
            for (int i = 1; i < this.constituentPDList.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)this.constituentPDList.get(i);
                l = Math.min(l, sASPhysicalDrive2.getInformation().getcoercedSize());
            }
            mR_ARRAY.setsize(l);
        }
        if (this.arrayInfo.getfreeCount() != 1) {
            throw new InternalDataStructureCorruptionException();
        }
        if (this.arrayInfo.getusedBlocks() != 0L) {
            throw new InternalDataStructureCorruptionException();
        }
        this.arrayInfo.settotalBlocks(mR_ARRAY.getsize() * (long)mR_ARRAY.getnumDrives());
        this.arrayInfo.getfreeInfo_SL_ARRAY_INFO_T()[0].setnumBlocks(this.arrayInfo.gettotalBlocks() / (long)this.arrayInfo.getarray().getnumDrives());
    }

    public ArrayList getHotSparesNewlyDedicatedToThisArray() {
        return this.newlyCreatedSparesDedicatedToThisArray;
    }

    public ArrayList getOldDedicatedSpares() {
        return this.oldSparesDedicatedToThisArray;
    }

    void setOldSparesDedicatedToThisArray(ArrayList arrayList) {
        this.oldSparesDedicatedToThisArray = arrayList;
    }

    public boolean isOld() {
        return this.isOld;
    }

    void setRAIDLevelInfo(DDFRAIDLevelInfo dDFRAIDLevelInfo) throws IlligalConfigOperationException {
        if (!this.isOld) {
            throw new IlligalConfigOperationException();
        }
        this.raidLevelInfo = dDFRAIDLevelInfo;
    }

    public DDFRAIDLevelInfo getRAIDLevelInfo() {
        return this.raidLevelInfo;
    }

    public boolean canSpan(ArrayData arrayData) {
        Object object;
        Object object2;
        if (arrayData.getRowSize() != this.getRowSize()) {
            return false;
        }
        if (this.getLogicalDriveCount() != arrayData.getLogicalDriveCount()) {
            return false;
        }
        if (this.getEncryptionType() != arrayData.getEncryptionType()) {
            return false;
        }
        Iterator iterator = this.ldMap.keySet().iterator();
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        while (iterator.hasNext()) {
            object2 = (LDData)iterator.next();
            if (!arrayData.ldMap.containsKey(object2)) {
                return false;
            }
            object = ((LDData)object2).ld_config.getspan();
            if (!bl) {
                for (int i = 0; i < ((LDData)object2).ld_config.getparams().getspanDepth(); ++i) {
                    if (this.arrayInfo.getarray().getarrayRef() == ((MR_SPAN)object[i]).getarrayRef()) {
                        n = i;
                    }
                    if (arrayData.arrayInfo.getarray().getarrayRef() != ((MR_SPAN)object[i]).getarrayRef()) continue;
                    n2 = i;
                }
                if (n == -1 || n2 == -1) {
                    return false;
                }
                bl = true;
            } else {
                if (object[n].getarrayRef() != this.arrayInfo.getarray().getarrayRef()) {
                    return false;
                }
                if (((MR_SPAN)object[n2]).getarrayRef() != arrayData.arrayInfo.getarray().getarrayRef()) {
                    return false;
                }
            }
            if (((MR_SPAN)object[n]).getstartBlock() != ((MR_SPAN)object[n2]).getstartBlock()) {
                return false;
            }
            if (((MR_SPAN)object[n]).getnumBlocks() == ((MR_SPAN)object[n2]).getnumBlocks()) continue;
            return false;
        }
        if (!this.isOld()) {
            return true;
        }
        bl = false;
        object2 = this.configEngine.actLdObjectList.iterator();
        n = -1;
        n2 = -1;
        while (object2.hasNext()) {
            object = (SASLogicalDrive)object2.next();
            MR_SPAN[] mR_SPANArray = ((SASLogicalDrive)object).getInformation().getldConfig().getspan();
            if (!bl) {
                for (int i = 0; i < ((SASLogicalDrive)object).getInformation().getldConfig().getparams().getspanDepth(); ++i) {
                    if (this.arrayInfo.getarray().getarrayRef() == mR_SPANArray[i].getarrayRef()) {
                        n = i;
                    }
                    if (arrayData.arrayInfo.getarray().getarrayRef() != mR_SPANArray[i].getarrayRef()) continue;
                    n2 = i;
                }
                if (n == -1 && n2 == -1) continue;
                if (n == -1 || n2 == -1) {
                    return false;
                }
                bl = true;
            } else {
                ArrayList arrayList = ((SASLogicalDrive)object).getSASArrayList();
                boolean bl2 = false;
                boolean bl3 = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (((SASArray)arrayList.get(i)).getArrayRef() == this.getSLArrayInfoT().getarray().getarrayRef()) {
                        bl2 = true;
                    }
                    if (((SASArray)arrayList.get(i)).getArrayRef() != arrayData.getSLArrayInfoT().getarray().getarrayRef()) continue;
                    bl3 = true;
                }
                if (!bl2 && !bl3) continue;
                if (mR_SPANArray[n].getarrayRef() != this.arrayInfo.getarray().getarrayRef()) {
                    return false;
                }
                if (mR_SPANArray[n2].getarrayRef() != arrayData.arrayInfo.getarray().getarrayRef()) {
                    return false;
                }
            }
            if (mR_SPANArray[n].getstartBlock() != mR_SPANArray[n2].getstartBlock()) {
                return false;
            }
            if (mR_SPANArray[n].getnumBlocks() == mR_SPANArray[n2].getnumBlocks()) continue;
            return false;
        }
        return true;
    }

    public int getLogicalDriveCount() {
        int n = 0;
        for (SASLogicalDrive sASLogicalDrive : this.configEngine.actLdObjectList) {
            MR_SPAN[] mR_SPANArray = sASLogicalDrive.getInformation().getldConfig().getspan();
            for (int i = 0; i < sASLogicalDrive.getInformation().getldConfig().getparams().getspanDepth(); ++i) {
                if (this.getSLArrayInfoT().getarray().getarrayRef() != mR_SPANArray[i].getarrayRef()) continue;
                ++n;
            }
        }
        return this.ldMap.size() + n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPDEligibleForDHSP(SASPhysicalDrive sASPhysicalDrive) {
        if (this.constituentPDList.size() < 2) {
            return false;
        }
        SASAdapter sASAdapter = this.configEngine.getCurrentAdapter();
        int n = sASAdapter.getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
        int n2 = sASAdapter.getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
        int n3 = sASAdapter.getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
        for (int i = 0; i < this.constituentPDList.size(); ++i) {
            if (((SASPhysicalDrive)this.constituentPDList.get(i)).getInformation().getUserDataBlockSize() != sASPhysicalDrive.getInformation().getUserDataBlockSize()) {
                return false;
            }
            if (!(((SASPhysicalDrive)this.constituentPDList.get(i)).getMediatype() == 0 && sASPhysicalDrive.getMediatype() == 0 ? n2 == 0 && ((SASPhysicalDrive)this.constituentPDList.get(i)).getDriveType() != sASPhysicalDrive.getDriveType() : (((SASPhysicalDrive)this.constituentPDList.get(i)).getMediatype() == 0 && sASPhysicalDrive.getMediatype() == 1 ? n == 0 : (((SASPhysicalDrive)this.constituentPDList.get(i)).getMediatype() == 1 && sASPhysicalDrive.getMediatype() == 0 ? n == 0 : ((SASPhysicalDrive)this.constituentPDList.get(i)).getMediatype() == 1 && sASPhysicalDrive.getMediatype() == 1 && n3 == 0 && ((SASPhysicalDrive)this.constituentPDList.get(i)).getDriveType() != sASPhysicalDrive.getDriveType())))) continue;
            return false;
        }
        if (sASAdapter.getInformation().getAdapterStatus_MR_CTRL_INFO().isLockKeyAssigned()) {
            if (this.m_encryptionMethod == 0) {
                if (this.isFDEOnlyDriveGroup()) {
                    if (!sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) return false;
                    if (!sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured()) {
                        return true;
                    }
                } else if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured()) {
                    return false;
                }
            } else if (this.isFDEOnlyDriveGroup() ? !sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable() : sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured()) {
                return false;
            }
        }
        long l = -1L;
        for (int i = 0; i < this.constituentPDList.size(); ++i) {
            if (this.constituentPDList.get(i) == null) continue;
            l = l < 0L ? ((SASPhysicalDrive)this.constituentPDList.get(i)).getSize() : Math.min(l, ((SASPhysicalDrive)this.constituentPDList.get(i)).getSize());
        }
        if (sASPhysicalDrive.getSize() < l) return false;
        return true;
    }

    public void setGuiRAIDLevel(byte by) {
        this.guiRAIDLevel = by;
    }

    public byte getGUIRAIDLevel() {
        return this.guiRAIDLevel;
    }

    public int getLdMapSize() {
        if (this.ldMap != null) {
            return this.ldMap.size();
        }
        return 0;
    }

    public HashMap getLdMap() {
        return this.ldMap;
    }

    public void setEncryptionType(byte by) {
        this.m_encryptionMethod = by;
    }

    public byte getEncryptionType() {
        return this.m_encryptionMethod;
    }

    private void findAndSetEncryptionType() {
        block0: for (SASLogicalDrive sASLogicalDrive : this.configEngine.actLdObjectList) {
            MR_LD_INFO mR_LD_INFO = sASLogicalDrive.getInformation();
            MR_LD_CONFIG mR_LD_CONFIG = mR_LD_INFO.getldConfig();
            MR_SPAN[] mR_SPANArray = mR_LD_CONFIG.getspan();
            MR_LD_PARAMETERS mR_LD_PARAMETERS = mR_LD_CONFIG.getparams();
            short s = this.getSLArrayInfoT().getarray().getarrayRef();
            int n = mR_LD_PARAMETERS.getspanDepth();
            for (int i = 0; i < n; ++i) {
                if (s != mR_SPANArray[i].getarrayRef()) continue;
                this.m_encryptionMethod = mR_LD_PARAMETERS.getEncryptionType();
                continue block0;
            }
        }
    }

    public int getSpanDepth() {
        Iterator iterator = this.ldMap.keySet().iterator();
        if (iterator.hasNext()) {
            return ((LDData)iterator.next()).getLdConfig().getparams().getspanDepth();
        }
        return 0;
    }

    public boolean isFDEOnlyDriveGroup() {
        for (int n = 0; n < this.constituentPDList.size(); n = (int)((short)(n + 1))) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.constituentPDList.get(n);
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            return false;
        }
        return true;
    }
}

