/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.ConfigurationHelpers.RAIDLevelAndSize;
import SASKernel.ConfigurationHelpers.RAIDParameters;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import java.util.ArrayList;

public class AutoConfigEngine
extends ConfigEngine {
    private int oemType = 0;
    private SASAdapter Adapter;

    public AutoConfigEngine(SASAdapter sASAdapter) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        super(sASAdapter);
        this.Adapter = sASAdapter;
    }

    public boolean isRedundancyPossible() {
        return this.getUnconfiguredPDList().size() > 1;
    }

    public void doAutoConfig(boolean bl, String string, byte by) throws IlligalConfigOperationException, MaxConfigLimitCrossedException, ConfigurationNotAllowedException, InternalDataStructureCorruptionException {
        Object object;
        Object object2;
        int n;
        ArrayList arrayList;
        boolean bl2 = by == 1;
        ArrayList arrayList2 = (ArrayList)this.getUnconfiguredPDList().clone();
        int n2 = 0;
        ArrayList arrayList3 = this.getArraysWithFreeSpaceRemaining();
        int n3 = bl && this.getMaxFWSupportedPRL() == 1 ? 2 : 8;
        ArrayList<SASPhysicalDrive> arrayList4 = new ArrayList<SASPhysicalDrive>(n3);
        int n4 = 0;
        if (!this.newLDCanBeAdded()) {
            throw new ConfigurationNotAllowedException();
        }
        if (bl2) {
            arrayList = new ArrayList();
            ArrayList arrayList5 = (ArrayList)this.getUnconfiguredPDList().clone();
            for (int i = 0; i < arrayList5.size(); ++i) {
                if (!((SASPhysicalDrive)arrayList5.get(i)).getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                arrayList.add(arrayList5.get(i));
            }
            if (arrayList.size() > 0) {
                arrayList5.removeAll(arrayList);
                n4 = (int)Math.ceil((double)arrayList.size() / (double)n3);
            }
            n4 += (int)Math.ceil((double)arrayList5.size() / (double)n3);
        } else {
            if (this.getCurrentAdapter().getInformation().getAdapterStatus_MR_CTRL_INFO().isLockKeyAssigned()) {
                arrayList = new ArrayList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList2.get(i);
                    if (!sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured()) continue;
                    arrayList.add(sASPhysicalDrive);
                }
                if (arrayList.size() > 0 && arrayList.size() < arrayList2.size()) {
                    arrayList2.removeAll(arrayList);
                }
            }
            n4 = (int)Math.ceil((double)arrayList2.size() / (double)n3);
        }
        int n5 = this.getCurrentAdapter().getInformation().getmaxArrays() - this.getNumArrays();
        if (n5 < n4) {
            n4 = n5;
        }
        if ((n = n4 + arrayList3.size()) < this.getMaxLDsperArray() - this.getNumLogicalDrives()) {
            n = this.getMaxLDsperArray() - this.getNumLogicalDrives();
        }
        if (n == 0) {
            throw new InternalDataStructureCorruptionException();
        }
        int n6 = (int)Math.ceil((double)arrayList2.size() / (double)n4);
        int n7 = 0;
        int n8 = 0;
        ArrayList arrayList6 = new ArrayList();
        ArrayList<Object> arrayList7 = new ArrayList<Object>();
        ArrayList arrayList8 = (ArrayList)arrayList2.clone();
        System.out.println("tempFreePDList: " + arrayList8);
        if (bl2) {
            Object object3 = arrayList8.iterator();
            while (object3.hasNext() && n7 < n && n8 < n4) {
                object2 = (SASPhysicalDrive)object3.next();
                if (!((SASPhysicalDevice)object2).getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                arrayList4.add((SASPhysicalDrive)object2);
                arrayList7.add(object2);
                if (++n2 != n6) continue;
                object = this.createNewArray(arrayList4);
                ++n8;
                ArrayHoleData arrayHoleData = new ArrayHoleData((ArrayData)object, 0);
                this.createNewLD(arrayHoleData, bl, string);
                ++n7;
                arrayList4.clear();
                n2 = 0;
            }
            if (arrayList4.size() > 0 && n7 < n && n8 < n4) {
                object3 = this.createNewArray(arrayList4);
                ++n8;
                object2 = new ArrayHoleData((ArrayData)object3, 0);
                this.createNewLD((ArrayHoleData)object2, bl, string);
                ++n7;
                arrayList4.clear();
            }
            this.createNewLD(arrayList3, string);
            arrayList6 = (ArrayList)this.getNewArraysCreated().clone();
            for (int i = 0; i < arrayList6.size(); ++i) {
                object2 = (ArrayData)arrayList6.get(i);
                ((ArrayData)object2).setEncryptionType((byte)1);
            }
            arrayList4.clear();
            n2 = 0;
            arrayList8.removeAll(arrayList7);
            System.out.println("fdeOnlyDG: " + arrayList6);
        }
        Object object4 = arrayList8.iterator();
        while (object4.hasNext() && n7 < n && n8 < n4) {
            arrayList4.add((SASPhysicalDrive)object4.next());
            if (++n2 != n6) continue;
            object2 = this.createNewArray(arrayList4);
            ++n8;
            object = new ArrayHoleData((ArrayData)object2, 0);
            this.createNewLD((ArrayHoleData)object, bl, string);
            ++n7;
            arrayList4.clear();
            n2 = 0;
        }
        if (arrayList4.size() > 0 && n7 < n && n8 < n4) {
            object4 = this.createNewArray(arrayList4);
            ++n8;
            object2 = new ArrayHoleData((ArrayData)object4, 0);
            this.createNewLD((ArrayHoleData)object2, bl, string);
            ++n7;
            arrayList4.clear();
        }
        this.createNewLD(arrayList3, string);
        object4 = (ArrayList)this.getNewArraysCreated().clone();
        if (object4 != null) {
            ((ArrayList)object4).removeAll(arrayList6);
        }
        if (by == 1 && !this.getCurrentAdapter().getInformation().getproperties().getOnOffProperties_MR_CTRL_PROP().getUseFdeOnly()) {
            by = (byte)2;
        }
        if (object4 != null && ((ArrayList)object4).size() > 0) {
            for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                ((ArrayData)((ArrayList)object4).get(i)).setEncryptionType(by);
            }
        }
    }

    private int getMaxLDsperArray() {
        char c = '\u0000';
        c = this.getCurrentAdapter().getInformation().getmaxLDsPerArray();
        if (c != '\u0000') {
            return c;
        }
        return 16;
    }

    private void createNewLD(ArrayHoleData arrayHoleData, boolean bl, String string) throws IlligalConfigOperationException, MaxConfigLimitCrossedException, InternalDataStructureCorruptionException {
        Object object;
        int n;
        ArrayList<ArrayHoleData> arrayList = new ArrayList<ArrayHoleData>(1);
        boolean bl2 = false;
        boolean bl3 = false;
        arrayList.add(arrayHoleData);
        ArrayList arrayList2 = this.getPossibleRAIDLevelAndSize(arrayList);
        int n2 = -1;
        block2: for (n = 0; n < arrayList.size(); ++n) {
            ArrayData arrayData = ((ArrayHoleData)arrayList.get(n)).getArrayData();
            object = arrayData.getConstituentPDList();
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)((ArrayList)object).get(i);
                if (sASPhysicalDrive.getDriveType() == 3) {
                    bl3 = true;
                    continue block2;
                }
                if (sASPhysicalDrive.getDriveType() != 2) continue;
                bl2 = true;
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            if (!bl && ((RAIDLevelAndSize)arrayList2.get(n)).getFWPRL() == 0) {
                n2 = n;
                break;
            }
            if (!bl || ((RAIDLevelAndSize)arrayList2.get(n)).getFWPRL() != 1 && ((RAIDLevelAndSize)arrayList2.get(n)).getFWPRL() != 5) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)arrayList2.get(n2);
        byte by = 0;
        while (this.getOccupiedLDIDList()[by] != 0) {
            by = (byte)(by + 1);
        }
        object = new LDData(arrayList, rAIDLevelAndSize.getGUIRAIDLevel(), rAIDLevelAndSize.getMaxSizeInBlocks(), this, by);
        ((LDData)object).setName(string + by);
        ((LDData)object).setInitState((byte)1);
        RAIDParameters rAIDParameters = RAIDParameters.getDefaultParams(this.getOEM(), this.getmfcDefaults(), this.Adapter, ((LDData)object).getGUIRAIDLavel());
        ((LDData)object).setStripeSize(rAIDParameters.getStripeSize());
        boolean bl4 = false;
        try {
            this.Adapter.getBBUObject();
            bl4 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte by2 = rAIDParameters.getWritePolicy();
        if (rAIDParameters.getWritePolicy() == 1 && bl4) {
            by2 = 16;
        }
        byte by3 = 2;
        if (bl3 && !bl2) {
            by3 = 1;
        }
        by3 = this.adapter.getAdapterType() == 1 ? (byte)0 : (bl3 && !bl2 ? (byte)1 : 2);
        System.out.println("MR_PD_CACHE" + by3);
        ((LDData)object).setPolicy(rAIDParameters.getReadPolicy(), by2, rAIDParameters.getIoPolicy(), (byte)0, by3);
        this.addNewLD((LDData)object);
    }

    private void createNewLD(ArrayList arrayList, String string) throws IlligalConfigOperationException, MaxConfigLimitCrossedException, InternalDataStructureCorruptionException {
        int n;
        ArrayList<Object> arrayList2;
        int n2;
        ArrayList arrayList3;
        if (arrayList.size() < 1) {
            return;
        }
        ArrayList arrayList4 = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList4.add(arrayList.get(i));
        }
        ArrayList<ArrayList> arrayList5 = new ArrayList<ArrayList>();
        for (int i = 0; i < arrayList4.size(); ++i) {
            boolean bl = false;
            ArrayData arrayData = (ArrayData)arrayList4.get(i);
            arrayList3 = new ArrayList();
            for (n2 = 0; n2 < arrayList5.size(); ++n2) {
                if (!((ArrayList)arrayList5.get(n2)).contains(arrayData)) continue;
                bl = true;
            }
            if (bl) continue;
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                ArrayData arrayData2 = (ArrayData)arrayList4.get(n2);
                if (!arrayData.canSpan(arrayData2)) continue;
                arrayList3.add(arrayData2);
            }
            arrayList5.add(arrayList3);
        }
        ArrayList<Object> arrayList6 = new ArrayList<Object>();
        for (int i = 0; i < arrayList5.size(); ++i) {
            arrayList3 = (ArrayList)arrayList5.get(i);
            n2 = ((ArrayData)arrayList3.get(0)).getSLArrayInfoT().getfreeCount();
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                arrayList2 = new ArrayList();
                for (n = 0; n < arrayList3.size(); ++n) {
                    ArrayData arrayData = (ArrayData)arrayList3.get(n);
                    ArrayHoleData arrayHoleData = new ArrayHoleData(arrayData, n3);
                    arrayList2.add(arrayHoleData);
                }
                arrayList6.add(arrayList2);
                ++n3;
            }
        }
        n2 = 0;
        long l = 0L;
        arrayList2 = arrayList6;
        n = 0;
        boolean bl = false;
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (this.getNumLogicalDrives() >= MAX_LOGICAL_DRIVES) break;
            ArrayList arrayList7 = (ArrayList)arrayList2.get(i);
            for (int j = 0; j < arrayList7.size(); ++j) {
                ((ArrayHoleData)arrayList7.get(j)).setFreeIndex(0);
            }
            ArrayList arrayList8 = this.getPossibleRAIDLevelAndSize(arrayList7);
            int n4 = -1;
            byte by = ((ArrayHoleData)arrayList7.get(0)).getArrayData().getGUIRAIDLevel();
            for (int j = 0; j < arrayList8.size(); ++j) {
                if (((RAIDLevelAndSize)arrayList8.get(j)).getGUIRAIDLevel() != by) continue;
                n4 = j;
                break;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)arrayList8.get(n4);
            byte by2 = 0;
            while (this.getOccupiedLDIDList()[by2] != 0) {
                by2 = (byte)(by2 + 1);
            }
            LDData lDData = new LDData(arrayList7, rAIDLevelAndSize.getGUIRAIDLevel(), KernelConstants.getSizeInBlocks(rAIDLevelAndSize.getMaxSizeInBlocks(), 2), this, by2, 7);
            lDData.setName(string + by2);
            lDData.setInitState((byte)1);
            RAIDParameters rAIDParameters = RAIDParameters.getDefaultParams(SASKernel.getOemType(), this.getmfcDefaults(), this.adapter, lDData.getGUIRAIDLavel());
            lDData.setStripeSize(rAIDParameters.getStripeSize());
            lDData.setPolicy(rAIDParameters.getReadPolicy(), rAIDParameters.getWritePolicy(), rAIDParameters.getIoPolicy(), (byte)0, (byte)2);
            this.addNewLD(lDData);
            ++n2;
        }
    }

    public void setOEM(int n) {
        this.oemType = n;
    }

    public int getOEM() {
        return this.oemType;
    }
}

