/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.ConfigurationHelpers.SpareData;
import SASKernel.ConfigurationHelpers.UnsupportedConfigException;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public abstract class BaseConfigEngine {
    protected SASAdapter adapter;
    protected ArrayList actPdObjectList = null;
    protected ArrayList actLdObjectList = null;
    protected ArrayList freePDList = new ArrayList();
    protected ArrayList actArrayObjectList = null;
    protected ArrayList hotSpareList = new ArrayList();
    protected ArrayList oldArrayWithSpaceList = new ArrayList();
    protected ArrayList newArrayCreatedList = new ArrayList();
    protected ArrayList newLDCreatedList = new ArrayList();
    protected byte[] occupiedTargetIDList;
    protected MR_MFC_DEFAULTS mfcDefaults = null;
    protected static final long MIN_LD_SIZE_IN_BLOCKS = 2048L;
    protected static short dummyArrayRefForGUI = 0;
    protected static final int OPTIMUM_DRIVES_PER_ARRAY = 8;
    protected SL_ARRAY_INFO_T array_info = null;
    protected MR_CTRL_INFO ctrlInfo;
    ArrayList oldArrayRefList = new ArrayList();
    Vector emptyArrayRef;
    public static short MAX_LOGICAL_DRIVES;
    public static short MAX_ARRAYS;
    public static short MAX_ROW_SIZE;
    public static short MIN_ROW_SIZE;
    public static short MAX_LDS_PER_ARRAY;

    public BaseConfigEngine(SASAdapter sASAdapter) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        this.adapter = sASAdapter;
        this.ctrlInfo = this.adapter.getInformation();
        try {
            this.actPdObjectList = this.adapter.getSASObjectsArrayList((short)4096);
            this.actArrayObjectList = this.adapter.getSASObjectsArrayList((short)16384);
            this.actLdObjectList = this.adapter.getSASObjectsArrayList((short)8192);
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        this.initConstants();
        this.occupiedTargetIDList = new byte[MAX_LOGICAL_DRIVES];
        try {
            this.mfcDefaults = this.adapter.getMFCDefaults();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            this.mfcDefaults = new MR_MFC_DEFAULTS();
        }
        if (this.actLdObjectList.size() > MAX_LOGICAL_DRIVES) {
            throw new ConfigurationNotAllowedException();
        }
        for (int i = 0; i < this.actPdObjectList.size(); ++i) {
            if (((SASPhysicalDrive)this.actPdObjectList.get(i)).getState() != 0) continue;
            char c = ((SASPhysicalDrive)this.actPdObjectList.get(i)).getInformation().getnotSupported();
            pdType_MR_PD_INFO pdType_MR_PD_INFO2 = ((SASPhysicalDrive)this.actPdObjectList.get(i)).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
            if (pdType_MR_PD_INFO2.getisForeign() == 1 || c != '\u0000') continue;
            this.freePDList.add(this.actPdObjectList.get(i));
        }
        this.refreshArrayRefs();
        dummyArrayRefForGUI = MAX_ARRAYS;
        this.init();
    }

    protected void init() throws ConfigurationNotAllowedException, IlligalConfigOperationException {
    }

    protected int getNumLogicalDrives() {
        return this.actLdObjectList.size() + this.newLDCreatedList.size();
    }

    public int getNumArrays() {
        return this.actArrayObjectList.size() + this.newArrayCreatedList.size();
    }

    public boolean canCreateNewArray() {
        return this.getNumArrays() < MAX_ARRAYS;
    }

    public void freeLDID(int n) throws InternalDataStructureCorruptionException {
        if (this.occupiedTargetIDList[n] != 1) {
            throw new InternalDataStructureCorruptionException();
        }
        this.occupiedTargetIDList[n] = 0;
    }

    public ArrayList getNewlyCreatedLDs() {
        return this.newLDCreatedList;
    }

    protected void returnDrivesFromDeletedArrays(ArrayList arrayList) {
        this.freePDList.addAll(arrayList);
    }

    protected void returnDriveFromArray(ISASObject iSASObject) {
        this.freePDList.add(iSASObject);
    }

    public ArrayList getNewArraysCreated() {
        return this.newArrayCreatedList;
    }

    public ArrayList getOldArraysWithSpace() {
        return this.oldArrayWithSpaceList;
    }

    public ArrayList getUnconfiguredPDList() {
        return this.freePDList;
    }

    public byte[] getOccupiedLDIDList() {
        return this.occupiedTargetIDList;
    }

    public SASAdapter getCurrentAdapter() {
        return this.adapter;
    }

    public void deleteEveryThing() throws InternalDataStructureCorruptionException, IlligalConfigOperationException {
        ArrayList arrayList = new ArrayList(this.newArrayCreatedList);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((ArrayData)arrayList.get(i)).deleteNewArray();
        }
        ArrayList arrayList2 = new ArrayList(this.newLDCreatedList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            ((LDData)arrayList2.get(i)).deleteNewLD();
        }
        dummyArrayRefForGUI = 0;
    }

    public MR_MFC_DEFAULTS getmfcDefaults() {
        return this.mfcDefaults;
    }

    public void addNewLD(LDData lDData) throws IlligalConfigOperationException {
        byte by = (byte)lDData.ld_config.getproperties().getldRef().gettargetId();
        if (this.occupiedTargetIDList[by] != 0) {
            throw new IlligalConfigOperationException();
        }
        this.occupiedTargetIDList[by] = 1;
        lDData.addToList(this.newLDCreatedList);
    }

    public ArrayList getListOfUnusedNewlyCreatedArraysIfIWriteConfigNOW() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.newArrayCreatedList.size(); ++i) {
            if (((ArrayData)this.newArrayCreatedList.get(i)).isAnyLDDefinedOnThisArray()) continue;
            arrayList.add(this.newArrayCreatedList.get(i));
        }
        return arrayList;
    }

    protected void initConstants() {
        MAX_LOGICAL_DRIVES = (short)this.ctrlInfo.getmaxLDs();
        MAX_ROW_SIZE = (short)this.ctrlInfo.getmaxArms();
        if (this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4) {
            MAX_LDS_PER_ARRAY = 1;
            MAX_ARRAYS = (short)2;
            MIN_ROW_SIZE = (short)2;
        } else {
            MAX_LDS_PER_ARRAY = (short)((short)this.ctrlInfo.getmaxLDsPerArray() != 0 ? (int)this.ctrlInfo.getmaxLDsPerArray() : 16);
            MAX_ARRAYS = (short)this.ctrlInfo.getmaxArrays();
            MIN_ROW_SIZE = 1;
        }
    }

    public ArrayList getArraysWithFreeSpaceRemaining() {
        ArrayData arrayData;
        ArrayList<ArrayData> arrayList = new ArrayList<ArrayData>();
        ListIterator listIterator = this.oldArrayWithSpaceList.listIterator();
        while (listIterator.hasNext()) {
            arrayData = (ArrayData)listIterator.next();
            arrayData.purgeTooSmallAFreeSpace();
            if (!arrayData.canAddLd() || arrayData.getRowSize() != arrayData.getRowSizeFromFW()) continue;
            arrayList.add(arrayData);
        }
        listIterator = this.newArrayCreatedList.listIterator();
        while (listIterator.hasNext()) {
            arrayData = (ArrayData)listIterator.next();
            arrayData.purgeTooSmallAFreeSpace();
            if (!arrayData.canAddLd()) continue;
            arrayList.add(arrayData);
        }
        return arrayList;
    }

    public boolean newLDCanBeAdded() {
        if (this.getNumLogicalDrives() >= MAX_LOGICAL_DRIVES) {
            return false;
        }
        if (this.newLDCanBeAddedWithoutCreatingNewArrays()) {
            return true;
        }
        return !this.freePDList.isEmpty() && this.oldArrayWithSpaceList.size() + this.newArrayCreatedList.size() < MAX_ARRAYS;
    }

    public boolean newLDCanBeAddedWithoutCreatingNewArrays() {
        ArrayData arrayData;
        if (this.actLdObjectList.size() + this.newLDCreatedList.size() >= MAX_LOGICAL_DRIVES) {
            return false;
        }
        ListIterator listIterator = this.oldArrayWithSpaceList.listIterator();
        while (listIterator.hasNext()) {
            arrayData = (ArrayData)listIterator.next();
            if (!arrayData.canAddLd() || arrayData.getRowSize() != arrayData.getRowSizeFromFW()) continue;
            return true;
        }
        listIterator = this.newArrayCreatedList.listIterator();
        while (listIterator.hasNext()) {
            arrayData = (ArrayData)listIterator.next();
            if (!arrayData.canAddLd()) continue;
            return true;
        }
        return false;
    }

    protected void refreshArrayRefs() {
        try {
            this.oldArrayRefList = this.adapter.getSASObjectsArrayList((short)16384);
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        this.emptyArrayRef = new Vector();
        boolean bl = false;
        block2: for (short s = 0; s < MAX_ARRAYS; s = (short)(s + 1)) {
            Iterator iterator = this.oldArrayRefList.iterator();
            while (iterator.hasNext()) {
                if (((SASArray)iterator.next()).getArrayRef() != s) continue;
                continue block2;
            }
            this.emptyArrayRef.add(new Short(s));
        }
    }

    protected short allocArrayRef() throws MaxConfigLimitCrossedException {
        if (this.emptyArrayRef.size() == 0) {
            throw new MaxConfigLimitCrossedException();
        }
        return (Short)this.emptyArrayRef.remove(0);
    }

    protected void freeArrayRef(short s) {
        int n;
        for (n = 0; n < this.emptyArrayRef.size() && (Short)this.emptyArrayRef.get(n) <= s; ++n) {
        }
        this.emptyArrayRef.add(n, new Short(s));
    }

    public byte getMaxFWSupportedPRL() {
        if (this.adapter.getInformation().getraidLevels_MR_CTRL_INFO().getraidLevel_6() != 0) {
            return 6;
        }
        if (this.adapter.getInformation().getraidLevels_MR_CTRL_INFO().getraidLevel_5() != 0) {
            return 5;
        }
        if (this.adapter.getInformation().getraidLevels_MR_CTRL_INFO().getraidLevel_1() != 0) {
            return 1;
        }
        return 0;
    }

    public boolean checkForDDFValue(ArrayData arrayData) {
        return arrayData.getSLArrayInfoT().getldCount() + arrayData.getLdMapSize() == 16 && this.getCurrentAdapter().getInformation().getmaxLDsPerArray() == '@' && this.getCurrentAdapter().getInformation().getpartitionsInDDF() == '\u0010';
    }

    public Vector getNonFDEGlobalHotSpares(ArrayList arrayList) {
        Vector<String> vector = new Vector<String>();
        for (SASPhysicalDrive sASPhysicalDrive : arrayList) {
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable() || sASPhysicalDrive.getState() != 2) continue;
            try {
                MR_SPARE[] mR_SPAREArray = ((SASAdapter)sASPhysicalDrive.parent()).readSpareInfo();
                for (int i = 0; i < mR_SPAREArray.length; ++i) {
                    if (mR_SPAREArray[i].getref().getdeviceId() != sASPhysicalDrive.getDeviceId() || mR_SPAREArray[i].getspareType_MR_SPARE1().getisDedicated() != '\u0001') continue;
                    vector.add(this.getPDLabel(sASPhysicalDrive));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public Vector getFDEEncryptedDrives(ArrayList arrayList) {
        Vector<String> vector = new Vector<String>();
        for (SASPhysicalDrive sASPhysicalDrive : arrayList) {
            SASLogicalDrive sASLogicalDrive;
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFdeEnabled()) {
                vector.add(this.getPDLabel(sASPhysicalDrive));
                continue;
            }
            ArrayList arrayList2 = sASPhysicalDrive.getLogicalDriveList();
            if (!arrayList2.iterator().hasNext() || (sASLogicalDrive = (SASLogicalDrive)arrayList2.iterator().next()).getInformation().getldConfig().getparams().getEncryptionType() != 1) continue;
            vector.add(this.getPDLabel(sASPhysicalDrive));
        }
        return vector;
    }

    public boolean isFDECapableDriveGroup(ArrayList arrayList) {
        boolean bl = true;
        for (SASPhysicalDrive sASPhysicalDrive : arrayList) {
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isCfgPossible(ArrayList arrayList) {
        boolean bl = false;
        return bl;
    }

    private String getPDLabel(SASPhysicalDrive sASPhysicalDrive) {
        StringBuffer stringBuffer = new StringBuffer();
        MR_PD_INFO mR_PD_INFO = sASPhysicalDrive.getInformation();
        stringBuffer.append(mR_PD_INFO.getenclDeviceId());
        stringBuffer.append(mR_PD_INFO.getslotNumber());
        stringBuffer.append(this.getDriveTypeDescription(sASPhysicalDrive.getDriveType()));
        stringBuffer.append(KernelConstants.getConvertedSize(mR_PD_INFO.getcoercedSize(), mR_PD_INFO.getUserDataBlockSize()));
        stringBuffer.append(sASPhysicalDrive.getState());
        return stringBuffer.toString();
    }

    private String getDriveTypeDescription(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "SCSI";
                break;
            }
            case 3: {
                string = "SATA";
                break;
            }
            case 2: {
                string = "SAS";
                break;
            }
            case 4: {
                string = "Fibre Channel";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public List getPhysicalDrivesInPowerSaveMode() {
        ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>();
        if (this.newArrayCreatedList != null && this.newArrayCreatedList.size() > 0) {
            for (int i = 0; i < this.newArrayCreatedList.size(); ++i) {
                ArrayData arrayData = (ArrayData)this.newArrayCreatedList.get(i);
                ArrayList arrayList2 = arrayData.getConstituentPDList();
                for (int j = 0; j < arrayList2.size(); ++j) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList2.get(j);
                    if (sASPhysicalDrive.getInformation().getPowerState() != 1 && sASPhysicalDrive.getInformation().getdisabledForRemoval() != '\u0001') continue;
                    arrayList.add(sASPhysicalDrive);
                }
                ArrayList arrayList3 = arrayData.getHotSparesNewlyDedicatedToThisArray();
                if (arrayList3 == null || arrayList3.size() <= 0) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    SASPhysicalDrive sASPhysicalDrive = ((SpareData)arrayList3.get(j)).getSASPhysicalDrive();
                    if (sASPhysicalDrive.getInformation().getPowerState() != 1 && sASPhysicalDrive.getInformation().getdisabledForRemoval() != '\u0001') continue;
                    arrayList.add(sASPhysicalDrive);
                }
            }
        }
        return arrayList;
    }

    public abstract ArrayData createNewArray(ArrayList var1) throws MaxConfigLimitCrossedException, IlligalConfigOperationException, UnsupportedConfigException;

    public abstract ArrayList getPossibleRAIDLevelAndSize(ArrayList var1) throws IlligalConfigOperationException;

    public abstract void writeConfiguration() throws IlligalConfigOperationException, InternalDataStructureCorruptionException, VKNotRespondingException, VKInvalidOperationException, VKOperationFailedException;
}

