/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers.IRConfigHelper;

import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.ConfigurationHelpers.RAIDLevelAndSize;
import SASKernel.ConfigurationHelpers.UnsupportedConfigException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pci_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.raidLevels_MR_CTRL_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;

public class IRConfigEngine
extends BaseConfigEngine {
    private static final int MIN_ROW_SIZE = 2;
    private static final long IR_MAX_LDSIZE_2TB = 0x100000000L;
    private boolean primaryDiskSelected = false;

    public IRConfigEngine(SASAdapter sASAdapter) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        super(sASAdapter);
        dummyArrayRefForGUI = 0;
        OperationDetails operationDetails = new OperationDetails(21, null);
        try {
            this.adapter.fireOperation(operationDetails);
            SL_DRIVE_DISTRIBUTION_T sL_DRIVE_DISTRIBUTION_T = (SL_DRIVE_DISTRIBUTION_T)operationDetails.getParam();
            block2: for (int i = 0; i < sL_DRIVE_DISTRIBUTION_T.getmappedDevicesCount(); ++i) {
                for (int j = this.freePDList.size() - 1; j >= 0; --j) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.freePDList.get(j);
                    if (sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getdriveId() != sASPhysicalDrive.getDeviceId()) continue;
                    SL_PARTITION_INFO_T sL_PARTITION_INFO_T = sASPhysicalDrive.getPartitionInfo(sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getosDriveNumber());
                    for (int k = 0; k < sL_PARTITION_INFO_T.getPartitionCount(); ++k) {
                        if (sL_PARTITION_INFO_T.getPartitionDetails()[k].getBootIndicator() != 1) continue;
                        this.freePDList.remove(j);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void init() throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        if (this.adapter.getAdapterType() != 2 && this.adapter.getAdapterType() != 3 && this.adapter.getAdapterType() != 4) {
            throw new IlligalConfigOperationException();
        }
    }

    @Override
    public ArrayData createNewArray(ArrayList arrayList) throws MaxConfigLimitCrossedException, IlligalConfigOperationException, UnsupportedConfigException {
        Object object;
        int n;
        if (arrayList.size() > MAX_ROW_SIZE) {
            throw new MaxConfigLimitCrossedException();
        }
        if (this.actArrayObjectList.size() + this.newArrayCreatedList.size() >= MAX_ARRAYS) {
            throw new MaxConfigLimitCrossedException();
        }
        if (arrayList.size() < 2) {
            throw new UnsupportedConfigException();
        }
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        pd_MR_ARRAY[] pd_MR_ARRAYArray = arrayList2.listIterator();
        while (pd_MR_ARRAYArray.hasNext()) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)pd_MR_ARRAYArray.next();
            if (this.freePDList.remove(sASPhysicalDrive)) continue;
            throw new IlligalConfigOperationException();
        }
        pd_MR_ARRAYArray = new pd_MR_ARRAY[MAX_ROW_SIZE];
        long l = ((SASPhysicalDrive)arrayList2.get(0)).getInformation().getcoercedSize();
        for (n = 0; n < arrayList2.size(); ++n) {
            object = (SASPhysicalDrive)arrayList2.get(n);
            l = Math.min(l, ((SASPhysicalDevice)object).getInformation().getcoercedSize());
            pd_MR_ARRAY pd_MR_ARRAY2 = new pd_MR_ARRAY((SASPhysicalDevice)object);
            pd_MR_ARRAY2.setfwState((short)24);
            pd_MR_ARRAYArray[n] = pd_MR_ARRAY2;
        }
        for (n = arrayList2.size(); n < MAX_ROW_SIZE; ++n) {
            pd_MR_ARRAYArray[n] = new pd_MR_ARRAY();
        }
        MR_ARRAY mR_ARRAY = new MR_ARRAY(dummyArrayRefForGUI, (char)arrayList2.size(), pd_MR_ARRAYArray, l);
        object = new ArrayData(new SL_ARRAY_INFO_T(mR_ARRAY), (ArrayList)arrayList2.clone(), false, this);
        ((ArrayData)object).addToArrayList(this.newArrayCreatedList);
        this.primaryDiskSelected = false;
        return object;
    }

    @Override
    public ArrayList getPossibleRAIDLevelAndSize(ArrayList arrayList) throws IlligalConfigOperationException {
        long l;
        if (arrayList.size() != 1) {
            throw new IlligalConfigOperationException();
        }
        if (!this.newLDCanBeAdded()) {
            throw new IlligalConfigOperationException();
        }
        MR_ARRAY mR_ARRAY = ((ArrayData)arrayList.get(0)).getSLArrayInfoT().getarray();
        ArrayList<RAIDLevelAndSize> arrayList2 = new ArrayList<RAIDLevelAndSize>();
        raidLevels_MR_CTRL_INFO raidLevels_MR_CTRL_INFO2 = this.adapter.getInformation().getraidLevels_MR_CTRL_INFO();
        if (mR_ARRAY.getnumDrives() < '\u0002') {
            throw new IlligalConfigOperationException();
        }
        if (raidLevels_MR_CTRL_INFO2.getraidLevel_0() != 0 && mR_ARRAY.getnumDrives() >= '\u0002' && mR_ARRAY.getnumDrives() <= BaseConfigEngine.MAX_ROW_SIZE) {
            l = (long)mR_ARRAY.getnumDrives() * mR_ARRAY.getsize();
            l = Math.min(l, 0x100000000L);
            arrayList2.add(new RAIDLevelAndSize(0, l, l));
        }
        if (raidLevels_MR_CTRL_INFO2.getraidLevel_1() != 0 && mR_ARRAY.getnumDrives() == '\u0002') {
            l = mR_ARRAY.getsize();
            l = Math.min(l, 0x100000000L);
            arrayList2.add(new RAIDLevelAndSize(1, l, l));
        }
        if (raidLevels_MR_CTRL_INFO2.getraidLevel_1E() != 0 && mR_ARRAY.getnumDrives() > '\u0002' && mR_ARRAY.getnumDrives() <= BaseConfigEngine.MAX_ROW_SIZE) {
            if (this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4) {
                if (mR_ARRAY.getnumDrives() % 2 != 0) {
                    pci_MR_CTRL_INFO pci_MR_CTRL_INFO2;
                    if (this.adapter.getInformation().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E() && ((pci_MR_CTRL_INFO2 = this.adapter.getInformation().getpci_MR_CTRL_INFO()).getvendorId() != 4096 || pci_MR_CTRL_INFO2.getdevId() != 84 || pci_MR_CTRL_INFO2.getsubVendorId() != 4136 || pci_MR_CTRL_INFO2.getsubDevId() != 7945 && pci_MR_CTRL_INFO2.getsubDevId() != 7944)) {
                        long l2 = mR_ARRAY.getsize() * (long)mR_ARRAY.getnumDrives() / 2L;
                        l2 = Math.min(l2, 0x100000000L);
                        arrayList2.add(new RAIDLevelAndSize(17, l2, l2));
                    }
                } else {
                    pci_MR_CTRL_INFO pci_MR_CTRL_INFO3 = this.adapter.getInformation().getpci_MR_CTRL_INFO();
                    if (pci_MR_CTRL_INFO3.getvendorId() != 4096 || pci_MR_CTRL_INFO3.getdevId() != 84 || pci_MR_CTRL_INFO3.getsubVendorId() != 4136 || pci_MR_CTRL_INFO3.getsubDevId() != 7945 && pci_MR_CTRL_INFO3.getsubDevId() != 7944) {
                        long l3 = mR_ARRAY.getsize() * (long)mR_ARRAY.getnumDrives() / 2L;
                        l3 = Math.min(l3, 0x100000000L);
                        arrayList2.add(new RAIDLevelAndSize(17, l3, l3));
                    }
                }
            } else {
                pci_MR_CTRL_INFO pci_MR_CTRL_INFO4 = this.adapter.getInformation().getpci_MR_CTRL_INFO();
                if (pci_MR_CTRL_INFO4.getvendorId() != 4096 || pci_MR_CTRL_INFO4.getdevId() != 84 || pci_MR_CTRL_INFO4.getsubVendorId() != 4136 || pci_MR_CTRL_INFO4.getsubDevId() != 7945 && pci_MR_CTRL_INFO4.getsubDevId() != 7944) {
                    long l4 = mR_ARRAY.getsize() * (long)mR_ARRAY.getnumDrives() / 2L;
                    l4 = Math.min(l4, 0x100000000L);
                    arrayList2.add(new RAIDLevelAndSize(17, l4, l4));
                }
            }
        }
        return arrayList2;
    }

    @Override
    public void writeConfiguration() throws IlligalConfigOperationException, InternalDataStructureCorruptionException, VKNotRespondingException, VKInvalidOperationException, VKOperationFailedException {
        if (this.newLDCreatedList.size() == 0) {
            throw new IlligalConfigOperationException();
        }
        int n = this.newArrayCreatedList.size();
        if (n == 0) {
            throw new InternalDataStructureCorruptionException();
        }
        MR_CONFIG_DATA mR_CONFIG_DATA = new MR_CONFIG_DATA();
        MR_ARRAY[] mR_ARRAYArray = new MR_ARRAY[this.newArrayCreatedList.size()];
        for (int i = 0; i < this.newArrayCreatedList.size(); ++i) {
            mR_ARRAYArray[i] = ((ArrayData)this.newArrayCreatedList.get(i)).getSLArrayInfoT().getarray();
        }
        MR_LD_CONFIG[] mR_LD_CONFIGArray = new MR_LD_CONFIG[this.newLDCreatedList.size()];
        for (int i = 0; i < this.newLDCreatedList.size(); ++i) {
            mR_LD_CONFIGArray[i] = ((LDData)this.newLDCreatedList.get((int)i)).ld_config;
        }
        mR_CONFIG_DATA.setarray(mR_ARRAYArray);
        mR_CONFIG_DATA.setld(mR_LD_CONFIGArray);
        this.primaryDiskSelected = false;
        this.adapter.fireConfigOperation(new OperationDetails(1, mR_CONFIG_DATA));
    }

    @Override
    public boolean canCreateNewArray() {
        return this.getNumArrays() < MAX_ARRAYS && this.newArrayCreatedList.size() < 1;
    }

    public boolean isPrimaryDiskSelected() {
        if (this.newArrayCreatedList.size() != 1) {
            this.primaryDiskSelected = false;
        }
        return this.primaryDiskSelected;
    }

    public void setPrimaryDisk(short s) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        pd_MR_ARRAY[] pd_MR_ARRAYArray;
        int n;
        if (this.newArrayCreatedList == null || this.newArrayCreatedList.size() == 0) {
            throw new IlligalConfigOperationException();
        }
        ArrayData arrayData = (ArrayData)this.newArrayCreatedList.get(0);
        ArrayList arrayList = arrayData.getConstituentPDList();
        long l = arrayData.getSLArrayInfoT().getarray().getsize();
        for (n = 0; n < arrayList.size(); ++n) {
            pd_MR_ARRAYArray = (pd_MR_ARRAY[])arrayList.get(n);
            if (pd_MR_ARRAYArray.getDeviceId() != s) continue;
            if (pd_MR_ARRAYArray.getInformation().getcoercedSize() > l) {
                throw new ConfigurationNotAllowedException();
            }
            if (n <= 0) break;
            arrayList.remove(pd_MR_ARRAYArray);
            arrayList.add(0, pd_MR_ARRAYArray);
            break;
        }
        if (n >= arrayList.size()) {
            throw new IlligalConfigOperationException();
        }
        pd_MR_ARRAYArray = arrayData.getSLArrayInfoT().getarray().getpd_MR_ARRAY1();
        for (n = 0; n < pd_MR_ARRAYArray.length; ++n) {
            if (pd_MR_ARRAYArray[n].getref().getdeviceId() != s) continue;
            if (n <= 0) break;
            pd_MR_ARRAY pd_MR_ARRAY2 = pd_MR_ARRAYArray[n];
            pd_MR_ARRAYArray[n] = pd_MR_ARRAYArray[0];
            pd_MR_ARRAYArray[0] = pd_MR_ARRAY2;
            break;
        }
        arrayData.getSLArrayInfoT().getarray().setpd_MR_ARRAY1(pd_MR_ARRAYArray);
        this.primaryDiskSelected = true;
    }

    public SASPhysicalDrive getPrimaryDisk() {
        if (!this.primaryDiskSelected) {
            return null;
        }
        return (SASPhysicalDrive)((ArrayData)this.newArrayCreatedList.get(0)).getConstituentPDList().get(0);
    }

    public ArrayList getEligiblePrimaryDisks() {
        ArrayList arrayList = new ArrayList();
        if (this.newArrayCreatedList == null || this.newArrayCreatedList.size() == 0) {
            return arrayList;
        }
        ArrayData arrayData = (ArrayData)this.newArrayCreatedList.get(0);
        ArrayList arrayList2 = arrayData.getConstituentPDList();
        long l = arrayData.getSLArrayInfoT().getarray().getsize();
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (((SASPhysicalDrive)arrayList2.get(i)).getInformation().getcoercedSize() > l) continue;
            arrayList.add(arrayList2.get(i));
        }
        return arrayList;
    }
}

