/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;

public class SpareData {
    private SASPhysicalDrive physicalDrive;
    private ArrayList newArraysToWhichThisPDBelongs = new ArrayList();
    private boolean isNew;
    private ConfigEngine configEngine;
    private ArrayList oldArraysThatAreReferencedByThisHotspare = new ArrayList();
    private MR_SPARE mr_spare;
    private char isEnclAffinity;

    public SpareData(SASPhysicalDrive sASPhysicalDrive, boolean bl, BaseConfigEngine baseConfigEngine) throws IlligalConfigOperationException {
        this(sASPhysicalDrive, bl, baseConfigEngine, '\u0000');
    }

    public SpareData(SASPhysicalDrive sASPhysicalDrive, boolean bl, BaseConfigEngine baseConfigEngine, char c) throws IlligalConfigOperationException {
        this.physicalDrive = sASPhysicalDrive;
        this.isNew = bl;
        this.configEngine = (ConfigEngine)baseConfigEngine;
        this.isEnclAffinity = c;
    }

    public boolean canThisPDBeDedicatedToMoreArrays() {
        if (this.isNew) {
            return this.newArraysToWhichThisPDBelongs.size() < 16;
        }
        try {
            return this.physicalDrive.getDedicatedHotspareInfo().getarrayCount() + this.newArraysToWhichThisPDBelongs.size() < 16;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return false;
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            return false;
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            return false;
        }
    }

    public SASPhysicalDrive getSASPhysicalDrive() {
        return this.physicalDrive;
    }

    protected void addArrayAsDedicated(ArrayData arrayData) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (!this.canThisPDBeDedicatedToMoreArrays()) {
            throw new IlligalConfigOperationException();
        }
        this.newArraysToWhichThisPDBelongs.add(arrayData);
        if (this.isNew && this.newArraysToWhichThisPDBelongs.size() == 1) {
            this.configEngine.addToSpareList(this);
        }
    }

    protected void removeArrayFromDedicatedList(ArrayData arrayData) throws InternalDataStructureCorruptionException {
        if (!this.newArraysToWhichThisPDBelongs.remove(arrayData)) {
            throw new InternalDataStructureCorruptionException();
        }
        if (this.isNew && this.newArraysToWhichThisPDBelongs.size() == 0) {
            this.configEngine.returnSpareAsReady(this);
        }
    }

    protected MR_SPARE buildMR_SPARE() throws VKOperationFailedException, VKNotRespondingException, VKInvalidOperationException, InternalDataStructureCorruptionException {
        this.mr_spare = !this.isNew ? this.physicalDrive.getDedicatedHotspareInfo() : new MR_SPARE(new MR_PD_REF(this.physicalDrive.getDeviceId(), this.physicalDrive.getSeqNum()));
        short[] sArray = this.mr_spare.getarrayRef();
        int n = this.mr_spare.getarrayCount();
        if (this.newArraysToWhichThisPDBelongs.size() == 0) {
            throw new InternalDataStructureCorruptionException();
        }
        for (int i = 0; i < this.newArraysToWhichThisPDBelongs.size(); ++i) {
            sArray[n++] = ((ArrayData)this.newArraysToWhichThisPDBelongs.get(i)).getSLArrayInfoT().getarray().getarrayRef();
        }
        this.mr_spare.setarrayRef(sArray, (byte)this.newArraysToWhichThisPDBelongs.size());
        this.mr_spare.getspareType_MR_SPARE1().setisDedicated('\u0001');
        this.mr_spare.getspareType_MR_SPARE1().setisEnclAffinity(this.mr_spare.getspareType_MR_SPARE1().getisEnclAffinity());
        return this.mr_spare;
    }

    protected void setOldArraysToWhichThisPDBelongs(ISASObject[] iSASObjectArray) throws VKOperationFailedException, VKNotRespondingException, VKInvalidOperationException, InternalDataStructureCorruptionException {
        if (this.isNew) {
            throw new InternalDataStructureCorruptionException();
        }
        MR_SPARE mR_SPARE = this.physicalDrive.getDedicatedHotspareInfo();
        for (int i = 0; i < mR_SPARE.getarrayCount(); ++i) {
            this.oldArraysThatAreReferencedByThisHotspare.add(iSASObjectArray[mR_SPARE.getarrayRef()[i]]);
        }
    }

    protected ArrayList getUnreferencedArrays(byte[] byArray) throws InternalDataStructureCorruptionException {
        ArrayList<MR_ARRAY> arrayList = new ArrayList<MR_ARRAY>(2);
        if (this.newArraysToWhichThisPDBelongs.size() == 0) {
            throw new InternalDataStructureCorruptionException();
        }
        if (this.isNew) {
            return arrayList;
        }
        for (int i = 0; i < this.oldArraysThatAreReferencedByThisHotspare.size(); ++i) {
            if (byArray[((SASArray)this.oldArraysThatAreReferencedByThisHotspare.get(i)).getArrayRef()] == 1) continue;
            byArray[((SASArray)this.oldArraysThatAreReferencedByThisHotspare.get((int)i)).getArrayRef()] = 1;
            arrayList.add(((SASArray)this.oldArraysThatAreReferencedByThisHotspare.get(i)).getInformation());
        }
        return arrayList;
    }

    protected boolean isThisOneNewlyReferencingAnyArray() {
        return this.newArraysToWhichThisPDBelongs.size() > 0;
    }

    public ArrayList arraysToWhichThisSpareIsDedicated() {
        int n;
        ArrayList<Short> arrayList = new ArrayList<Short>();
        for (n = 0; n < this.oldArraysThatAreReferencedByThisHotspare.size(); ++n) {
            arrayList.add(new Short(((SASArray)this.oldArraysThatAreReferencedByThisHotspare.get(n)).getArrayRef()));
        }
        for (n = 0; n < this.newArraysToWhichThisPDBelongs.size(); ++n) {
            arrayList.add(new Short(((ArrayData)this.newArraysToWhichThisPDBelongs.get(n)).getSLArrayInfoT().getarray().getarrayRef()));
        }
        return arrayList;
    }
}

