/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROGRESS;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class MR_LD_INFO {
    private MR_LD_CONFIG ldConfig;
    private long size;
    private MR_LD_PROGRESS progInfo;
    private short clusterOwnerDeviceId;
    private byte reconstructActive;
    private byte snapshotRepository;
    private byte autoSnapshotEnabled;
    private byte peerHasExclusiveAccess;
    private byte powerState = 0;
    private byte[] reserved1 = new byte[2];
    private byte[] logicalVPDPage83 = new byte[64];
    private byte[] reserved2 = new byte[16];
    public static final short MR_LD_INVALID = 255;

    public MR_LD_INFO(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        if (this.ldConfig == null) {
            this.ldConfig = new MR_LD_CONFIG(byArray, n);
        } else {
            this.ldConfig.update(byArray, n);
        }
        this.setsize(NetworkToJavaConverter.byteArrayToLong(byArray, n += 256));
        n += 8;
        if (this.progInfo == null) {
            this.progInfo = new MR_LD_PROGRESS(byArray, n);
        } else {
            this.progInfo.update(byArray, n);
        }
        this.setclusterOwnerDeviceId(NetworkToJavaConverter.byteArrayToShort(byArray, n += 36));
        this.reconstructActive = byArray[n += 2];
        int n2 = 0;
        byte by = byArray[++n];
        this.snapshotRepository = KernelConstants.getBitValue(by, n2);
        this.autoSnapshotEnabled = KernelConstants.getBitValue(by, ++n2);
        this.setPeerHasExclusiveAccess(KernelConstants.getBitValue(by, ++n2));
        ++n;
        for (int i = 0; i < this.logicalVPDPage83.length; ++i) {
            this.logicalVPDPage83[i] = byArray[n + i];
        }
        n += 64;
        this.powerState = byArray[n += 4];
        n += 16;
    }

    public MR_LD_CONFIG getldConfig() {
        return this.ldConfig;
    }

    public long getsize() {
        return this.size;
    }

    public MR_LD_PROGRESS getprogInfo() {
        return this.progInfo;
    }

    public short getclusterOwnerDeviceId() {
        return this.clusterOwnerDeviceId;
    }

    public byte getreconstructActive() {
        return this.reconstructActive;
    }

    public byte getsnapshotRepository() {
        return this.snapshotRepository;
    }

    public byte getautoSnapshotEnabled() {
        return this.autoSnapshotEnabled;
    }

    public byte[] getreserved1() {
        return this.reserved1;
    }

    public byte[] getlogicalVPDPage83() {
        return this.logicalVPDPage83;
    }

    public byte getPowerState() {
        return this.powerState;
    }

    public byte[] getreserved2() {
        return this.reserved2;
    }

    public void setldConfig(MR_LD_CONFIG mR_LD_CONFIG) {
        this.ldConfig = mR_LD_CONFIG;
    }

    public void setsize(long l) {
        this.size = l;
    }

    public void setprogInfo(MR_LD_PROGRESS mR_LD_PROGRESS) {
        this.progInfo = mR_LD_PROGRESS;
    }

    public void setclusterOwnerDeviceId(short s) {
        this.clusterOwnerDeviceId = s;
    }

    public void setreserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setlogicalVPDPage83(byte[] byArray) {
        this.logicalVPDPage83 = byArray;
    }

    public void setPowerState(byte by) {
        this.powerState = by;
    }

    public void setreserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public byte getPeerHasExclusiveAccess() {
        return this.peerHasExclusiveAccess;
    }

    public void setPeerHasExclusiveAccess(byte by) {
        this.peerHasExclusiveAccess = by;
    }
}

