/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.MR_LD_PIT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_ENABLE_PARAMS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_VIEW_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_SNAPSHOT_SCHEDULE_PROPERTIES;
import Services.NetworkToJavaConverter;

public class MR_LD_SNAPSHOT_INFO {
    private int size;
    private MR_LD_SNAPSHOT_ENABLE_PARAMS params;
    private byte numPITs;
    private byte numViews;
    private byte state;
    private byte sourceTargetId;
    private char capacityLeft;
    private MR_LD_PIT_INFO[] ldPitInfo;
    private MR_LD_VIEW_INFO[] viewInfo;
    private MR_SNAPSHOT_SCHEDULE_PROPERTIES schedProp;
    private byte lastSnapSchedMissed;

    public MR_LD_SNAPSHOT_INFO() {
    }

    public MR_LD_SNAPSHOT_INFO(byte[] byArray, int n) {
        int n2;
        this.size = NetworkToJavaConverter.byteArrayToInt(byArray, n);
        n += 4;
        this.params = new MR_LD_SNAPSHOT_ENABLE_PARAMS(byArray, n += 4);
        this.numPITs = byArray[n += 16];
        this.numViews = byArray[++n];
        this.setState(byArray[++n]);
        this.setSourceTargetId(byArray[++n]);
        this.setCapacityLeft((char)NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, ++n));
        n += 2;
        this.lastSnapSchedMissed = byArray[n += 9];
        this.schedProp = new MR_SNAPSHOT_SCHEDULE_PROPERTIES(byArray, ++n);
        n += 8;
        this.ldPitInfo = new MR_LD_PIT_INFO[this.numPITs];
        for (n2 = 0; n2 < this.ldPitInfo.length; ++n2) {
            this.ldPitInfo[n2] = new MR_LD_PIT_INFO(byArray, n);
            n += 88;
        }
        this.viewInfo = new MR_LD_VIEW_INFO[this.numViews];
        for (n2 = 0; n2 < this.viewInfo.length; ++n2) {
            this.viewInfo[n2] = new MR_LD_VIEW_INFO(byArray, n);
            n += 144;
        }
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setParams(MR_LD_SNAPSHOT_ENABLE_PARAMS mR_LD_SNAPSHOT_ENABLE_PARAMS) {
        this.params = mR_LD_SNAPSHOT_ENABLE_PARAMS;
    }

    public void setNumPITs(byte by) {
        this.numPITs = by;
    }

    public void setNumViews(byte by) {
        this.numViews = by;
    }

    public void setState(byte by) {
        this.state = by;
    }

    public void setSourceTargetId(byte by) {
        this.sourceTargetId = by;
    }

    public void setCapacityLeft(char c) {
        this.capacityLeft = c;
    }

    public void setLdPitInfo(MR_LD_PIT_INFO[] mR_LD_PIT_INFOArray) {
        this.size -= this.numPITs * 75;
        this.numPITs = (byte)mR_LD_PIT_INFOArray.length;
        this.ldPitInfo = mR_LD_PIT_INFOArray;
        this.size += this.numPITs * 75;
    }

    public void setViewInfo(MR_LD_VIEW_INFO[] mR_LD_VIEW_INFOArray) {
        this.size -= this.numViews * 136;
        this.numViews = (byte)this.ldPitInfo.length;
        this.viewInfo = mR_LD_VIEW_INFOArray;
        this.size += this.numViews * 136;
    }

    public int getSize() {
        return this.size;
    }

    public MR_LD_SNAPSHOT_ENABLE_PARAMS getParams() {
        return this.params;
    }

    public byte getNumPITs() {
        return this.numPITs;
    }

    public byte getNumViews() {
        return this.numViews;
    }

    public byte getState() {
        return this.state;
    }

    public byte getSourceTargetId() {
        return this.sourceTargetId;
    }

    public char getCapacityLeft() {
        return this.capacityLeft;
    }

    public MR_LD_PIT_INFO[] getLdPitInfo() {
        return this.ldPitInfo;
    }

    public MR_LD_VIEW_INFO[] getViewInfo() {
        return this.viewInfo;
    }

    public MR_SNAPSHOT_SCHEDULE_PROPERTIES getSchedProp() {
        return this.schedProp;
    }

    public void setSchedProp(MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES) {
        this.schedProp = mR_SNAPSHOT_SCHEDULE_PROPERTIES;
    }

    public byte getLastSnapSchedMissed() {
        return this.lastSnapSchedMissed;
    }

    public void setLastSnapSchedMissed(byte by) {
        this.lastSnapSchedMissed = by;
    }
}

