/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import Services.NetworkToJavaConverter;

public class SL_CCOH_CG_STATS_T {
    private char[] cacheGroupName = new char[256];
    private int numVds = 0;
    private int numCdevs = 0;
    private int queueDepth = 0;
    private long totalCacheSize = 0L;
    private long cacheSizeInUse = 0L;
    private long cacheLineSize = 0L;
    private long cacheWindowSize = 0L;
    private long reads = 0L;
    private long writes = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private long hitCount = 0L;
    private long hitTime = 0L;
    private char cachingMode = '\u0000';
    private char[] pad = new char[3];
    private long[] resvd = new long[2];

    public SL_CCOH_CG_STATS_T(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        for (int i = 0; i < 256; ++i) {
            this.cacheGroupName[i] = (char)byArray[n + i];
        }
        this.setNumVds(NetworkToJavaConverter.byteArrayToInt(byArray, n += 256));
        this.setNumCdevs(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.setQueueDepth(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.setTotalCacheSize(NetworkToJavaConverter.byteArrayToLong(byArray, n += 4));
        this.setCacheSizeInUse(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setCacheLineSize(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setCacheWindowSize(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setReads(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setWrites(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setCacheHits(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setCacheMisses(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setHitCount(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setHitTime(NetworkToJavaConverter.byteArrayToLong(byArray, n += 8));
        this.setCachingMode((char)byArray[n += 8]);
        ++n;
    }

    public char[] getCacheGroupName() {
        return this.cacheGroupName;
    }

    public String getCacheGroupNameText() {
        String string = new String(this.cacheGroupName);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setCacheGroupName(char[] cArray) {
        this.cacheGroupName = cArray;
    }

    public int getNumVds() {
        return this.numVds;
    }

    public void setNumVds(int n) {
        this.numVds = n;
    }

    public int getNumCdevs() {
        return this.numCdevs;
    }

    public void setNumCdevs(int n) {
        this.numCdevs = n;
    }

    public int getQueueDepth() {
        return this.queueDepth;
    }

    public void setQueueDepth(int n) {
        this.queueDepth = n;
    }

    public long getTotalCacheSize() {
        return this.totalCacheSize;
    }

    public void setTotalCacheSize(long l) {
        this.totalCacheSize = l;
    }

    public long getCacheSizeInUse() {
        return this.cacheSizeInUse;
    }

    public void setCacheSizeInUse(long l) {
        this.cacheSizeInUse = l;
    }

    public long getCacheLineSize() {
        return this.cacheLineSize;
    }

    public void setCacheLineSize(long l) {
        this.cacheLineSize = l;
    }

    public long getCacheWindowSize() {
        return this.cacheWindowSize;
    }

    public void setCacheWindowSize(long l) {
        this.cacheWindowSize = l;
    }

    public long getReads() {
        return this.reads;
    }

    public void setReads(long l) {
        this.reads = l;
    }

    public long getWrites() {
        return this.writes;
    }

    public void setWrites(long l) {
        this.writes = l;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public void setCacheHits(long l) {
        this.cacheHits = l;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public void setCacheMisses(long l) {
        this.cacheMisses = l;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(long l) {
        this.hitCount = l;
    }

    public long getHitTime() {
        return this.hitTime;
    }

    public void setHitTime(long l) {
        this.hitTime = l;
    }

    public char getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(char c) {
        this.cachingMode = c;
    }

    public char[] getPad() {
        return this.pad;
    }

    public void setPad(char[] cArray) {
        this.pad = cArray;
    }

    public long[] getResvd() {
        return this.resvd;
    }

    public void setResvd(long[] lArray) {
        this.resvd = lArray;
    }
}

