/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_LIST_T;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class SL_CCOH_CONFIG_T {
    private int magicNum = 0;
    private long seqNum = 0L;
    private char capability = '\u0000';
    private char versionNum = '\u0000';
    private char[] cacheGroupName = new char[256];
    private SL_CCOH_DEV_LIST_T cacheDeviceList = null;
    private SL_CCOH_DEV_LIST_T virtualDriveList = null;
    private boolean configActive = false;
    private char pad = '\u0000';
    private long[] resvd = new long[2];

    public SL_CCOH_CONFIG_T() {
    }

    public SL_CCOH_CONFIG_T(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        int n2;
        this.setMagicNum(NetworkToJavaConverter.byteArrayToInt(byArray, n));
        this.setSeqNum(NetworkToJavaConverter.byteArrayToLong(byArray, n += 4));
        this.setCapability((char)byArray[n += 8]);
        this.setVersionNum((char)byArray[++n]);
        ++n;
        for (n2 = 0; n2 < 256; ++n2) {
            this.cacheGroupName[n2] = (char)byArray[n + n2];
        }
        n += 256;
        if (this.cacheDeviceList == null) {
            this.cacheDeviceList = new SL_CCOH_DEV_LIST_T(byArray, n);
        } else {
            this.cacheDeviceList.update(byArray, n);
        }
        n += 213016;
        if (this.virtualDriveList == null) {
            this.virtualDriveList = new SL_CCOH_DEV_LIST_T(byArray, n);
        } else {
            this.virtualDriveList.update(byArray, n);
        }
        n2 = byArray[n += 213016];
        int n3 = 0;
        this.setConfigActive(KernelConstants.getBitValue(n2, n3) == 1);
        ++n3;
        ++n;
    }

    public int getMagicNum() {
        return this.magicNum;
    }

    public void setMagicNum(int n) {
        this.magicNum = n;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(long l) {
        this.seqNum = l;
    }

    public char getCapability() {
        return this.capability;
    }

    public void setCapability(char c) {
        this.capability = c;
    }

    public char getVersionNum() {
        return this.versionNum;
    }

    public void setVersionNum(char c) {
        this.versionNum = c;
    }

    public char[] getCacheGroupName() {
        return this.cacheGroupName;
    }

    public String getCacheGroupNameText() {
        String string = new String(this.cacheGroupName);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setCacheGroupName(char[] cArray) {
        this.cacheGroupName = cArray;
    }

    public SL_CCOH_DEV_LIST_T getCacheDeviceList() {
        return this.cacheDeviceList;
    }

    public void setCacheDeviceList(SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T) {
        this.cacheDeviceList = sL_CCOH_DEV_LIST_T;
    }

    public SL_CCOH_DEV_LIST_T getVirtualDriveList() {
        return this.virtualDriveList;
    }

    public void setVirtualDriveList(SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T) {
        this.virtualDriveList = sL_CCOH_DEV_LIST_T;
    }

    public boolean isConfigActive() {
        return this.configActive;
    }

    public void setConfigActive(boolean bl) {
        this.configActive = bl;
    }

    public char getPad() {
        return this.pad;
    }

    public void setPad(char c) {
        this.pad = c;
    }

    public long[] getResvd() {
        return this.resvd;
    }

    public void setResvd(long[] lArray) {
        this.resvd = lArray;
    }
}

