/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.Constants.SL_CCOH_DEV_CONTENT;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class SL_CCOH_DEV_T {
    private static final String CCOH_DEV_TOPOLOGY_SAN = "SAN";
    private static final String CCOH_DEV_TOPOLOGY_DAS = "Local";
    private static final String CCOH_DEV_TOPOLOGY_UNKNOWN = "Unknown";
    private static final String CCOH_DEV_STATE_ONLINE = "Online";
    private static final String CCOH_DEV_STATE_READY_FOR_ONLINE = "Ready For Online";
    private static final String CCOH_DEV_STATE_OFFLINE = "Offline";
    private char[] devPath = new char[256];
    private char[] devMapperPath = new char[256];
    private char[] devPathOS = new char[64];
    private char[] vendor = new char[64];
    private char[] model = new char[64];
    private char[] devId = new char[96];
    private char devType = '\u0000';
    private char devState = '\u0000';
    private char devTopology = '\u0000';
    private char devConfigState = '\u0000';
    private SL_CCOH_DEV_CONTENT devContent = null;
    private long capacity = 0L;
    private char[] pad = new char[5];
    private long[] resvd = new long[2];

    public SL_CCOH_DEV_T() {
    }

    public SL_CCOH_DEV_T(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < 256; ++n2) {
            this.devPath[n2] = (char)byArray[n + n2];
        }
        n += 256;
        for (n2 = 0; n2 < 256; ++n2) {
            this.devMapperPath[n2] = (char)byArray[n + n2];
        }
        n += 256;
        for (n2 = 0; n2 < 64; ++n2) {
            this.devPathOS[n2] = (char)byArray[n + n2];
        }
        n += 64;
        for (n2 = 0; n2 < 64; ++n2) {
            this.vendor[n2] = (char)byArray[n + n2];
        }
        n += 64;
        for (n2 = 0; n2 < 64; ++n2) {
            this.model[n2] = (char)byArray[n + n2];
        }
        n += 64;
        for (n2 = 0; n2 < 96; ++n2) {
            this.devId[n2] = (char)byArray[n + n2];
        }
        this.setDevType((char)byArray[n += 96]);
        this.setDevState((char)byArray[++n]);
        this.setDevTopology((char)byArray[++n]);
        this.setDevConfigState((char)byArray[++n]);
        ++n;
        if (this.devContent == null) {
            this.devContent = new SL_CCOH_DEV_CONTENT(byArray, n);
        } else {
            this.devContent.update(byArray, n);
        }
        this.setCapacity(NetworkToJavaConverter.byteArrayToLong(byArray, n += 4));
        n += 8;
    }

    public byte[] getByteArray() {
        int n;
        int n2 = 0;
        byte[] byArray = new byte[832];
        for (n = 0; n < 256; ++n) {
            byArray[n2 + n] = (byte)this.devPath[n];
        }
        n2 += 256;
        for (n = 0; n < 256; ++n) {
            byArray[n2 + n] = (byte)this.devMapperPath[n];
        }
        n2 += 256;
        for (n = 0; n < 64; ++n) {
            byArray[n2 + n] = (byte)this.devPathOS[n];
        }
        n2 += 64;
        for (n = 0; n < 64; ++n) {
            byArray[n2 + n] = (byte)this.vendor[n];
        }
        n2 += 64;
        for (n = 0; n < 64; ++n) {
            byArray[n2 + n] = (byte)this.model[n];
        }
        n2 += 64;
        for (n = 0; n < 96; ++n) {
            byArray[n2 + n] = (byte)this.devId[n];
        }
        byArray[n2 += 96] = (byte)this.devType;
        byArray[++n2] = (byte)this.devState;
        byArray[++n2] = (byte)this.devTopology;
        byArray[++n2] = (byte)this.devConfigState;
        NetworkToJavaConverter.intToByteArray(this.devContent.getValueInInt(), byArray, ++n2);
        NetworkToJavaConverter.LongToByteArray(this.capacity, byArray, n2 += 4);
        n2 += 8;
        return byArray;
    }

    public char[] getDevPath() {
        return this.devPath;
    }

    public String getDevPathText() {
        String string = new String(this.devPath);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setDevPath(char[] cArray) {
        this.devPath = cArray;
    }

    public char[] getDevMapperPath() {
        return this.devMapperPath;
    }

    public String getDevMapperPathText() {
        String string = new String(this.devMapperPath);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setDevMapperPath(char[] cArray) {
        this.devMapperPath = cArray;
    }

    public char[] getDevPathOS() {
        return this.devPathOS;
    }

    public String getDevPathOSText() {
        String string = new String(this.devPathOS);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setDevPathOS(char[] cArray) {
        this.devPathOS = cArray;
    }

    public char[] getVendor() {
        return this.vendor;
    }

    public String getVendorText() {
        String string = new String(this.vendor);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setVendor(char[] cArray) {
        this.vendor = cArray;
    }

    public char[] getModel() {
        return this.model;
    }

    public String getModelText() {
        String string = new String(this.model);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setModel(char[] cArray) {
        this.model = cArray;
    }

    public char[] getDevId() {
        return this.devId;
    }

    public String getDevIdText() {
        String string = new String(this.devId);
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public void setDevId(char[] cArray) {
        this.devId = cArray;
    }

    public char getDevType() {
        return this.devType;
    }

    public void setDevType(char c) {
        this.devType = c;
    }

    public char getDevState() {
        return this.devState;
    }

    public String getDevStateText() {
        if (this.devState == '\u0000') {
            return CCOH_DEV_STATE_ONLINE;
        }
        if (this.devState == '\u0002') {
            return CCOH_DEV_STATE_READY_FOR_ONLINE;
        }
        if (this.devState == '\u0001') {
            return CCOH_DEV_STATE_OFFLINE;
        }
        return "";
    }

    public void setDevState(char c) {
        this.devState = c;
    }

    public char getDevTopology() {
        return this.devTopology;
    }

    public String getDevTopologyText() {
        if (this.devTopology == '\u0000') {
            return CCOH_DEV_TOPOLOGY_SAN;
        }
        if (this.devTopology == '\u0001') {
            return CCOH_DEV_TOPOLOGY_DAS;
        }
        if (this.devTopology == '\u00ff') {
            return CCOH_DEV_TOPOLOGY_UNKNOWN;
        }
        return "";
    }

    public void setDevTopology(char c) {
        this.devTopology = c;
    }

    public char getDevConfigState() {
        return this.devConfigState;
    }

    public void setDevConfigState(char c) {
        this.devConfigState = c;
    }

    public boolean isPartOfConfig() {
        return this.devConfigState == '\u0000';
    }

    public SL_CCOH_DEV_CONTENT getDevContent() {
        return this.devContent;
    }

    public void setDevContent(SL_CCOH_DEV_CONTENT sL_CCOH_DEV_CONTENT) {
        this.devContent = sL_CCOH_DEV_CONTENT;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public String getCapacityText() {
        return KernelConstants.getConvertedSize(this.capacity);
    }

    public void setCapacity(long l) {
        this.capacity = l;
    }

    public char[] getPad() {
        return this.pad;
    }

    public void setPad(char[] cArray) {
        this.pad = cArray;
    }

    public long[] getResvd() {
        return this.resvd;
    }

    public void setResvd(long[] lArray) {
        this.resvd = lArray;
    }

    public String getText() {
        if (this.devState == '\u0001') {
            return this.getDevIdText();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDevPathOSText());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDevTopologyText());
        stringBuffer.append(", ");
        stringBuffer.append(this.getCapacityText());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDevStateText());
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getText();
    }
}

