/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.MR_ENCL_INFO;
import SASKernel.LibraryAPI.StoreLib.SL_ALARM_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_FAN_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_POWER_SUPPLY_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_SIM_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_SLOT_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_TEMP_SENSOR_STATUS_T;
import Services.NetworkToJavaConverter;

public class SL_ENCL_STATUS_T {
    private int size;
    private int slotCount;
    private int psCount;
    private int fanCount;
    private int tsCount;
    private int alarmCount;
    private int simCount;
    private SL_SLOT_STATUS_T[] slotStatus;
    private SL_POWER_SUPPLY_STATUS_T[] psStatus;
    private SL_FAN_STATUS_T[] fanStatus;
    private SL_TEMP_SENSOR_STATUS_T[] tsStatus;
    private SL_ALARM_STATUS_T[] alarmStatus;
    private SL_SIM_STATUS_T[] simStatus;
    private MR_ENCL_INFO enclInfo;

    public SL_ENCL_STATUS_T(byte[] byArray, int n, MR_ENCL_INFO mR_ENCL_INFO) {
        this.update(byArray, n, mR_ENCL_INFO);
    }

    public void update(byte[] byArray, int n, MR_ENCL_INFO mR_ENCL_INFO) {
        int n2;
        this.setsize(NetworkToJavaConverter.byteArrayToInt(byArray, n));
        this.setslotCount(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.setpsCount(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.setfanCount(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.settsCount(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.setalarmCount(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        this.setsimCount(NetworkToJavaConverter.byteArrayToInt(byArray, n += 4));
        n += 4;
        this.slotStatus = new SL_SLOT_STATUS_T[this.getslotCount()];
        for (n2 = 0; n2 < this.slotStatus.length; ++n2) {
            this.slotStatus[n2] = new SL_SLOT_STATUS_T(byArray, n);
            n += 8;
        }
        this.psStatus = new SL_POWER_SUPPLY_STATUS_T[this.getpsCount()];
        for (n2 = 0; n2 < this.psStatus.length; ++n2) {
            this.psStatus[n2] = new SL_POWER_SUPPLY_STATUS_T(byArray, n);
            n += 8;
        }
        this.fanStatus = new SL_FAN_STATUS_T[this.getfanCount()];
        for (n2 = 0; n2 < this.fanStatus.length; ++n2) {
            this.fanStatus[n2] = new SL_FAN_STATUS_T(byArray, n);
            n += 8;
        }
        this.tsStatus = new SL_TEMP_SENSOR_STATUS_T[this.gettsCount()];
        for (n2 = 0; n2 < this.tsStatus.length; ++n2) {
            this.tsStatus[n2] = new SL_TEMP_SENSOR_STATUS_T(byArray, n);
            n += 8;
        }
        this.alarmStatus = new SL_ALARM_STATUS_T[this.getalarmCount()];
        for (n2 = 0; n2 < this.alarmStatus.length; ++n2) {
            this.alarmStatus[n2] = new SL_ALARM_STATUS_T(byArray, n);
            n += 8;
        }
        this.simStatus = new SL_SIM_STATUS_T[this.getsimCount()];
        for (n2 = 0; n2 < this.simStatus.length; ++n2) {
            this.simStatus[n2] = new SL_SIM_STATUS_T(byArray, n);
            n += 8;
        }
        this.enclInfo = mR_ENCL_INFO;
    }

    public int getsize() {
        return this.size;
    }

    public int getslotCount() {
        return this.slotCount;
    }

    public int getpsCount() {
        return this.psCount;
    }

    public int getfanCount() {
        return this.fanCount;
    }

    public int gettsCount() {
        return this.tsCount;
    }

    public int getalarmCount() {
        return this.alarmCount;
    }

    public int getsimCount() {
        return this.simCount;
    }

    public SL_SLOT_STATUS_T[] getslotStatus() {
        return this.slotStatus;
    }

    public SL_POWER_SUPPLY_STATUS_T[] getpsStatus() {
        return this.psStatus;
    }

    public SL_FAN_STATUS_T[] getfanStatus() {
        return this.fanStatus;
    }

    public SL_TEMP_SENSOR_STATUS_T[] gettsStatus() {
        return this.tsStatus;
    }

    public SL_ALARM_STATUS_T[] getalarmStatus() {
        return this.alarmStatus;
    }

    public SL_SIM_STATUS_T[] getsimStatus() {
        return this.simStatus;
    }

    public char getenclPosition() {
        if (this.enclInfo != null) {
            return this.enclInfo.getenclPosition();
        }
        return '0';
    }

    public char getenclConnectorIndex() {
        return this.enclInfo.getenclConnectorIndex();
    }

    public MR_ENCL_INFO getMR_ENCL_INFO() {
        return this.enclInfo;
    }

    private void setsize(int n) {
        this.size = n;
    }

    public void setslotCount(int n) {
        this.slotCount = n;
    }

    public void setpsCount(int n) {
        this.psCount = n;
    }

    public void setfanCount(int n) {
        this.fanCount = n;
    }

    public void settsCount(int n) {
        this.tsCount = n;
    }

    public void setalarmCount(int n) {
        this.alarmCount = n;
    }

    public void setsimCount(int n) {
        this.simCount = n;
    }

    public void setslotStatus(SL_SLOT_STATUS_T[] sL_SLOT_STATUS_TArray) {
        this.setsize(this.getsize() + (sL_SLOT_STATUS_TArray.length - this.getslotCount()) * 8);
        this.setslotCount(sL_SLOT_STATUS_TArray.length);
        this.slotStatus = sL_SLOT_STATUS_TArray;
    }

    public void setpsStatus(SL_POWER_SUPPLY_STATUS_T[] sL_POWER_SUPPLY_STATUS_TArray) {
        this.setsize(this.getsize() + (sL_POWER_SUPPLY_STATUS_TArray.length - this.getpsCount()) * 8);
        this.setpsCount(sL_POWER_SUPPLY_STATUS_TArray.length);
        this.psStatus = sL_POWER_SUPPLY_STATUS_TArray;
    }

    public void setfanStatus(SL_FAN_STATUS_T[] sL_FAN_STATUS_TArray) {
        this.setsize(this.getsize() + (sL_FAN_STATUS_TArray.length - this.getfanCount()) * 8);
        this.setfanCount(sL_FAN_STATUS_TArray.length);
        this.fanStatus = sL_FAN_STATUS_TArray;
    }

    public void settsStatus(SL_TEMP_SENSOR_STATUS_T[] sL_TEMP_SENSOR_STATUS_TArray) {
        this.setsize(this.getsize() + (sL_TEMP_SENSOR_STATUS_TArray.length - this.gettsCount()) * 8);
        this.settsCount(sL_TEMP_SENSOR_STATUS_TArray.length);
        this.tsStatus = sL_TEMP_SENSOR_STATUS_TArray;
    }

    public void setalarmStatus(SL_ALARM_STATUS_T[] sL_ALARM_STATUS_TArray) {
        this.setsize(this.getsize() + (sL_ALARM_STATUS_TArray.length - this.getalarmCount()) * 8);
        this.setalarmCount(sL_ALARM_STATUS_TArray.length);
        this.alarmStatus = sL_ALARM_STATUS_TArray;
    }

    public void setsimStatus(SL_SIM_STATUS_T[] sL_SIM_STATUS_TArray) {
        this.setsize(this.getsize() + (sL_SIM_STATUS_TArray.length - this.getsimCount()) * 8);
        this.setsimCount(sL_SIM_STATUS_TArray.length);
        this.simStatus = sL_SIM_STATUS_TArray;
    }
}

