/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import Services.KernelConstants;
import Services.NetworkToJavaConverter;
import Services.VivaldiDataInputStream;
import java.io.IOException;

public class SL_VOLTAGE_SENSOR_STATUS_T {
    public static final byte SL_VOLTAGE_SENSOR_STATUS_T_SIZE = 8;
    private int m_iVoltageSensorStatusPage = 0;
    private int m_iVoltageSensorStatusVal = 0;
    private int m_iVoltageInMilliVolts = 0;
    private boolean m_isNegativeVoltage = false;
    private boolean m_isCriticalUnder = false;
    private boolean m_isCriticalOver = false;
    private boolean m_isWarningUnder = false;
    private boolean m_isWarningOver = false;

    public SL_VOLTAGE_SENSOR_STATUS_T(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        VivaldiDataInputStream vivaldiDataInputStream = new VivaldiDataInputStream(byArray);
        try {
            int n2;
            vivaldiDataInputStream.skipBytes(n);
            this.m_iVoltageSensorStatusPage = vivaldiDataInputStream.readInt();
            this.m_iVoltageSensorStatusVal = vivaldiDataInputStream.readInt();
            int n3 = n2 = 8;
            n2 = (byte)(n2 + 1);
            this.m_isCriticalUnder = KernelConstants.getBitValue(this.m_iVoltageSensorStatusPage, n3) == 1;
            int n4 = n2;
            n2 = (byte)(n2 + 1);
            this.m_isCriticalOver = KernelConstants.getBitValue(this.m_iVoltageSensorStatusPage, n4) == 1;
            int n5 = n2;
            n2 = (byte)(n2 + 1);
            this.m_isWarningUnder = KernelConstants.getBitValue(this.m_iVoltageSensorStatusPage, n5) == 1;
            this.m_isWarningOver = KernelConstants.getBitValue(this.m_iVoltageSensorStatusPage, n2) == 1;
            byte[] byArray2 = new byte[4];
            NetworkToJavaConverter.intToByteArray(this.m_iVoltageSensorStatusPage, byArray2);
            this.m_iVoltageInMilliVolts = NetworkToJavaConverter.byteArrayToShort(byArray2, 2);
            if ((this.m_iVoltageInMilliVolts & 0x8000) == 0) {
                this.m_iVoltageInMilliVolts *= 10;
            } else {
                this.m_iVoltageInMilliVolts ^= 0xFFFFFFFF;
                ++this.m_iVoltageInMilliVolts;
                this.m_iVoltageInMilliVolts *= 10;
                this.m_isNegativeVoltage = true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getVoltageSensoreStatusPage() {
        return this.m_iVoltageSensorStatusPage;
    }

    public int getVoltageSensorStatusVal() {
        return this.m_iVoltageSensorStatusVal;
    }

    public boolean isCriticalUnder() {
        return this.m_isCriticalUnder;
    }

    public boolean isCriticalOver() {
        return this.m_isCriticalOver;
    }

    public boolean isWarningUnder() {
        return this.m_isWarningUnder;
    }

    public boolean isWarningOver() {
        return this.m_isWarningOver;
    }

    public double getVoltageInVolts() {
        return (double)this.m_iVoltageInMilliVolts / 1000.0;
    }

    public boolean isVoltageIsInNegative() {
        return this.m_isNegativeVoltage;
    }
}

