/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASAdapter;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_CAPACITY_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_DESIGN_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_MFG_2;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASAdapter.SASBBUInformation;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.util.Observable;

public class SASBatteryBackUp
extends Observable
implements ISASObject,
AENHandlerInterface {
    private SASAdapter sasAdapter;
    private MR_BBU_CAPACITY_INFO mrBBUCapacityInfo;
    private MR_BBU_DESIGN_INFO mrBBUDesignInfo;
    private MR_BBU_PROPERTIES mrBBUProperties;
    private MR_BBU_STATUS mrBBUStatusInfo;
    private static final byte MR_BBU_AUTO_LEARN_AUTO = 0;
    private static final byte MR_BBU_AUTO_LEARN_DISABLED = 1;
    private static final byte MR_BBU_AUTO_LEARN_WARN = 2;
    private static final byte MR_BBU_AUTO_TRANSPARENT = 3;

    public SASBatteryBackUp(SASAdapter sASAdapter) throws VKNotRespondingException, VKOperationFailedException {
        this.sasAdapter = sASAdapter;
        this.refresh();
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        Object object;
        int n = 0;
        switch (operationDetails.getOpcode()) {
            case 3: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 48, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                object = new MR_BBU_FW_STATUS(byArray, 44);
                operationDetails.setParameter(object);
                break;
            }
            case 6: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 48, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 1: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 48, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                object = new MR_BBU_CAPACITY_INFO(byArray, 44);
                operationDetails.setParameter(object);
                break;
            }
            case 2: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 64, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                object = new MR_BBU_DESIGN_INFO(byArray, 44);
                operationDetails.setParameter(object);
                break;
            }
            case 4: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 32, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                object = new MR_BBU_PROPERTIES(byArray, 44);
                operationDetails.setParameter(object);
                break;
            }
            case 0: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 64, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                object = new MR_BBU_STATUS(byArray, 44);
                operationDetails.setParameter(object);
                break;
            }
            case 5: {
                NetworkDataPacket networkDataPacket = ((SASAdapter)this.parent()).storeLibOperation((byte)5, 32, ((MR_BBU_PROPERTIES)operationDetails.getParam()).getByteArray(), operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 17695490: {
                object = new byte[32];
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setflags('\u0002');
                sL_DCMD_INPUT_T.setpData((byte[])object);
                try {
                    byte[] byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                    n = NetworkToJavaConverter.byteArrayToInt(byArray);
                    System.out.println("returnValue: " + n);
                    operationDetails.setParameter(new MR_MFC_MFG_2(byArray, 32));
                    break;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    operationDetails.setParameter(null);
                }
            }
        }
        if (n != 0) {
            System.out.println("SASBatteryBackUp.fireOperation()->retval = " + n);
            object = operationDetails.getParam();
            if (object instanceof MR_BBU_FW_STATUS) {
                throw new VKOperationFailedException(n, object);
            }
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    @Override
    public short getID() {
        return 0;
    }

    @Override
    public short getSeqNum() {
        return 0;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        switch (n) {
            case 3: {
                try {
                    if (this.mrBBUProperties.getautoLearnMode() == 0) {
                        return false;
                    }
                    if (this.mrBBUStatusInfo.getMrbbufwStatus().getlearnCycleActive()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                return true;
            }
            case 6: {
                return true;
            }
        }
        return true;
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public void notifyMethod(Object object) {
    }

    @Override
    public ISASObject parent() {
        return this.sasAdapter;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        return 0;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        this.createInformation();
        return false;
    }

    private void createInformation() throws VKNotRespondingException, VKOperationFailedException {
        try {
            this.mrBBUDesignInfo = this.getDesignInfo();
            this.mrBBUProperties = this.getProperties();
            this.mrBBUStatusInfo = this.getStatus();
            if (this.mrBBUStatusInfo.getbatteryType() != '\u0006') {
                this.mrBBUCapacityInfo = this.getCapacityInfo();
            }
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw new VKOperationFailedException(4096);
        }
    }

    private MR_BBU_CAPACITY_INFO getCapacityInfo() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(1, null);
        this.fireOperation(operationDetails);
        return (MR_BBU_CAPACITY_INFO)operationDetails.getParam();
    }

    public MR_BBU_DESIGN_INFO getDesignInfo() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(2, null);
        this.fireOperation(operationDetails);
        return (MR_BBU_DESIGN_INFO)operationDetails.getParam();
    }

    private MR_BBU_PROPERTIES getProperties() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(4, null);
        this.fireOperation(operationDetails);
        return (MR_BBU_PROPERTIES)operationDetails.getParam();
    }

    public MR_BBU_STATUS getStatus() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(0, null);
        this.fireOperation(operationDetails);
        return (MR_BBU_STATUS)operationDetails.getParam();
    }

    public MR_MFC_MFG_2 getBatteryFRUProperties() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        MR_MFC_MFG_2 mR_MFC_MFG_2 = null;
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(32);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setopCode(17695490);
            sL_DCMD_INPUT_T.setpData(new byte[32]);
            byte[] byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            mR_MFC_MFG_2 = new MR_MFC_MFG_2(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mR_MFC_MFG_2;
    }

    public void setProperties(MR_BBU_PROPERTIES mR_BBU_PROPERTIES) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(5, mR_BBU_PROPERTIES);
        this.fireOperation(operationDetails);
    }

    public SASBBUInformation getInformation() {
        return new SASBBUInformation(this.mrBBUCapacityInfo, this.mrBBUDesignInfo, this.mrBBUProperties, this.mrBBUStatusInfo);
    }

    @Override
    public boolean handleAEN(Object object) {
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)object;
        NotifyObject notifyObject = new NotifyObject(0x102000 | mR_EVT_DETAIL.getargType(), mR_EVT_DETAIL);
        try {
            this.createInformation();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setChanged();
        this.notifyObservers(notifyObject);
        return false;
    }
}

