/*
 * Decompiled with CFR 0.152.
 */
package SASKernel;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelNetwork.KernelNetworkManager;
import KernelServices.NotifyObject;
import KernelServices.SimpleStatusNotification;
import SASKernel.AENHandlerInterface;
import SASKernel.ClientInfo;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASServer;
import Services.FrameworkUtilities;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class SASKernel
extends Observable
implements ISASObject,
Observer,
AENHandlerInterface {
    private static String FRAMEWORK_IP = null;
    private static int OEM_TYPE = 71244;
    private KernelNetworkManager kernelNetworkManager;
    private ArrayList sasServerArrayList = new ArrayList();
    private ArrayList dupSasServerArrayList = new ArrayList();
    private int curServer = -1;
    private Thread callBackThread;
    private static SASKernel sasKernel = null;
    private ClientInfo clientInfo;
    private String frameworkWWN;
    public static boolean isLocalStandAlone = false;
    public static final int NOTIFY_AEN = 1;
    public static final int NOTIFY_SPLASH = 2;
    public static final int NOTIFY_DEBUG = 4;
    private static int notificationLevel = 1;
    public static final String LOOP_BACK_ADDRESS = "127.0.0.1";

    private SASKernel(String string) throws IOException, VKOperationFailedException, VivaldiFrameworkProtocolErrorException {
        FRAMEWORK_IP = string;
        this.clientInfo = new ClientInfo();
        this.kernelNetworkManager = new KernelNetworkManager(this, 3071, isLocalStandAlone);
        this.kernelNetworkManager.setServerIP(string);
        this.kernelNetworkManager.start();
        try {
            do {
                Thread.sleep(100L);
            } while (this.kernelNetworkManager.getServerConnectionInstance().getPort() == -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registerWithFramework();
    }

    private SASKernel(String string, int n, int n2) throws IOException, VKOperationFailedException, VivaldiFrameworkProtocolErrorException {
        FRAMEWORK_IP = string;
        this.clientInfo = new ClientInfo();
        this.kernelNetworkManager = new KernelNetworkManager(this, 3071, isLocalStandAlone);
        this.kernelNetworkManager.setServerIP(string);
        this.kernelNetworkManager.start();
        try {
            do {
                Thread.sleep(100L);
            } while (this.kernelNetworkManager.getServerConnectionInstance().getPort() == -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registerWithFramework(n, n2);
    }

    public static SASKernel getInstance() throws IOException, VKOperationFailedException, VivaldiFrameworkProtocolErrorException {
        if (sasKernel == null) {
            sasKernel = new SASKernel(null);
        }
        return sasKernel;
    }

    public static SASKernel getInstance(String string) throws IOException, VKOperationFailedException, VivaldiFrameworkProtocolErrorException {
        if (sasKernel != null) {
            SASKernel sASKernel = new SASKernel(string);
            return sASKernel;
        }
        sasKernel = new SASKernel(string);
        sasKernel.setServerIP(string);
        return sasKernel;
    }

    public static SASKernel getInstance(String string, int n, int n2) throws IOException, VKOperationFailedException, VivaldiFrameworkProtocolErrorException {
        sasKernel = null;
        if (sasKernel == null) {
            sasKernel = new SASKernel(string, n, n2);
        }
        return sasKernel;
    }

    @Override
    public short getID() {
        return 0;
    }

    @Override
    public short getSeqNum() {
        return 0;
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return null;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        return true;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        return false;
    }

    @Override
    public void notifyMethod(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public void notifyPopup(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public void destroyPopup(String string) {
        try {
            this.unRegisterWithFramework(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unRegisterWithFramework(String string) throws IOException {
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(258, byArray, 0);
        byte[] byArray2 = NetworkPacket.convertWWNStringToByteArray(this.getframeworkWWN());
        byte[] byArray3 = NetworkPacket.convertWWNStringToByteArray(string);
        System.arraycopy(byArray2, 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(byArray3.length, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray3);
        try {
            int n = this.kernelNetworkManager.getClientConnectionInstance().processCommand(byArray, networkDataPacket);
            sasKernel.notifyPopup(null);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
    }

    private void setDefaultFrameworkIP(String string) {
        FRAMEWORK_IP = string;
    }

    public String getDefaultFrameworkIP() {
        return FRAMEWORK_IP;
    }

    public void changeDefaultFramework(String string) throws VKNotRespondingException, VKOperationFailedException, VivaldiFrameworkProtocolErrorException {
        String string2 = this.getDefaultFrameworkIP();
        try {
            this.unRegisterWithFramework();
            this.setDefaultFrameworkIP(string);
            this.registerWithFramework();
            return;
        }
        catch (Exception exception) {
            try {
                this.setDefaultFrameworkIP(string2);
                this.registerWithFramework();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof IOException) {
                throw new VKNotRespondingException(5);
            }
            if (exception instanceof VKOperationFailedException) {
                throw (VKOperationFailedException)exception;
            }
            if (exception instanceof VKNotRespondingException) {
                throw (VKNotRespondingException)exception;
            }
            if (exception instanceof VivaldiFrameworkProtocolErrorException) {
                throw (VivaldiFrameworkProtocolErrorException)exception;
            }
            return;
        }
    }

    public KernelNetworkManager getNetworkManager() {
        return this.kernelNetworkManager;
    }

    public SASServer[] queryServerList() throws IOException, VKOperationFailedException {
        int n = 0;
        ArrayList arrayList = this.queryServerArrayList();
        SASServer[] sASServerArray = new SASServer[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            sASServerArray[n++] = (SASServer)iterator.next();
        }
        return sASServerArray;
    }

    public ArrayList queryServerArrayList() throws IOException, VKOperationFailedException {
        return this.queryServerArrayList(this.getframeworkWWN());
    }

    public ArrayList queryServerArrayList(String string) throws IOException, VKOperationFailedException {
        byte[] byArray = new byte[60];
        this.dupSasServerArrayList.clear();
        NetworkToJavaConverter.intToByteArray(262, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(0, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket();
        try {
            int n = this.kernelNetworkManager.getClientConnectionInstance().processCommand(byArray, networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
            if (n2 == 0) {
                try {
                    this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4097, this.getframeworkWWN())));
                    this.dupSasServerArrayList.add(new SASServer(0, this.getframeworkWWN(), this));
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    // empty catch block
                }
                return new ArrayList(this.dupSasServerArrayList);
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = 4 + i * 24;
                try {
                    String string2 = NetworkPacket.convertByteArrayToWWNString(byArray2, n4);
                    System.out.println("destFrameworkWWN :" + string2);
                    this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4097, string2)));
                    this.dupSasServerArrayList.add(new SASServer((short)n3++, string2, this));
                    continue;
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    // empty catch block
                }
            }
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return this.dupSasServerArrayList;
    }

    public ArrayList queryServerList(String string) throws IOException, VKOperationFailedException {
        byte[] byArray = new byte[60];
        ArrayList<String> arrayList = new ArrayList<String>();
        this.dupSasServerArrayList.clear();
        NetworkToJavaConverter.intToByteArray(262, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(0, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket();
        try {
            int n = this.kernelNetworkManager.getClientConnectionInstance().processCommand(byArray, networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
            if (n2 == 0) {
                arrayList.add(this.getIP(string));
                return arrayList;
            }
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                int n3 = 4 + i * 24;
                String string2 = NetworkPacket.convertByteArrayToWWNString(byArray2, n3);
                arrayList.add(this.getIP(string2));
            }
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return arrayList;
    }

    public void updateSasServerArrayListFromCache() {
        this.sasServerArrayList = new ArrayList(this.dupSasServerArrayList);
    }

    public void updateSASServerArrayList(SASServer sASServer) {
        this.dupSasServerArrayList.add(sASServer);
        this.sasServerArrayList = new ArrayList(this.dupSasServerArrayList);
    }

    public void destroyKernel() {
        try {
            this.unRegisterWithFramework();
            this.kernelNetworkManager.closeServerConnection();
            sasKernel = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        throw new VKInvalidOperationException(14);
    }

    public SASServer getLoggedinServer() {
        SASServer sASServer2 = null;
        for (SASServer sASServer2 : this.sasServerArrayList) {
            if (!sASServer2.isLoggedin()) continue;
            return sASServer2;
        }
        return null;
    }

    public ArrayList getSASServerArrayList() {
        return new ArrayList(this.sasServerArrayList);
    }

    public SASServer[] getSASServerList() {
        int n = 0;
        SASServer[] sASServerArray = new SASServer[this.sasServerArrayList.size()];
        Iterator iterator = this.sasServerArrayList.iterator();
        while (iterator.hasNext()) {
            sASServerArray[n++] = (SASServer)iterator.next();
        }
        return sASServerArray;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public String getframeworkWWN() {
        try {
            this.frameworkWWN = FRAMEWORK_IP == null ? FrameworkUtilities.getLocalHostAddress() + ":" + 3071 + ":" + 0 : FRAMEWORK_IP + ":" + 3071 + ":" + 0;
        }
        catch (Exception exception) {
            this.frameworkWWN = null;
        }
        return this.frameworkWWN;
    }

    private void registerWithFramework() throws IOException, VivaldiFrameworkProtocolErrorException {
        byte[] byArray = new byte[60];
        if (FRAMEWORK_IP == null || FrameworkUtilities.checkIfLocalAddress(FRAMEWORK_IP)) {
            NetworkToJavaConverter.intToByteArray(257, byArray, 0);
        } else {
            NetworkToJavaConverter.intToByteArray(268, byArray, 0);
        }
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(FrameworkUtilities.getLocalHostAddress() + ":0:0"), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getframeworkWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(512, byArray, 56);
        byte[] byArray2 = new byte[512];
        this.clientInfo.setListenPort(this.kernelNetworkManager.getServerConnectionInstance().getPort());
        System.arraycopy(this.clientInfo.getBytes(), 0, byArray2, 0, byArray2.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        int n = this.kernelNetworkManager.getClientConnectionInstance().processCommand(byArray, 0, networkDataPacket);
        this.clientInfo.setWWN(NetworkPacket.convertByteArrayToWWNString(networkDataPacket.getDataBuffer()));
    }

    private void registerWithFramework(int n, int n2) throws IOException, VivaldiFrameworkProtocolErrorException {
        byte[] byArray = new byte[60];
        if (FRAMEWORK_IP == null || FrameworkUtilities.checkIfLocalAddress(FRAMEWORK_IP)) {
            NetworkToJavaConverter.intToByteArray(257, byArray, 0);
        } else {
            NetworkToJavaConverter.intToByteArray(268, byArray, 0);
        }
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(FrameworkUtilities.getLocalHostAddress() + ":0:0"), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getframeworkWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(512, byArray, 56);
        byte[] byArray2 = new byte[512];
        int n3 = this.kernelNetworkManager.getServerConnectionInstance().getPort();
        this.clientInfo.setListenPort(n3);
        this.clientInfo.setMajorNumber(n);
        this.clientInfo.setMinorNumber(n2);
        System.arraycopy(this.clientInfo.getBytes(), 0, byArray2, 0, byArray2.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        int n4 = this.kernelNetworkManager.getClientConnectionInstance().processCommand(byArray, networkDataPacket);
        this.clientInfo.setWWN(NetworkPacket.convertByteArrayToWWNString(networkDataPacket.getDataBuffer()));
    }

    private void unRegisterWithFramework() throws IOException {
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(258, byArray, 0);
        byte[] byArray2 = NetworkPacket.convertWWNStringToByteArray(this.getframeworkWWN());
        byte[] byArray3 = NetworkPacket.convertWWNStringToByteArray(this.clientInfo.getWWN());
        System.arraycopy(byArray2, 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(byArray3.length, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray3);
        try {
            int n = this.kernelNetworkManager.getClientConnectionInstance().processCommand(byArray, networkDataPacket);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
    }

    public void finalize() {
        this.destroyKernel();
        this.kernelNetworkManager.shutdown();
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        return 0;
    }

    public String getSASKernelVersion() {
        return this.clientInfo.getVersion();
    }

    public static void setSplashNotification(boolean bl) {
        notificationLevel = bl ? (notificationLevel |= 2) : (notificationLevel &= 0xFFFFFFFD);
    }

    public static void setDebugNotification(boolean bl) {
        notificationLevel = bl ? (notificationLevel |= 4) : (notificationLevel &= 0xFFFFFFFB);
    }

    public static int getNotificationLevel() {
        return notificationLevel;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof NotifyObject)) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        switch (notifyObject.getNotifyCode()) {
            case 0x101001: 
            case 2101251: 
            case 0x401004: {
                this.notifyMethod(object);
                break;
            }
        }
    }

    public static void setOemType(int n) {
        OEM_TYPE = n;
    }

    public static int getOemType() {
        return OEM_TYPE;
    }

    public SASServer getSingleServer() throws Exception {
        SASServer sASServer = new SASServer(0, FRAMEWORK_IP + ":" + 3071 + ":" + 0, this);
        this.dupSasServerArrayList.clear();
        this.dupSasServerArrayList.add(sASServer);
        return sASServer;
    }

    public SASServer getSingleServer(String string) throws Exception {
        SASServer sASServer = new SASServer(0, string + ":" + 3071 + ":" + 0, this);
        this.dupSasServerArrayList.clear();
        this.dupSasServerArrayList.add(sASServer);
        return sASServer;
    }

    public SASServer getSpecificServer(String string) throws Exception {
        String string2 = string + ":" + 3071 + ":" + 0;
        this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4097, string2)));
        SASServer sASServer = new SASServer(0, string2, this);
        this.dupSasServerArrayList.clear();
        this.dupSasServerArrayList.add(sASServer);
        return sASServer;
    }

    public SASServer getSpecificServer(String string, short s) throws Exception {
        String string2 = string + ":" + 3071 + ":" + 0;
        this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4097, string2)));
        SASServer sASServer = new SASServer(s, string2, this);
        this.dupSasServerArrayList.add(sASServer);
        return sASServer;
    }

    @Override
    public boolean handleAEN(Object object) {
        NetworkPacket networkPacket = (NetworkPacket)object;
        byte[] byArray = networkPacket.getDatabuffer();
        MR_EVT_DETAIL mR_EVT_DETAIL = new MR_EVT_DETAIL(byArray, 12);
        this.notifyMethod(mR_EVT_DETAIL);
        return true;
    }

    public void clearServerArrayList() {
        this.dupSasServerArrayList.clear();
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }

    public static boolean isLocalStandAlone() {
        return isLocalStandAlone;
    }

    public static void setLocalStandAlone(boolean bl) {
        isLocalStandAlone = bl;
    }

    public void setServerIP(String string) {
        this.kernelNetworkManager.setServerIP(this.getIP(string));
    }
}

